/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import java.util.Date;
import play.Logger;
import play.Play;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.producer.RabbitMQProducer;
import play.modules.rabbitmq.stats.StatsEvent;
import play.modules.rabbitmq.util.ExceptionUtil;

public abstract class RabbitMQPublisher {
    public static void publish(String queueName, Object message) {
        new RabbitMQPublisherJob(queueName, message).now();
    }

    public static void publish(String queueName, String routingKey, Object message) {
        new RabbitMQPublisherJob(queueName, routingKey, message).now();
    }

    protected static class RabbitMQPublisherJob
    extends Job {
        private Object message;
        private String routingKey;
        private String queueName;

        public RabbitMQPublisherJob(String queueName, Object message) {
            this(queueName, queueName, message);
        }

        public RabbitMQPublisherJob(String queueName, String routingKey, Object message) {
            this.queueName = queueName;
            this.routingKey = routingKey;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doJob() {
            Channel channel = null;
            long executionTime = 0L;
            try {
                long start = new Date().getTime();
                RabbitMQProducer producer = ((Object)((Object)this)).getClass().getAnnotation(RabbitMQProducer.class);
                if (producer == null && this.queueName == null) {
                    throw new RuntimeException("Please define annotation @RabbitMQProducer.");
                }
                RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
                channel = plugin.createChannel(this.queueName, this.routingKey);
                if (channel == null) {
                    throw new RuntimeException("Error creating a communication channel with RabbitMQ. Please verify the health of your RabbitMQ node and check your configuration.");
                }
                channel.basicPublish(this.queueName, this.routingKey, plugin.getBasicProperties(), this.getBytes());
                executionTime = new Date().getTime() - start;
                Logger.info((String)"Message %s has been published to queue %s (execution time: %s ms)", (Object[])new Object[]{this.message, this.queueName, executionTime});
                RabbitMQPlugin.statsService().record(this.queueName, StatsEvent.Type.PRODUCER, StatsEvent.Status.SUCCESS, executionTime);
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                RabbitMQPlugin.statsService().record(this.queueName, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR, executionTime);
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable t) {
                        Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                    }
                }
            }
        }

        private byte[] getBytes() throws Exception {
            return RabbitMQPlugin.mapper().getBytes(this.message);
        }
    }
}

