/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class ByteBufferTemplate
implements Template {
    static final ByteBufferTemplate instance = new ByteBufferTemplate();

    private ByteBufferTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packByteBuffer((ByteBuffer)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackByteBuffer();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        byte[] bytes = from.asByteArray();
        return ByteBuffer.wrap(bytes);
    }

    public static ByteBufferTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(ByteBuffer.class, instance);
    }
}

