/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class LongArrayTemplate
implements Template {
    static final LongArrayTemplate instance = new LongArrayTemplate();

    private LongArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof long[])) {
            throw new MessageTypeException();
        }
        long[] array = (long[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (long a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        long[] array = to != null && to instanceof long[] && ((long[])to).length == length ? (long[])to : new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackLong();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        long[] array = to != null && to instanceof long[] && ((long[])to).length == src.length ? (long[])to : new long[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asLong();
        }
        return array;
    }

    public static LongArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(long[].class, instance);
    }
}

