/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.util.ArrayList;
import java.util.List;
import org.msgpack.template.FieldOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldList {
    private ArrayList<Entry> list = new ArrayList();

    public void add(String name) {
        this.add(name, FieldOption.REQUIRED);
    }

    public void add(String name, FieldOption option) {
        this.list.add(new Entry(name, option));
    }

    public void put(int index, String name) {
        this.put(index, name, FieldOption.REQUIRED);
    }

    public void put(int index, String name, FieldOption option) {
        if (this.list.size() < index) {
            do {
                this.list.add(new Entry());
            } while (this.list.size() < index);
            this.list.add(new Entry(name, option));
        } else {
            this.list.set(index, new Entry(name, option));
        }
    }

    public List<Entry> getList() {
        return this.list;
    }

    public static class Entry {
        private String name;
        private FieldOption option;

        public Entry() {
            this.name = null;
            this.option = FieldOption.IGNORE;
        }

        public Entry(String name, FieldOption option) {
            this.name = name;
            this.option = option;
        }

        public String getName() {
            return this.name;
        }

        public FieldOption getOption() {
            return this.option;
        }

        public boolean isAvailable() {
            return this.option != FieldOption.IGNORE;
        }

        public boolean isRequired() {
            return this.option == FieldOption.REQUIRED;
        }

        public boolean isOptional() {
            return this.option == FieldOption.OPTIONAL;
        }

        public boolean isNullable() {
            return this.option == FieldOption.NULLABLE;
        }
    }
}

