/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import play.Play;

public class CheatSheetHelper {
    private static final File cheatSheetBaseDir = new File(Play.frameworkPath, "documentation/cheatsheets");

    public static File[] getSheets(String category) {
        File cheatSheetDir = new File(cheatSheetBaseDir, category);
        if (cheatSheetDir.exists() && cheatSheetDir.isDirectory()) {
            File[] sheetFiles = cheatSheetDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".textile");
                }
            });
            Arrays.sort(sheetFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    String o1 = f1.getName();
                    String o2 = f2.getName();
                    if (o1.contains("-") && o2.contains("-")) {
                        return o1.substring(0, o1.indexOf("-")).compareTo(o2.substring(0, o1.indexOf("-")));
                    }
                    return o1.compareTo(o2);
                }
            });
            return sheetFiles;
        }
        return null;
    }

    public static String getCategoryTitle(String category) {
        String[] parts = category.trim().split("(?<!^)(?=[A-Z])");
        StringBuilder title = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > 0) {
                title.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() > 1) {
                    title.append(part.substring(1));
                }
                title.append(" ");
            }
            ++n2;
        }
        return title.toString().trim();
    }

    public static Map<String, String> listCategoriesAndTitles() {
        Object[] categories = cheatSheetBaseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        Arrays.sort(categories);
        LinkedHashMap<String, String> categoriesAndTitles = new LinkedHashMap<String, String>();
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            categoriesAndTitles.put(((File)category).getName(), CheatSheetHelper.getCategoryTitle(((File)category).getName()));
            ++n2;
        }
        return categoriesAndTitles;
    }
}

