/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import play.Logger;
import play.Play;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.consumer.RabbitMQMessageConsumerJob;
import play.modules.rabbitmq.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RabbitMQConsumer<T>
extends Job<T> {
    public static int retries = RabbitMQPlugin.retries();

    protected abstract void consume(T var1);

    protected Channel createChannel(RabbitMQPlugin plugin) throws Exception {
        Channel channel = plugin.createChannel(this.queue(), this.routingKey());
        return channel;
    }

    protected QueueingConsumer createConsumer(Channel channel, RabbitMQPlugin plugin) throws Exception {
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(this.queue(), plugin.isAutoAck(), (Consumer)consumer);
        Logger.info((String)("RabbitMQ Consumer - Channel: %s, Consumer: %s " + channel), (Object[])new Object[]{consumer});
        return consumer;
    }

    public void doJob() {
        this.goGetHerSon();
    }

    protected abstract Class getMessageType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void goGetHerSon() {
        RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
        Channel channel = null;
        QueueingConsumer consumer = null;
        Long deliveryTag = null;
        while (true) {
            Object var11_12;
            Throwable t32;
            QueueingConsumer.Delivery task;
            Logger.info((String)("Entering main loop on consumer: " + (Object)((Object)this)), (Object[])new Object[0]);
            if (channel == null || channel != null && !channel.isOpen()) {
                consumer = null;
                channel = this.createChannel(plugin);
            }
            if (consumer == null) {
                consumer = this.createConsumer(channel, plugin);
            }
            if ((task = consumer.nextDelivery()) != null && task.getBody() != null) {
                try {
                    deliveryTag = task.getEnvelope().getDeliveryTag();
                    T message = this.toObject(task.getBody());
                    new RabbitMQMessageConsumerJob<T>(channel, deliveryTag, this.queue(), this, message, this.retries()).doJobWithResult();
                }
                catch (Throwable t2) {
                    Logger.error((String)ExceptionUtil.getStackTrace(t2), (Object[])new Object[0]);
                }
            }
            Object var8_10 = null;
            if (channel == null) continue;
            try {
                if (deliveryTag != null && channel.isOpen()) {
                    channel.basicAck(deliveryTag.longValue(), false);
                }
            }
            catch (Throwable e) {
                Logger.error((String)ExceptionUtil.getStackTrace("Error doing a basicAck for tag: " + deliveryTag, e), (Object[])new Object[0]);
            }
            try {
                block31: {
                    try {
                        if (channel.getConnection() != null && channel.getConnection().isOpen()) {
                            channel.getConnection().close();
                        }
                        if (!channel.isOpen()) break block31;
                        channel.close();
                    }
                    catch (Throwable t32) {
                        Logger.error((String)ExceptionUtil.getStackTrace(t32), (Object[])new Object[0]);
                        var11_12 = null;
                        channel = null;
                    }
                }
                var11_12 = null;
                channel = null;
            }
            catch (Throwable throwable) {
                var11_12 = null;
                channel = null;
                throw throwable;
            }
            {
                catch (Throwable t4) {
                    Logger.error((String)"Error creating consumer channel to RabbitMQ, retrying in a few seconds. Exception: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(t4)});
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Logger.error((String)ExceptionUtil.getStackTrace(t4), (Object[])new Object[0]);
                    }
                    var8_10 = null;
                    if (channel == null) continue;
                    try {
                        if (deliveryTag != null && channel.isOpen()) {
                            channel.basicAck(deliveryTag.longValue(), false);
                        }
                    }
                    catch (Throwable e) {
                        Logger.error((String)ExceptionUtil.getStackTrace("Error doing a basicAck for tag: " + deliveryTag, e), (Object[])new Object[0]);
                    }
                    try {
                        block33: {
                            try {
                                if (channel.getConnection() != null && channel.getConnection().isOpen()) {
                                    channel.getConnection().close();
                                }
                                if (!channel.isOpen()) break block33;
                                channel.close();
                            }
                            catch (Throwable t32) {
                                Logger.error((String)ExceptionUtil.getStackTrace(t32), (Object[])new Object[0]);
                                var11_12 = null;
                                channel = null;
                                continue;
                            }
                        }
                        var11_12 = null;
                        channel = null;
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        channel = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                var8_10 = null;
                if (channel == null) throw throwable;
                try {
                    if (deliveryTag != null && channel.isOpen()) {
                        channel.basicAck(deliveryTag.longValue(), false);
                    }
                }
                catch (Throwable e) {
                    Logger.error((String)ExceptionUtil.getStackTrace("Error doing a basicAck for tag: " + deliveryTag, e), (Object[])new Object[0]);
                }
                try {
                    block34: {
                        try {
                            if (channel.getConnection() != null && channel.getConnection().isOpen()) {
                                channel.getConnection().close();
                            }
                            if (!channel.isOpen()) break block34;
                            channel.close();
                        }
                        catch (Throwable t32) {
                            Logger.error((String)ExceptionUtil.getStackTrace(t32), (Object[])new Object[0]);
                            var11_12 = null;
                            channel = null;
                            throw throwable;
                        }
                    }
                    var11_12 = null;
                    channel = null;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    var11_12 = null;
                    channel = null;
                    throw throwable2;
                }
            }
        }
    }

    protected abstract String queue();

    protected String routingKey() {
        return this.queue();
    }

    protected int retries() {
        return retries;
    }

    protected T toObject(byte[] bytes) throws Exception {
        return (T)RabbitMQPlugin.mapper().getObject(this.getMessageType(), bytes);
    }
}

