/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.stats;

import play.libs.F;
import play.modules.rabbitmq.stats.Stats;
import play.modules.rabbitmq.stats.StatsEvent;

public class StatsService {
    public Stats<StatsEvent> stats = new Stats();
    public F.EventStream<String> liveStream = new F.EventStream();

    public void record(String queue, StatsEvent.Type type, StatsEvent.Status status, long executionTime) {
        StatsEvent event = new StatsEvent(queue, type, status);
        this.stats.record(event, executionTime);
        String color = "green";
        if (status.equals((Object)StatsEvent.Status.ERROR)) {
            color = "red";
        }
        String coloredStatus = String.format("<font color='%s'>%s</font>", new Object[]{color, status});
        String msg = String.format("RabbitMQ <strong>%s</strong> Event - Queue: <strong>%s</strong>, Status: %s, Execution Time: <strong>%s milisecond(s)</strong>.", new Object[]{type, queue, coloredStatus, executionTime});
        this.liveStream.publish((Object)msg);
    }

    public long executions(String queue, StatsEvent.Type type, StatsEvent.Status status) {
        StatsEvent event = new StatsEvent(queue, type, status);
        return this.stats.executions(event);
    }

    public long averageTime(String queue, StatsEvent.Type type, StatsEvent.Status status) {
        StatsEvent event = new StatsEvent(queue, type, status);
        return this.stats.averageTime(event);
    }
}

