/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class ByteTemplate
implements Template {
    static final ByteTemplate instance = new ByteTemplate();

    private ByteTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packByte((Byte)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackByte();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asByte();
    }

    public static ByteTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Byte.class, instance);
        TemplateRegistry.register(Byte.TYPE, instance);
    }
}

