/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.http.header.ContentTypeReader;

public class ContentType {
    private volatile CharacterSet characterSet;
    private volatile MediaType mediaType;

    public static MediaType readMediaType(String contentType) {
        return new ContentType(contentType).getMediaType();
    }

    public static CharacterSet readCharacterSet(String contentType) {
        return new ContentType(contentType).getCharacterSet();
    }

    public ContentType(MediaType mediaType, CharacterSet characterSet) {
        this.mediaType = mediaType;
        this.characterSet = characterSet;
    }

    public ContentType(String headerValue) {
        try {
            ContentTypeReader ctr = new ContentTypeReader(headerValue);
            ContentType ct = ctr.readValue();
            if (ct != null) {
                this.mediaType = ct.getMediaType();
                this.characterSet = ct.getCharacterSet();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("The Content Type could not be read.", ioe);
        }
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }
}

