/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import java.util.Date;
import play.Logger;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.consumer.RabbitMQConsumer;
import play.modules.rabbitmq.exception.RabbitMQNotRetriableException;
import play.modules.rabbitmq.stats.StatsEvent;
import play.modules.rabbitmq.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitMQMessageConsumerJob<T>
extends Job<T> {
    private T message;
    private RabbitMQConsumer consumer;
    private int retries;
    private Channel channel;
    private long deliveryTag;
    private String queue;

    public RabbitMQMessageConsumerJob(Channel channel, long deliveryTag, String queue, RabbitMQConsumer consumer, T message, int retries) {
        this.consumer = consumer;
        this.message = message;
        this.retries = retries;
        this.channel = channel;
        this.deliveryTag = deliveryTag;
        this.queue = queue;
    }

    public void doJob() {
        boolean success = false;
        Throwable exception = null;
        long executionTime = 0L;
        for (int retryCount = 0; retryCount < this.retries + 1; ++retryCount) {
            if (retryCount > 0) {
                Logger.info((String)"Retrying to process message (%s) by consumer (%s) on queue (%s). Attempt %s of %s total retries.", (Object[])new Object[]{this.message, this.consumer, this.queue, retryCount, this.retries});
            }
            try {
                long start = new Date().getTime();
                this.consumer.consume(this.message);
                success = true;
                this.channel.basicAck(this.deliveryTag, false);
                executionTime = new Date().getTime() - start;
                Logger.info((String)"Message %s from queue %s has been processed by consumer %s (execution time: %s ms)", (Object[])new Object[]{this.message, this.queue, this.consumer, executionTime});
                RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.SUCCESS, executionTime);
                if (retryCount == 0) {
                    RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.SUCCESS_FIRST_ATTEMPT, executionTime);
                } else {
                    RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.SUCCESS_AFTER_RETRY, executionTime);
                }
            }
            catch (RabbitMQNotRetriableException e) {
                retryCount = Integer.MAX_VALUE;
                try {
                    this.channel.basicAck(this.deliveryTag, false);
                }
                catch (Throwable t) {
                    Logger.error((String)ExceptionUtil.getStackTrace("Error doing a basicAck for tag: " + this.deliveryTag, t), (Object[])new Object[0]);
                }
                exception = e;
                Logger.error((String)"Error processing message (%s) with consumer (%s). Exception (not a retriable exception): %s", (Object[])new Object[]{this.message, this.consumer, ExceptionUtil.getStackTrace(exception)});
                RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR, executionTime);
                if (retryCount == 0) {
                    RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR_FIRST_ATTEMPT, executionTime);
                    break;
                }
                RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR_AFTER_RETRY, executionTime);
                break;
            }
            catch (Throwable t) {
                exception = t;
                Logger.error((String)"Error processing message (%s) with consumer (%s). Exception: %s", (Object[])new Object[]{this.message, this.consumer, ExceptionUtil.getStackTrace(exception)});
                RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR, executionTime);
                if (retryCount == 0) {
                    RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR_FIRST_ATTEMPT, executionTime);
                }
                RabbitMQPlugin.statsService().record(this.queue, StatsEvent.Type.CONSUMER, StatsEvent.Status.ERROR_AFTER_RETRY, executionTime);
            }
            if (success) break;
        }
        if (!success) {
            Logger.error((String)"Final error processing message (%s) with consumer (%s). Last Exception: %s", (Object[])new Object[]{this.message, this.consumer, exception});
        }
        try {
            this.channel.basicAck(this.deliveryTag, false);
        }
        catch (Throwable e) {
            Logger.error((String)ExceptionUtil.getStackTrace("Error doing a basicAck for tag: " + this.deliveryTag, e), (Object[])new Object[0]);
        }
        if (this.channel != null && this.channel.getConnection() != null && this.channel.getConnection().isOpen()) {
            try {
                this.channel.getConnection().close();
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
            }
        }
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
            }
        }
    }
}

