/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.Modifier;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.ResteasyDeployment;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTEasyPlugin
extends PlayPlugin {
    public ResteasyDeployment deployment;
    public String path;
    private Map<String, Class<?>> resourceClasses = new HashMap();
    private Map<String, Class<?>> providerClasses = new HashMap();
    private boolean started;

    private static void log(String message, Object ... params) {
        Logger.info((String)("RESTEasy plugin: " + message), (Object[])params);
    }

    public void onConfigurationRead() {
        RESTEasyPlugin.log("Configuration read", new Object[0]);
        this.path = Play.configuration.getProperty("resteasy.path");
        if (this.path == null) {
            this.path = "/rest";
        }
    }

    public void onApplicationStart() {
        this.fixClassLoader();
        try {
            if (!this.started) {
                RESTEasyPlugin.log("Starting RESTEasy", new Object[0]);
                this.deploy();
                RESTEasyPlugin.log("RESTEasy started", new Object[0]);
                this.started = true;
            } else if (Play.mode != Play.Mode.PROD) {
                this.deploy();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void deploy() {
        List classes = Play.classes.all();
        this.deployment = new ResteasyDeployment();
        for (ApplicationClasses.ApplicationClass klass : classes) {
            if (!this.isJAXRSEntity(klass.javaClass, Path.class)) continue;
            RESTEasyPlugin.log("Found resource class: %s", klass.name);
            this.resourceClasses.put(klass.name, klass.javaClass);
        }
        this.deployment.setResourceClasses(new ArrayList<String>(this.resourceClasses.keySet()));
        for (ApplicationClasses.ApplicationClass klass : classes) {
            if (!this.isJAXRSEntity(klass.javaClass, Provider.class)) continue;
            RESTEasyPlugin.log("Found provider class: %s", klass.name);
            this.providerClasses.put(klass.name, klass.javaClass);
        }
        this.deployment.setProviderClasses(new ArrayList<String>(this.providerClasses.keySet()));
        this.deployment.start();
    }

    private void fixClassLoader() {
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
    }

    private boolean isJAXRSEntity(Class<?> javaClass, Class<? extends Annotation> annotation) {
        if (!this.hasAnnotation(javaClass, annotation)) {
            return false;
        }
        return !javaClass.isInterface() && !Modifier.isAbstract((int)javaClass.getModifiers());
    }

    private boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        for (Class<?> interfaceType : type.getInterfaces()) {
            if (!this.hasAnnotation(interfaceType, annotation)) continue;
            return true;
        }
        return this.hasAnnotation(type.getSuperclass(), annotation);
    }

    public List<ApplicationClasses.ApplicationClass> onClassesChange(List<ApplicationClasses.ApplicationClass> modified) {
        RESTEasyPlugin.log("Classes change: " + modified.size(), new Object[0]);
        if (Play.mode != Play.Mode.PROD) {
            this.deploy();
        }
        return super.onClassesChange(modified);
    }

    public void detectChange() {
    }
}

