/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.producer;

import java.util.List;
import play.Logger;
import play.jobs.Job;
import play.modules.rabbitmq.producer.RabbitMQPublisher;
import play.modules.rabbitmq.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RabbitMQFirehose<T>
extends Job {
    public void doJob() {
        while (true) {
            try {
                while (true) {
                    int itemsCount = 0;
                    List<T> items = this.getData(this.batchSize());
                    if (items != null && items.size() > 0) {
                        itemsCount = items.size();
                        for (T item : items) {
                            try {
                                RabbitMQPublisher.publish(this.queueName(), this.routingKey(item), item);
                            }
                            catch (Throwable t) {
                                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                            }
                        }
                    }
                    if (items == null) {
                        Logger.warn((String)"No data available from firehose %s - quitting process...", (Object[])new Object[]{this});
                        return;
                    }
                    if (itemsCount >= this.batchSize()) continue;
                    Thread.sleep(this.sleepInBetweenBatches());
                }
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                continue;
            }
            break;
        }
    }

    protected abstract List<T> getData(int var1) throws Exception;

    protected String routingKey(T t) {
        return this.queueName();
    }

    protected abstract int batchSize();

    protected abstract String queueName();

    protected long sleepInBetweenBatches() {
        long l = 1000L;
        l *= 60L;
        return l *= 5L;
    }
}

