/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.stats;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import play.Logger;
import play.modules.rabbitmq.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats<KEY> {
    protected ConcurrentHashMap<KEY, ExecutionTimes> map = new ConcurrentHashMap();
    protected boolean debug = true;

    protected void log(String msg) {
        if (this.debug) {
            Logger.info((String)msg, (Object[])new Object[0]);
        }
    }

    public long executions(KEY key) {
        ExecutionTimes et = this.map.get(key);
        if (et == null) {
            return 0L;
        }
        long current = et.executions.get();
        return current;
    }

    public long executionTimes(KEY key) {
        ExecutionTimes et = this.map.get(key);
        if (et == null) {
            return 0L;
        }
        long current = et.executionTimes.get();
        return current;
    }

    public void record(KEY key, long executionTime) {
        try {
            ExecutionEvent e = new ExecutionEvent(key, executionTime);
            this.log("Received Execution Event: " + e);
            this.map.putIfAbsent(e.key, new ExecutionTimes());
            ExecutionTimes et = this.map.get(e.key);
            if (et == null) {
                throw new RuntimeException("Invalid Key: " + et);
            }
            long execs = et.executions.incrementAndGet();
            this.log("Executions: " + execs);
            long times = et.executionTimes.getAndAdd(e.executionTime);
            this.log("Execution Times: " + times);
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    public long averageTime(KEY key) {
        long executions = this.executions(key);
        long times = this.executionTimes(key);
        if (executions <= 0L) {
            return 0L;
        }
        return times / executions;
    }

    protected static class ExecutionTimes {
        protected AtomicLong executions = new AtomicLong();
        protected AtomicLong executionTimes = new AtomicLong();

        protected ExecutionTimes() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExecutionEvent {
        public KEY key;
        public long executionTime;

        public ExecutionEvent(KEY key, long executionTime) {
            this.key = key;
            this.executionTime = executionTime;
        }

        public String toString() {
            return "RabbitMQ Execution Event - Key: " + this.key + ", Execution Time: " + this.executionTime + " milisecond(s).";
        }
    }
}

