/*
 * Raphael 0.8.5 - JavaScript Vector Library
 *
 * Copyright (c) 2008 - 2009 Dmitry Baranovskiy (http://raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */


window.Raphael=(function(){var v=/[, ]+/,F=document,l=window,o={was:"Raphael" in window,is:window.Raphael},E=function(){return K.apply(E,arguments);},B={},T={cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/",opacity:1,path:"M0,0",r:0,rotation:0,rx:0,ry:0,scale:"1 1",src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",translation:"0 0",width:0,x:0,y:0},V={cx:"number",cy:"number",fill:"colour","fill-opacity":"number","font-size":"number",height:"number",opacity:"number",path:"path",r:"number",rotation:"csv",rx:"number",ry:"number",scale:"csv",stroke:"colour","stroke-opacity":"number","stroke-width":"number",translation:"csv",width:"number",x:"number",y:"number"},W=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup"];E.version="0.8.5";E.type=(window.SVGAngle||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML");E.svg=!(E.vml=E.type=="VML");E.idGenerator=0;E.fn={};E.isArray=function(R){return Object.prototype.toString.call(R)=="[object Array]";};E.setWindow=function(R){l=R;F=l.document;};E.hsb2rgb=function(AC,AA,AG){if(typeof AC=="object"&&"h" in AC&&"s" in AC&&"b" in AC){AG=AC.b;AA=AC.s;AC=AC.h;}var x,y,AH;if(AG==0){return{r:0,g:0,b:0,hex:"#000"};}if(AC>1||AA>1||AG>1){AC/=255;AA/=255;AG/=255;}var z=Math.floor(AC*6),AD=(AC*6)-z,w=AG*(1-AA),e=AG*(1-(AA*AD)),AI=AG*(1-(AA*(1-AD)));x=[AG,e,w,w,AI,AG,AG][z];y=[AI,AG,AG,e,w,w,AI][z];AH=[w,w,AI,AG,AG,e,w][z];x*=255;y*=255;AH*=255;var AE={r:x,g:y,b:AH},R=Math.round(x).toString(16),AB=Math.round(y).toString(16),AF=Math.round(AH).toString(16);if(R.length==1){R="0"+R;}if(AB.length==1){AB="0"+AB;}if(AF.length==1){AF="0"+AF;}AE.hex="#"+R+AB+AF;return AE;};E.rgb2hsb=function(R,e,AA){if(typeof R=="object"&&"r" in R&&"g" in R&&"b" in R){AA=R.b;e=R.g;R=R.r;}if(typeof R=="string"){var AC=E.getRGB(R);R=AC.r;e=AC.g;AA=AC.b;}if(R>1||e>1||AA>1){R/=255;e/=255;AA/=255;}var z=Math.max(R,e,AA),i=Math.min(R,e,AA),x,w,y=z;if(i==z){return{h:0,s:0,b:z};}else{var AB=(z-i);w=AB/z;if(R==z){x=(e-AA)/AB;}else{if(e==z){x=2+((AA-R)/AB);}else{x=4+((R-e)/AB);}}x/=6;if(x<0){x+=1;}if(x>1){x-=1;}}return{h:x,s:w,b:y};};var O={},m=[];E.getRGB=function(R){if(R in O){return O[R];}var AC={aliceblue:"#f0f8ff",amethyst:"#96c",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"},y;if((R+"").toLowerCase() in AC){R=AC[R.toString().toLowerCase()];}if(!R){return{r:0,g:0,b:0,hex:"#000"};}if(R=="none"){return{r:-1,g:-1,b:-1,hex:"none"};}var i,w,AB,z=(R+"").match(/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgb\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|rgb\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\)|hsb\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|hsb\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\))\s*$/i);if(z){if(z[2]){AB=parseInt(z[2].substring(5),16);w=parseInt(z[2].substring(3,5),16);i=parseInt(z[2].substring(1,3),16);}if(z[3]){AB=parseInt(z[3].substring(3)+z[3].substring(3),16);w=parseInt(z[3].substring(2,3)+z[3].substring(2,3),16);i=parseInt(z[3].substring(1,2)+z[3].substring(1,2),16);}if(z[4]){z=z[4].split(/\s*,\s*/);i=parseFloat(z[0]);w=parseFloat(z[1]);AB=parseFloat(z[2]);}if(z[5]){z=z[5].split(/\s*,\s*/);i=parseFloat(z[0])*2.55;w=parseFloat(z[1])*2.55;AB=parseFloat(z[2])*2.55;}if(z[6]){z=z[6].split(/\s*,\s*/);i=parseFloat(z[0]);w=parseFloat(z[1]);AB=parseFloat(z[2]);return E.hsb2rgb(i,w,AB);}if(z[7]){z=z[7].split(/\s*,\s*/);i=parseFloat(z[0])*2.55;w=parseFloat(z[1])*2.55;AB=parseFloat(z[2])*2.55;return E.hsb2rgb(i,w,AB);}var z={r:i,g:w,b:AB},e=Math.round(i).toString(16),x=Math.round(w).toString(16),AA=Math.round(AB).toString(16);(e.length==1)&&(e="0"+e);(x.length==1)&&(x="0"+x);(AA.length==1)&&(AA="0"+AA);z.hex="#"+e+x+AA;y=z;}else{y={r:-1,g:-1,b:-1,hex:"none"};}if(m.length>20){delete O[m.unshift()];}m.push(R);O[R]=y;return y;};E.getColor=function(e){var i=this.getColor.start=this.getColor.start||{h:0,s:1,b:e||0.75},R=this.hsb2rgb(i.h,i.s,i.b);i.h+=0.075;if(i.h>1){i.h=0;i.s-=0.2;if(i.s<=0){this.getColor.start={h:0,s:1,b:i.b};}}return R.hex;};E.getColor.reset=function(){delete this.start;};var Y={},D=[];E.parsePathString=function(R){if(R in Y){return Y[R];}var w={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},e=[],i=function(){var y="";for(var x=0,z=this.length;x<z;x++){y+=this[x][0]+this[x].join(",").substring(2);}return y;};if(R.toString.toString()==i.toString()){e=R;}if(!e.length){R.replace(/([achlmqstvz])[\s,]*((-?\d*\.?\d*(?:e[-+]?\d+)?\s*,?\s*)+)/ig,function(y,x,AB){var AA=[],z=x.toLowerCase();AB.replace(/(-?\d*\.?\d*(?:e[-+]?\d+)?)\s*,?\s*/ig,function(AD,AC){AC&&AA.push(+AC);});while(AA.length>=w[z]){e.push([x].concat(AA.splice(0,w[z])));if(!w[z]){break;}}});e.toString=i;}if(D.length>20){delete Y[D.unshift()];}D.push(R);Y[R]=e;return e;};var a=function(AH){var R=AH;if(typeof AH=="string"){R=E.parsePathString(AH);}R=X(R);var AC=[],AB=[],e=0;for(var z=0,AG=R.length;z<AG;z++){var AD=R[z];switch(AD[0]){case"Z":break;case"A":AC.push(AD[AD.length-2]);AB.push(AD[AD.length-1]);break;default:for(var w=1,AA=AD.length;w<AA;w++){(w%2?AC:AB).push(AD[w]);}}}var AF=Math.min.apply(Math,AC),AE=Math.min.apply(Math,AB);if(!AC.length){return{x:0,y:0,width:0,height:0,X:0,Y:0};}else{return{x:AF,y:AE,width:Math.max.apply(Math,AC)-AF,height:Math.max.apply(Math,AB)-AE,X:AC,Y:AB};}},S=function(x,i){var w=0.5522*x,e=this.isAbsolute,z=this;if(e){this.relatively();e=function(){z.absolutely();};}else{e=function(){};}var y={l:function(){return{u:function(){z.curveTo(-w,0,-x,-(x-w),-x,-x);},d:function(){z.curveTo(-w,0,-x,x-w,-x,x);}};},r:function(){return{u:function(){z.curveTo(w,0,x,-(x-w),x,-x);},d:function(){z.curveTo(w,0,x,x-w,x,x);}};},u:function(){return{r:function(){z.curveTo(0,-w,-(w-x),-x,x,-x);},l:function(){z.curveTo(0,-w,w-x,-x,-x,-x);}};},d:function(){return{r:function(){z.curveTo(0,w,-(w-x),x,x,x);},l:function(){z.curveTo(0,w,w-x,x,-x,x);}};}};y[i.charAt(0)]()[i.charAt(1)]();e();return z;},C=function(z){var AE=[],AG=0,AF=0,w=0;if(typeof z=="string"){z=E.parsePathString(z);}if(z[0][0]=="M"){AG=z[0][1];AF=z[0][2];w++;AE.push(["M",AG,AF]);}for(var AC=w,AI=z.length;AC<AI;AC++){var R=AE[AC]=[],AH=z[AC];if(AH[0]!=AH[0].toLowerCase()){R[0]=AH[0].toLowerCase();switch(R[0]){case"a":R[1]=AH[1];R[2]=AH[2];R[3]=0;R[4]=AH[4];R[5]=AH[5];R[6]=+(AH[6]-AG).toFixed(3);R[7]=+(AH[7]-AF).toFixed(3);break;case"v":R[1]=(AH[1]-AF).toFixed(3);break;default:for(var AB=1,AD=AH.length;AB<AD;AB++){R[AB]=+(AH[AB]-((AB%2)?AG:AF)).toFixed(3);}}}else{R=AE[AC]=[];for(var AA=0,e=AH.length;AA<e;AA++){AE[AC][AA]=AH[AA];}}switch(AE[AC][0]){case"z":break;case"h":AG+=AE[AC][AE[AC].length-1];break;case"v":AF+=AE[AC][AE[AC].length-1];break;default:AG+=AE[AC][AE[AC].length-2];AF+=AE[AC][AE[AC].length-1];}}AE.toString=z.toString;return AE;},X=function(z){var AE=[];if(typeof z=="string"){z=E.parsePathString(z);}var AG=0,AF=0,w=0;if(z[0][0]=="M"){AG=+z[0][1];AF=+z[0][2];w++;AE[0]=["M",AG,AF];}for(var AC=w,AI=z.length;AC<AI;AC++){var R=AE[AC]=[],AH=z[AC];if(AH[0]!=(AH[0]+"").toUpperCase()){R[0]=(AH[0]+"").toUpperCase();switch(R[0]){case"A":R[1]=AH[1];R[2]=AH[2];R[3]=0;R[4]=AH[4];R[5]=AH[5];R[6]=+(AH[6]+AG).toFixed(3);R[7]=+(AH[7]+AF).toFixed(3);break;case"V":R[1]=+AH[1]+AF;break;case"H":R[1]=+AH[1]+AG;break;default:for(var AB=1,AD=AH.length;AB<AD;AB++){R[AB]=+AH[AB]+((AB%2)?AG:AF);}}}else{R=AE[AC]=[];for(var AA=0,e=AH.length;AA<e;AA++){AE[AC][AA]=AH[AA];}}switch(R[0]){case"Z":break;case"H":AG=R[1];break;case"V":AF=R[1];break;default:AG=AE[AC][AE[AC].length-2];AF=AE[AC][AE[AC].length-1];}}AE.toString=z.toString;return AE;},Z={},L=[],d=function(z,y){if((z+y) in Z){return Z[z+y];}var x=[X(E.parsePathString(z)),X(E.parsePathString(y))],e=[{x:0,y:0,bx:0,by:0,X:0,Y:0},{x:0,y:0,bx:0,by:0,X:0,Y:0}],R=function(AB,AC){if(!AB){return["U"];}switch(AB[0]){case"M":AC.X=AB[1];AC.Y=AB[2];break;case"S":var i=AC.x+(AC.x-(AC.bx||AC.x)),AD=AC.y+(AC.y-(AC.by||AC.y));AB=["C",i,AD,AB[1],AB[2],AB[3],AB[4]];break;case"T":var i=AC.x+(AC.x-(AC.bx||AC.x)),AD=AC.y+(AC.y-(AC.by||AC.y));AB=["Q",i,AD,AB[1],AB[2]];break;case"H":AB=["L",AB[1],AC.y];break;case"V":AB=["L",AC.x,AB[1]];break;case"Z":AB=["L",AC.X,AC.Y];break;}return AB;},AA=function(AD,AC,AF){if(x[AD][AF][0]=="M"&&x[AC][AF][0]!="M"){x[AC].splice(AF,0,["M",e[AC].x,e[AC].y]);e[AD].bx=x[AD][AF][x[AD][AF].length-4]||0;e[AD].by=x[AD][AF][x[AD][AF].length-3]||0;e[AD].x=x[AD][AF][x[AD][AF].length-2];e[AD].y=x[AD][AF][x[AD][AF].length-1];return true;}else{if(x[AD][AF][0]=="L"&&x[AC][AF][0]=="C"){x[AD][AF]=["C",e[AD].x,e[AD].y,x[AD][AF][1],x[AD][AF][2],x[AD][AF][1],x[AD][AF][2]];}else{if(x[AD][AF][0]=="L"&&x[AC][AF][0]=="Q"){x[AD][AF]=["Q",x[AD][AF][1],x[AD][AF][2],x[AD][AF][1],x[AD][AF][2]];}else{if(x[AD][AF][0]=="Q"&&x[AC][AF][0]=="C"){var AB=x[AC][AF][x[AC][AF].length-2],AH=x[AC][AF][x[AC][AF].length-1];x[AC].splice(AF+1,0,["Q",AB,AH,AB,AH]);x[AD].splice(AF,0,["C",e[AD].x,e[AD].y,e[AD].x,e[AD].y,e[AD].x,e[AD].y]);AF++;e[AC].bx=x[AC][AF][x[AC][AF].length-4]||0;e[AC].by=x[AC][AF][x[AC][AF].length-3]||0;e[AC].x=x[AC][AF][x[AC][AF].length-2];e[AC].y=x[AC][AF][x[AC][AF].length-1];return true;}else{if(x[AD][AF][0]=="A"&&x[AC][AF][0]=="C"){var AB=x[AC][AF][x[AC][AF].length-2],AH=x[AC][AF][x[AC][AF].length-1];x[AC].splice(AF+1,0,["A",0,0,x[AD][AF][3],x[AD][AF][4],x[AD][AF][5],AB,AH]);x[AD].splice(AF,0,["C",e[AD].x,e[AD].y,e[AD].x,e[AD].y,e[AD].x,e[AD].y]);AF++;e[AC].bx=x[AC][AF][x[AC][AF].length-4]||0;e[AC].by=x[AC][AF][x[AC][AF].length-3]||0;e[AC].x=x[AC][AF][x[AC][AF].length-2];e[AC].y=x[AC][AF][x[AC][AF].length-1];return true;}else{if(x[AD][AF][0]=="U"){x[AD][AF][0]=x[AC][AF][0];for(var AE=1,AG=x[AC][AF].length;AE<AG;AE++){x[AD][AF][AE]=(AE%2)?e[AD].x:e[AD].y;}}}}}}}return false;};for(var w=0;w<Math.max(x[0].length,x[1].length);w++){x[0][w]=R(x[0][w],e[0]);x[1][w]=R(x[1][w],e[1]);if(x[0][w][0]!=x[1][w][0]&&(AA(0,1,w)||AA(1,0,w))){continue;}e[0].bx=x[0][w][x[0][w].length-4]||0;e[0].by=x[0][w][x[0][w].length-3]||0;e[0].x=x[0][w][x[0][w].length-2];e[0].y=x[0][w][x[0][w].length-1];e[1].bx=x[1][w][x[1][w].length-4]||0;e[1].by=x[1][w][x[1][w].length-3]||0;e[1].x=x[1][w][x[1][w].length-2];e[1].y=x[1][w][x[1][w].length-1];}if(L.length>20){delete Z[L.unshift()];}L.push(z+y);Z[z+y]=x;return x;},N=function(AE){if(typeof AE=="string"){AE=AE.split(/\s*\-\s*/);var w=AE.shift();if(w.toLowerCase()=="v"){w=90;}else{if(w.toLowerCase()=="h"){w=0;}else{w=parseFloat(w);}}w=-w;var AC={angle:w,type:"linear",dots:[],vector:[0,0,Math.cos(w*Math.PI/180).toFixed(3),Math.sin(w*Math.PI/180).toFixed(3)]},AD=1/(Math.max(Math.abs(AC.vector[2]),Math.abs(AC.vector[3]))||1);AC.vector[2]*=AD;AC.vector[3]*=AD;if(AC.vector[2]<0){AC.vector[0]=-AC.vector[2];AC.vector[2]=0;}if(AC.vector[3]<0){AC.vector[1]=-AC.vector[3];AC.vector[3]=0;}AC.vector[0]=AC.vector[0].toFixed(3);AC.vector[1]=AC.vector[1].toFixed(3);AC.vector[2]=AC.vector[2].toFixed(3);AC.vector[3]=AC.vector[3].toFixed(3);for(var z=0,AF=AE.length;z<AF;z++){var R={},AB=AE[z].match(/^([^:]*):?([\d\.]*)/);R.color=E.getRGB(AB[1]).hex;AB[2]&&(R.offset=AB[2]+"%");AC.dots.push(R);}for(var z=1,AF=AC.dots.length-1;z<AF;z++){if(!AC.dots[z].offset){var e=parseFloat(AC.dots[z-1].offset||0),x=false;for(var y=z+1;y<AF;y++){if(AC.dots[y].offset){x=AC.dots[y].offset;break;}}if(!x){x=100;y=AF;}x=parseFloat(x);var AA=(x-e)/(y-z+1);for(;z<y;z++){e+=AA;AC.dots[z].offset=e+"%";}}}return AC;}else{return AE;}},g=function(){var i,e,z,w,R;if(typeof arguments[0]=="string"||typeof arguments[0]=="object"){if(typeof arguments[0]=="string"){i=F.getElementById(arguments[0]);}else{i=arguments[0];}if(i.tagName){if(arguments[1]==null){return{container:i,width:i.style.pixelWidth||i.offsetWidth,height:i.style.pixelHeight||i.offsetHeight};}else{return{container:i,width:arguments[1],height:arguments[2]};}}}else{if(typeof arguments[0]=="number"&&arguments.length>3){return{container:1,x:arguments[0],y:arguments[1],width:arguments[2],height:arguments[3]};}}},A=function(R,i){var e=this;for(var w in i){if(i.hasOwnProperty(w)&&!(w in R)){switch(typeof i[w]){case"function":(function(x){R[w]=R===e?x:function(){return x.apply(e,arguments);};})(i[w]);break;case"object":R[w]=R[w]||{};A.call(this,R[w],i[w]);break;default:R[w]=i[w];break;}}}};if(E.svg){E.toString=function(){return"Your browser supports SVG.\nYou are running Rapha\u00ebl "+this.version;};var H={absolutely:function(){this.isAbsolute=true;return this;},relatively:function(){this.isAbsolute=false;return this;},moveTo:function(R,w){var i=this.isAbsolute?"M":"m";i+=parseFloat(R).toFixed(3)+" "+parseFloat(w).toFixed(3)+" ";var e=this[0].getAttribute("d")||"";(e=="M0,0")&&(e="");this[0].setAttribute("d",e+i);this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(R);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(w);this.attrs.path=e+i;return this;},lineTo:function(R,w){this.last.x=(!this.isAbsolute*this.last.x)+parseFloat(R);this.last.y=(!this.isAbsolute*this.last.y)+parseFloat(w);var i=this.isAbsolute?"L":"l";i+=parseFloat(R).toFixed(3)+" "+parseFloat(w).toFixed(3)+" ";var e=this.node.getAttribute("d")||"";this.node.setAttribute("d",e+i);this.attrs.path=e+i;return this;},arcTo:function(AA,z,e,w,R,AC){var AB=this.isAbsolute?"A":"a";AB+=[parseFloat(AA).toFixed(3),parseFloat(z).toFixed(3),0,e,w,parseFloat(R).toFixed(3),parseFloat(AC).toFixed(3)].join(" ");var i=this[0].getAttribute("d")||"";this.node.setAttribute("d",i+AB);this.last.x=parseFloat(R);this.last.y=parseFloat(AC);this.attrs.path=i+AB;return this;},cplineTo:function(e,AF,AA){if(!AA){return this.lineTo(e,AF);}else{var R={},AG=parseFloat(e),AD=parseFloat(AF),AH=parseFloat(AA),AC=this.isAbsolute?"C":"c",AB=[+this.last.x+AH,+this.last.y,AG-AH,AD,AG,AD];for(var z=0,AI=AB.length;z<AI;z++){AC+=AB[z]+" ";}this.last.x=(this.isAbsolute?0:this.last.x)+AB[4];this.last.y=(this.isAbsolute?0:this.last.y)+AB[5];this.last.bx=AB[2];this.last.by=AB[3];var AE=this.node.getAttribute("d")||"";this.node.setAttribute("d",AE+AC);this.attrs.path=AE+AC;return this;}},curveTo:function(){var x={},y=[0,1,2,3,"s",5,"c"][arguments.length];if(this.isAbsolute){y=y.toUpperCase();}for(var e=0,w=arguments.length;e<w;e++){y+=parseFloat(arguments[e]).toFixed(3)+" ";}this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[arguments.length-2]);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[arguments.length-1]);this.last.bx=parseFloat(arguments[arguments.length-4]);this.last.by=parseFloat(arguments[arguments.length-3]);var R=this.node.getAttribute("d")||"";this.node.setAttribute("d",R+y);this.attrs.path=R+y;return this;},qcurveTo:function(){var x={},y=[0,1,"t",3,"q"][arguments.length];if(this.isAbsolute){y=y.toUpperCase();}for(var e=0,w=arguments.length;e<w;e++){y+=parseFloat(arguments[e]).toFixed(3)+" ";}this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[arguments.length-2]);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[arguments.length-1]);if(arguments.length!=2){this.last.qx=parseFloat(arguments[arguments.length-4]);this.last.qy=parseFloat(arguments[arguments.length-3]);}var R=this.node.getAttribute("d")||"";this.node.setAttribute("d",R+y);this.attrs.path=R+y;return this;},addRoundedCorner:S,andClose:function(){var R=this[0].getAttribute("d")||"";this[0].setAttribute("d",R+"Z ");this.attrs.path=R+"Z ";return this;}};var u=function(w,R,y){var e=F.createElementNS(y.svgns,"path");if(y.canvas){y.canvas.appendChild(e);}var i=new M(e,y);i.isAbsolute=true;for(var x in H){i[x]=H[x];}i.type="path";i.last={x:0,y:0,bx:0,by:0};if(R){i.attrs.path=""+R;i.absolutely();B.pathfinder(i,i.attrs.path);}if(w){!w.gradient&&(w.fill=w.fill||"none");w.stroke=w.stroke||"#000";}else{w={fill:"none",stroke:"#000"};}f(i,w);return i;};var n=function(AA,y,AB){y=N(y);var x=F.createElementNS(AB.svgns,(y.type||"linear")+"Gradient");x.id="raphael-gradient-"+E.idGenerator++;if(y.vector&&y.vector.length){x.setAttribute("x1",y.vector[0]);x.setAttribute("y1",y.vector[1]);x.setAttribute("x2",y.vector[2]);x.setAttribute("y2",y.vector[3]);}AB.defs.appendChild(x);var z=true;for(var e=0,w=y.dots.length;e<w;e++){var R=F.createElementNS(AB.svgns,"stop");if(y.dots[e].offset){z=false;}R.setAttribute("offset",y.dots[e].offset?y.dots[e].offset:(e==0)?"0%":"100%");R.setAttribute("stop-color",E.getRGB(y.dots[e].color).hex||"#fff");x.appendChild(R);}if(z&&typeof y.dots[w-1].opacity!="undefined"){R.setAttribute("stop-opacity",y.dots[w-1].opacity);}AA.setAttribute("fill","url(#"+x.id+")");AA.style.fill="";AA.style.opacity=1;AA.style.fillOpacity=1;AA.setAttribute("opacity",1);AA.setAttribute("fill-opacity",1);};var U=function(e){if(e.pattern){var R=e.getBBox();e.pattern.setAttribute("patternTransform","translate(".concat(R.x,",",R.y,")"));}};var f=function(AD,AK){var AG={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},AI=AD.node,AE=AD.attrs,AA=AE.rotation,x=function(AS,AR){AR=AG[AR.toString().toLowerCase()];if(AR){var AP=AS.attrs["stroke-width"]||"1",AM={round:AP,square:AP,butt:0}[AS.attrs["stroke-linecap"]||AK["stroke-linecap"]]||0,AQ=[];for(var AN=0,AO=AR.length;AN<AO;AN++){AQ.push(AR[AN]*AP+((AN%2)?1:-1)*AM);}AR=AQ.join(",");AI.setAttribute("stroke-dasharray",AR);}};AD.rotate(0,true);for(var AH in AK){if(!(AH in T)){continue;}var AF=AK[AH];AE[AH]=AF;switch(AH){case"href":case"title":case"target":var AJ=AI.parentNode;if(AJ.tagName.toLowerCase()!="a"){var i=F.createElementNS(AD.paper.svgns,"a");AJ.insertBefore(i,AI);i.appendChild(AI);AJ=i;}AJ.setAttributeNS(AD.paper.xlink,AH,AF);break;case"path":if(AD.type=="path"){AI.setAttribute("d","M0,0");B.pathfinder(AD,AF);}case"width":AI.setAttribute(AH,AF);if(AE.fx){AH="x";AF=AE.x;}else{break;}case"x":if(AE.fx){AF=-AE.x-(AE.width||0);}case"rx":case"cx":AI.setAttribute(AH,AF);U(AD);break;case"height":AI.setAttribute(AH,AF);if(AE.fy){AH="y";AF=AE.y;}else{break;}case"y":if(AE.fy){AF=-AE.y-(AE.height||0);}case"ry":case"cy":AI.setAttribute(AH,AF);U(AD);break;case"r":if(AD.type=="rect"){AI.setAttribute("rx",AF);AI.setAttribute("ry",AF);}else{AI.setAttribute(AH,AF);}break;case"src":if(AD.type=="image"){AI.setAttributeNS(AD.paper.xlink,"href",AF);}break;case"stroke-width":AI.style.strokeWidth=AF;AI.setAttribute(AH,AF);if(AE["stroke-dasharray"]){x(AD,AE["stroke-dasharray"]);}break;case"stroke-dasharray":x(AD,AF);break;case"rotation":AD.rotate(AF,true);break;case"translation":var y=(AF+"").split(v);AD.translate((+y[0]+1||2)-1,(+y[1]+1||2)-1);break;case"scale":var y=(AF+"").split(v);AD.scale(+y[0]||1,+y[1]||+y[0]||1,+y[2]||null,+y[3]||null);break;case"fill":var w=(AF+"").match(/^url\(([^\)]+)\)$/i);if(w){var e=F.createElementNS(AD.paper.svgns,"pattern"),AC=F.createElementNS(AD.paper.svgns,"image");e.id="raphael-pattern-"+E.idGenerator++;e.setAttribute("x",0);e.setAttribute("y",0);e.setAttribute("patternUnits","userSpaceOnUse");AC.setAttribute("x",0);AC.setAttribute("y",0);AC.setAttributeNS(AD.paper.xlink,"href",w[1]);e.appendChild(AC);var AL=F.createElement("img");AL.style.position="absolute";AL.style.top="-9999em";AL.style.left="-9999em";AL.onload=function(){e.setAttribute("width",this.offsetWidth);e.setAttribute("height",this.offsetHeight);AC.setAttribute("width",this.offsetWidth);AC.setAttribute("height",this.offsetHeight);F.body.removeChild(this);B.safari();};F.body.appendChild(AL);AL.src=w[1];AD.paper.defs.appendChild(e);AI.style.fill="url(#"+e.id+")";AI.setAttribute("fill","url(#"+e.id+")");AD.pattern=e;U(AD);break;}delete AK.gradient;delete AE.gradient;if(typeof AE.opacity!="undefined"&&typeof AK.opacity=="undefined"){AI.style.opacity=AE.opacity;AI.setAttribute("opacity",AE.opacity);}if(typeof AE["fill-opacity"]!="undefined"&&typeof AK["fill-opacity"]=="undefined"){AI.style.fillOpacity=AD.attrs["fill-opacity"];AI.setAttribute("fill-opacity",AE["fill-opacity"]);}case"stroke":AI.style[AH]=E.getRGB(AF).hex;AI.setAttribute(AH,E.getRGB(AF).hex);break;case"gradient":n(AI,AF,AD.paper);break;case"opacity":case"fill-opacity":if(AE.gradient){var R=F.getElementById(AI.getAttribute("fill").replace(/^url\(#|\)$/g,""));if(R){var z=R.getElementsByTagName("stop");z[z.length-1].setAttribute("stop-opacity",AF);}break;}default:var AB=AH.replace(/(\-.)/g,function(AM){return AM.substring(1).toUpperCase();});AI.style[AB]=AF;AI.setAttribute(AH,AF);break;}}r(AD,AK);AD.rotate(AE.rotation,true);};var k=1.2;var r=function(R,x){if(R.type!="text"||!("text" in x||"font" in x||"font-size" in x||"x" in x||"y" in x)){return ;}var AC=R.attrs,e=R.node,AE=e.firstChild?parseInt(F.defaultView.getComputedStyle(e.firstChild,"").getPropertyValue("font-size"),10):10;if("text" in x){while(e.firstChild){e.removeChild(e.firstChild);}var w=(x.text+"").split("\n");for(var y=0,AD=w.length;y<AD;y++){var AA=F.createElementNS(R.paper.svgns,"tspan");y&&AA.setAttribute("dy",AE*k);y&&AA.setAttribute("x",AC.x);AA.appendChild(F.createTextNode(w[y]));e.appendChild(AA);}}else{var w=e.getElementsByTagName("tspan");for(var y=0,AD=w.length;y<AD;y++){y&&w[y].setAttribute("dy",AE*k);y&&w[y].setAttribute("x",AC.x);}}e.setAttribute("y",AC.y);var z=R.getBBox(),AB=AC.y-(z.y+z.height/2);AB&&e.setAttribute("y",AC.y+AB);};var M=function(e,R){var w=0,i=0;this[0]=e;this.node=e;this.paper=R;this.attrs=this.attrs||{};this.transformations=[];this._={tx:0,ty:0,rt:{deg:0,x:0,y:0},sx:1,sy:1};};M.prototype.rotate=function(e,R,w){if(e==null){return this._.rt.deg;}var i=this.getBBox();e=e.toString().split(v);if(e.length-1){R=parseFloat(e[1]);w=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}if(w==null){R=null;}R=R==null?i.x+i.width/2:R;w=w==null?i.y+i.height/2:w;if(this._.rt.deg){this.transformations[0]=("rotate("+this._.rt.deg+" "+R+" "+w+")");}else{this.transformations[0]="";}this.node.setAttribute("transform",this.transformations.join(" "));return this;};M.prototype.hide=function(){this.node.style.display="none";return this;};M.prototype.show=function(){this.node.style.display="block";return this;};M.prototype.remove=function(){this.node.parentNode.removeChild(this.node);};M.prototype.getBBox=function(){if(this.node.style.display=="none"){this.show();var e=true;}var y=this.node.getBBox()||{};if(this.type=="text"){y={x:y.x,y:Infinity,width:y.width,height:0};for(var R=0,w=this.node.getNumberOfChars();R<w;R++){var x=this.node.getExtentOfChar(R);(x.y<y.y)&&(y.y=x.y);(x.y+x.height-y.y>y.height)&&(y.height=x.y+x.height-y.y);}}e&&this.hide();return y;};M.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}return this.attrs[arguments[0]];}if(arguments.length==1&&E.isArray(arguments[0])){var R={};for(var e in arguments[0]){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}if(arguments.length==2){var i={};i[arguments[0]]=arguments[1];f(this,i);}else{if(arguments.length==1&&typeof arguments[0]=="object"){f(this,arguments[0]);}}return this;};M.prototype.toFront=function(){this.node.parentNode.appendChild(this.node);return this;};M.prototype.toBack=function(){if(this.node.parentNode.firstChild!=this.node){this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild);}return this;};M.prototype.insertAfter=function(R){if(R.node.nextSibling){R.node.parentNode.insertBefore(this.node,R.node.nextSibling);}else{R.node.parentNode.appendChild(this.node);}return this;};M.prototype.insertBefore=function(R){var e=R.node;e.parentNode.insertBefore(this.node,e);return this;};var b=function(e,R,AA,z){var w=F.createElementNS(e.svgns,"circle");w.setAttribute("cx",R);w.setAttribute("cy",AA);w.setAttribute("r",z);w.setAttribute("fill","none");w.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(w);}var i=new M(w,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AA;i.attrs.r=z;i.attrs.stroke="#000";i.type="circle";return i;};var j=function(i,R,AD,e,AB,AC){var AA=F.createElementNS(i.svgns,"rect");AA.setAttribute("x",R);AA.setAttribute("y",AD);AA.setAttribute("width",e);AA.setAttribute("height",AB);if(AC){AA.setAttribute("rx",AC);AA.setAttribute("ry",AC);}AA.setAttribute("fill","none");AA.setAttribute("stroke","#000");if(i.canvas){i.canvas.appendChild(AA);}var z=new M(AA,i);z.attrs=z.attrs||{};z.attrs.x=R;z.attrs.y=AD;z.attrs.width=e;z.attrs.height=AB;z.attrs.stroke="#000";if(AC){z.attrs.rx=z.attrs.ry=AC;}z.type="rect";return z;};var G=function(e,R,AB,AA,z){var w=F.createElementNS(e.svgns,"ellipse");w.setAttribute("cx",R);w.setAttribute("cy",AB);w.setAttribute("rx",AA);w.setAttribute("ry",z);w.setAttribute("fill","none");w.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(w);}var i=new M(w,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AB;i.attrs.rx=AA;i.attrs.ry=z;i.attrs.stroke="#000";i.type="ellipse";return i;};var Q=function(i,AC,R,AD,e,AB){var AA=F.createElementNS(i.svgns,"image");AA.setAttribute("x",R);AA.setAttribute("y",AD);AA.setAttribute("width",e);AA.setAttribute("height",AB);AA.setAttribute("preserveAspectRatio","none");AA.setAttributeNS(i.xlink,"href",AC);if(i.canvas){i.canvas.appendChild(AA);}var z=new M(AA,i);z.attrs=z.attrs||{};z.attrs.x=R;z.attrs.y=AD;z.attrs.width=e;z.attrs.height=AB;z.type="image";return z;};var h=function(e,R,AA,z){var w=F.createElementNS(e.svgns,"text");w.setAttribute("x",R);w.setAttribute("y",AA);w.setAttribute("text-anchor","middle");if(e.canvas){e.canvas.appendChild(w);}var i=new M(w,e);i.attrs=i.attrs||{};i.attrs.x=R;i.attrs.y=AA;i.type="text";f(i,{font:T.font,stroke:"none",fill:"#000",text:z});return i;};var c=function(e,R){this.width=e||this.width;this.height=R||this.height;this.canvas.setAttribute("width",this.width);this.canvas.setAttribute("height",this.height);return this;};var K=function(){var w=g.apply(null,arguments),i=w.container,e=w.x,AB=w.y,z=w.width,R=w.height;if(!i){throw new Error("SVG container not found.");}B.canvas=F.createElementNS(B.svgns,"svg");B.canvas.setAttribute("width",z||512);B.width=z||512;B.canvas.setAttribute("height",R||342);B.height=R||342;if(i==1){F.body.appendChild(B.canvas);B.canvas.style.position="absolute";B.canvas.style.left=e+"px";B.canvas.style.top=AB+"px";}else{if(i.firstChild){i.insertBefore(B.canvas,i.firstChild);}else{i.appendChild(B.canvas);}}i={canvas:B.canvas,clear:function(){while(this.canvas.firstChild){this.canvas.removeChild(this.canvas.firstChild);}this.defs=F.createElementNS(B.svgns,"defs");this.canvas.appendChild(this.defs);}};for(var AA in B){if(AA!="create"){i[AA]=B[AA];}}A.call(i,i,E.fn);i.clear();i.raphael=E;return i;};B.remove=function(){this.canvas.parentNode.removeChild(this.canvas);};B.svgns="http://www.w3.org/2000/svg";B.xlink="http://www.w3.org/1999/xlink";B.safari=function(){if({"Apple Computer, Inc.":1,"Google Inc.":1}[navigator.vendor]){var R=this.rect(-this.width,-this.height,this.width*3,this.height*3).attr({stroke:"none"});setTimeout(function(){R.remove();});}};}if(E.vml){E.toString=function(){return"Your browser doesn\u2019t support SVG. Assuming it is Internet Explorer and falling down to VML.\nYou are running Rapha\u00ebl "+this.version;};var H={absolutely:function(){this.isAbsolute=true;return this;},relatively:function(){this.isAbsolute=false;return this;},moveTo:function(R,z){var w=Math.round(parseFloat(R))-1,i=Math.round(parseFloat(z))-1,e=this.isAbsolute?"m":"t";e+=w+" "+i;this.node.path=this.Path+=e;this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(R);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(z);this.last.isAbsolute=this.isAbsolute;this.attrs.path+=(this.isAbsolute?"M":"m")+[R,z];return this;},lineTo:function(R,z){var w=Math.round(parseFloat(R))-1,i=Math.round(parseFloat(z))-1,e=this.isAbsolute?"l":"r";e+=w+" "+i;this.node.path=this.Path+=e;this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(R);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(z);this.last.isAbsolute=this.isAbsolute;this.attrs.path+=(this.isAbsolute?"L":"l")+[R,z];return this;},arcTo:function(i,R,AE,w,e,AI){e=(this.isAbsolute?0:this.last.x)+e-1;AI=(this.isAbsolute?0:this.last.y)+AI-1;var z=this.last.x-1,AK=this.last.y-1,AJ=(z-e)/2,AH=(AK-AI)/2,AD=(AE==w?-1:1)*Math.sqrt(Math.abs(i*i*R*R-i*i*AH*AH-R*R*AJ*AJ)/(i*i*AH*AH+R*R*AJ*AJ)),AC=AD*i*AH/R+(z+e)/2,AB=AD*-R*AJ/i+(AK+AI)/2,AF=w?(this.isAbsolute?"wa":"wr"):(this.isAbsolute?"at":"ar"),AA=Math.round(AC-i),AG=Math.round(AB-R);AF+=[AA,AG,Math.round(AA+i*2),Math.round(AG+R*2),Math.round(z),Math.round(AK),Math.round(parseFloat(e)),Math.round(parseFloat(AI))].join(", ");this.node.path=this.Path+=AF;this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(e);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(AI);this.last.isAbsolute=this.isAbsolute;this.attrs.path+=(this.isAbsolute?"A":"a")+[i,R,0,AE,w,e,AI];return this;},cplineTo:function(R,AC,i){if(!i){return this.lineTo(R,AC);}else{var AD=Math.round(parseFloat(R))-1,AB=Math.round(parseFloat(AC))-1,AE=Math.round(parseFloat(i)),AA=this.isAbsolute?"c":"v",z=[Math.round(this.last.x)-1+AE,Math.round(this.last.y)-1,AD-AE,AB,AD,AB],e=[this.last.x+i,this.last.y,R-i,AC,R,AC];AA+=z.join(" ")+" ";this.last.x=(this.isAbsolute?0:this.last.x)+z[4];this.last.y=(this.isAbsolute?0:this.last.y)+z[5];this.last.bx=z[2];this.last.by=z[3];this.node.path=this.Path+=AA;this.attrs.path+=(this.isAbsolute?"C":"c")+e;return this;}},curveTo:function(){var i=this.isAbsolute?"c":"v";if(arguments.length==6){this.last.bx=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[2]);this.last.by=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[3]);this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[4]);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[5]);i+=[Math.round(parseFloat(arguments[0]))-1,Math.round(parseFloat(arguments[1]))-1,Math.round(parseFloat(arguments[2]))-1,Math.round(parseFloat(arguments[3]))-1,Math.round(parseFloat(arguments[4]))-1,Math.round(parseFloat(arguments[5]))-1].join(" ")+" ";this.last.isAbsolute=this.isAbsolute;this.attrs.path+=(this.isAbsolute?"C":"c")+Array.prototype.splice.call(arguments,0,arguments.length);}if(arguments.length==4){var e=this.last.x*2-this.last.bx,R=this.last.y*2-this.last.by;this.last.bx=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[0]);this.last.by=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[1]);this.last.x=(this.isAbsolute?0:this.last.x)+parseFloat(arguments[2]);this.last.y=(this.isAbsolute?0:this.last.y)+parseFloat(arguments[3]);i+=[Math.round(e)-1,Math.round(R)-1,Math.round(parseFloat(arguments[0]))-1,Math.round(parseFloat(arguments[1]))-1,Math.round(parseFloat(arguments[2]))-1,Math.round(parseFloat(arguments[3]))-1].join(" ")+" ";this.attrs.path+=(this.isAbsolute?"S":"s")+Array.prototype.splice.call(arguments,0,arguments.length);}this.node.path=this.Path+=i;return this;},qcurveTo:function(){var i=Math.round(this.last.x)-1,e=Math.round(this.last.y)-1,R=[];if(arguments.length==4){this.last.qx=(!this.isAbsolute*this.last.x)+parseFloat(arguments[0]);this.last.qy=(!this.isAbsolute*this.last.y)+parseFloat(arguments[1]);this.last.x=(!this.isAbsolute*this.last.x)+parseFloat(arguments[2]);this.last.y=(!this.isAbsolute*this.last.y)+parseFloat(arguments[3]);R=[this.last.qx,this.last.qy,this.last.x,this.last.y];this.last.isAbsolute=this.isAbsolute;this.attrs.path+=(this.isAbsolute?"Q":"q")+Array.prototype.splice.call(arguments,0,arguments.length);}if(arguments.length==2){this.last.qx=this.last.x*2-this.last.qx;this.last.qy=this.last.y*2-this.last.qy;this.last.x=(!this.isAbsolute*this.last.x)+parseFloat(arguments[2]);this.last.y=(!this.isAbsolute*this.last.y)+parseFloat(arguments[3]);R=[this.last.qx,this.last.qy,this.last.x,this.last.y];this.attrs.path+=(this.isAbsolute?"T":"t")+Array.prototype.splice.call(arguments,0,arguments.length);}var w="c"+[Math.round(2/3*R[0]+1/3*i)-1,Math.round(2/3*R[1]+1/3*e)-1,Math.round(2/3*R[0]+1/3*R[2])-1,Math.round(2/3*R[1]+1/3*R[3])-1,Math.round(R[2])-1,Math.round(R[3])-1].join(" ")+" ";this.node.path=this.Path+=w;return this;},addRoundedCorner:S,andClose:function(){this.node.path=(this.Path+="x");this.attrs.path+="z";return this;}};var u=function(x,w,AA){var z=t("group"),y=z.style;y.position="absolute";y.left=0;y.top=0;y.width=AA.width+"px";y.height=AA.height+"px";z.coordsize=AA.coordsize;z.coordorigin=AA.coordorigin;var i=t("shape"),AB=i.style;AB.width=AA.width+"px";AB.height=AA.height+"px";i.path="";if(x["class"]){i.className="rvml "+x["class"];}i.coordsize=this.coordsize;i.coordorigin=this.coordorigin;z.appendChild(i);var e=new M(i,z,AA);e.isAbsolute=true;e.type="path";e.path=[];e.last={x:0,y:0,bx:0,by:0,isAbsolute:true};e.Path="";for(var R in H){e[R]=H[R];}if(w){e.absolutely();e.attrs.path="";B.pathfinder(e,""+w);}if(x){x.fill=x.fill||"none";x.stroke=x.stroke||"#000";}else{x={fill:"none",stroke:"#000"};}f(e,x);if(x.gradient){n(e,x.gradient);}e.setBox();AA.canvas.appendChild(z);return e;};var f=function(R,i){var e=R.node,AF=e.style,AE,z=R;R.attrs=R.attrs||{};for(var y in i){R.attrs[y]=i[y];}i.href&&(e.href=i.href);i.title&&(e.title=i.title);i.target&&(e.target=i.target);if(i.path&&R.type=="path"){R.Path="";R.path=[];B.pathfinder(R,i.path);}if(i.rotation!=null){R.rotate(i.rotation,true);}if(i.translation){AE=(i.translation+"").split(v);R.translate(AE[0],AE[1]);}if(i.scale){AE=(i.scale+"").split(v);R.scale(+AE[0]||1,+AE[1]||+AE[0]||1,+AE[2]||null,+AE[3]||null);}if(R.type=="image"&&i.src){e.src=i.src;}if(R.type=="image"&&i.opacity){e.filterOpacity=" progid:DXImageTransform.Microsoft.Alpha(opacity="+(i.opacity*100)+")";e.style.filter=(e.filterMatrix||"")+(e.filterOpacity||"");}i.font&&(AF.font=i.font);i["font-family"]&&(AF.fontFamily='"'+i["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,"")+'"');i["font-size"]&&(AF.fontSize=i["font-size"]);i["font-weight"]&&(AF.fontWeight=i["font-weight"]);i["font-style"]&&(AF.fontStyle=i["font-style"]);if(typeof i.opacity!="undefined"||typeof i["stroke-width"]!="undefined"||typeof i.fill!="undefined"||typeof i.stroke!="undefined"||i["stroke-width"]||i["stroke-opacity"]||i["fill-opacity"]||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"]){R=R.shape||e;var AD=(R.getElementsByTagName("fill")&&R.getElementsByTagName("fill")[0])||t("fill");if("fill-opacity" in i||"opacity" in i){var x=((+i["fill-opacity"]+1||2)-1)*((+i.opacity+1||2)-1);x<0&&(x=0);x>1&&(x=1);AD.opacity=x;}i.fill&&(AD.on=true);if(typeof AD.on=="undefined"||i.fill=="none"){AD.on=false;}if(AD.on&&i.fill){var w=i.fill.match(/^url\(([^\)]+)\)$/i);if(w){AD.src=w[1];AD.type="tile";}else{AD.color=E.getRGB(i.fill).hex;AD.src="";AD.type="solid";}}R.appendChild(AD);var AC=(R.getElementsByTagName("stroke")&&R.getElementsByTagName("stroke")[0])||t("stroke");if((i.stroke&&i.stroke!="none")||i["stroke-width"]||typeof i["stroke-opacity"]!="undefined"||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"]){AC.on=true;}if(i.stroke=="none"||typeof AC.on=="undefined"||i.stroke==0){AC.on=false;}if(AC.on&&i.stroke){AC.color=E.getRGB(i.stroke).hex;}var x=((+i["stroke-opacity"]+1||2)-1)*((+i.opacity+1||2)-1);x<0&&(x=0);x>1&&(x=1);AC.opacity=x;i["stroke-linejoin"]&&(AC.joinstyle=i["stroke-linejoin"]||"miter");AC.miterlimit=i["stroke-miterlimit"]||8;i["stroke-linecap"]&&(AC.endcap={butt:"flat",square:"square",round:"round"}[i["stroke-linecap"]]||"miter");i["stroke-width"]&&(AC.weight=(parseFloat(i["stroke-width"])||1)*12/16);if(i["stroke-dasharray"]){var AA={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};AC.dashstyle=AA[i["stroke-dasharray"]]||"";}R.appendChild(AC);}if(z.type=="text"){var AF=B.span.style,AB=z.attrs;AB.font&&(AF.font=AB.font);AB["font-family"]&&(AF.fontFamily=AB["font-family"]);AB["font-size"]&&(AF.fontSize=AB["font-size"]);AB["font-weight"]&&(AF.fontWeight=AB["font-weight"]);AB["font-style"]&&(AF.fontStyle=AB["font-style"]);B.span.innerText=z.node.string;z.W=AB.w=B.span.offsetWidth;z.H=AB.h=B.span.offsetHeight;z.X=AB.x;z.Y=AB.y+Math.round(z.H/2);switch(AB["text-anchor"]){case"start":z.node.style["v-text-align"]="left";z.bbx=Math.round(z.W/2);break;case"end":z.node.style["v-text-align"]="right";z.bbx=-Math.round(z.W/2);break;default:z.node.style["v-text-align"]="center";break;}}};var P=function(e,R,x,w){var i=Math.round(Math.atan((parseFloat(x)-parseFloat(e))/(parseFloat(w)-parseFloat(R)))*57.29)||0;if(!i&&parseFloat(e)<parseFloat(R)){i=180;}i-=180;if(i<0){i+=360;}return i;};var n=function(AA,z){z=N(z);AA.attrs=AA.attrs||{};var e=AA.attrs,y=AA.getElementsByTagName("fill");AA.attrs.gradient=z;AA=AA.shape||AA[0];if(y.length){y=y[0];}else{y=t("fill");}if(z.dots.length){y.on=true;y.method="none";y.type=((z.type+"").toLowerCase()=="radial")?"gradientTitle":"gradient";if(typeof z.dots[0].color!="undefined"){y.color=E.getRGB(z.dots[0].color).hex;}if(typeof z.dots[z.dots.length-1].color!="undefined"){y.color2=E.getRGB(z.dots[z.dots.length-1].color).hex;}var AB=[];for(var w=0,x=z.dots.length;w<x;w++){if(z.dots[w].offset){AB.push(z.dots[w].offset+" "+E.getRGB(z.dots[w].color).hex);}}var R=typeof z.dots[z.dots.length-1].opacity=="undefined"?(typeof e.opacity=="undefined"?1:e.opacity):z.dots[z.dots.length-1].opacity;if(AB.length){y.colors.value=AB.join(",");R=typeof e.opacity=="undefined"?1:e.opacity;}else{y.colors&&(y.colors.value="0% "+y.color);}y.opacity=R;if(typeof z.angle!="undefined"){y.angle=(-z.angle+270)%360;}else{if(z.vector){y.angle=P.apply(null,z.vector);}}if((z.type+"").toLowerCase()=="radial"){y.focus="100%";y.focusposition="0.5 0.5";}}};var M=function(x,z,R){var y=0,i=0,e=0,w=1;this[0]=x;this.node=x;this.X=0;this.Y=0;this.attrs={};this.Group=z;this.paper=R;this._={tx:0,ty:0,rt:{deg:0},sx:1,sy:1};};M.prototype.rotate=function(e,R,i){if(e==null){return this._.rt.deg;}e=(e+"").split(v);if(e.length-1){R=parseFloat(e[1]);i=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}if(i==null){R=null;}this._.rt.cx=R;this._.rt.cy=i;this.setBox(this.attrs,R,i);this.Group.style.rotation=this._.rt.deg;return this;};M.prototype.setBox=function(AB,AC,AA){var e=this.Group.style,AD=(this.shape&&this.shape.style)||this.node.style;AB=AB||{};for(var AE in AB){this.attrs[AE]=AB[AE];}AC=AC||this._.rt.cx;AA=AA||this._.rt.cy;var AH=this.attrs,AK,AJ,AL,AG;switch(this.type){case"circle":AK=AH.cx-AH.r;AJ=AH.cy-AH.r;AL=AG=AH.r*2;break;case"ellipse":AK=AH.cx-AH.rx;AJ=AH.cy-AH.ry;AL=AH.rx*2;AG=AH.ry*2;break;case"rect":case"image":AK=AH.x;AJ=AH.y;AL=AH.width||0;AG=AH.height||0;break;case"text":this.textpath.v=["m",Math.round(AH.x),", ",Math.round(AH.y-2),"l",Math.round(AH.x)+1,", ",Math.round(AH.y-2)].join("");AK=AH.x-Math.round(this.W/2);AJ=AH.y-this.H/2;AL=this.W;AG=this.H;break;case"path":if(!this.attrs.path){AK=0;AJ=0;AL=this.paper.width;AG=this.paper.height;}else{var AF=a(this.attrs.path),AK=AF.x;AJ=AF.y;AL=AF.width;AG=AF.height;}break;default:AK=0;AJ=0;AL=this.paper.width;AG=this.paper.height;break;}AC=(AC==null)?AK+AL/2:AC;AA=(AA==null)?AJ+AG/2:AA;var z=AC-this.paper.width/2,AI=AA-this.paper.height/2;if(this.type=="path"||this.type=="text"){(e.left!=z+"px")&&(e.left=z+"px");(e.top!=AI+"px")&&(e.top=AI+"px");this.X=this.type=="text"?AK:-z;this.Y=this.type=="text"?AJ:-AI;this.W=AL;this.H=AG;(AD.left!=-z+"px")&&(AD.left=-z+"px");(AD.top!=-AI+"px")&&(AD.top=-AI+"px");}else{(e.left!=z+"px")&&(e.left=z+"px");(e.top!=AI+"px")&&(e.top=AI+"px");this.X=AK;this.Y=AJ;this.W=AL;this.H=AG;(e.width!=this.paper.width+"px")&&(e.width=this.paper.width+"px");(e.height!=this.paper.height+"px")&&(e.height=this.paper.height+"px");(AD.left!=AK-z+"px")&&(AD.left=AK-z+"px");(AD.top!=AJ-AI+"px")&&(AD.top=AJ-AI+"px");(AD.width!=AL+"px")&&(AD.width=AL+"px");(AD.height!=AG+"px")&&(AD.height=AG+"px");var AM=(+AB.r||0)/(Math.min(AL,AG));if(this.type=="rect"&&this.arcsize!=AM&&(AM||this.arcsize)){var R=t(AM?"roundrect":"rect");R.arcsize=AM;this.Group.appendChild(R);this.node.parentNode.removeChild(this.node);this.node=R;this.arcsize=AM;f(this,this.attrs);this.setBox(this.attrs);}}};M.prototype.hide=function(){this.Group.style.display="none";return this;};M.prototype.show=function(){this.Group.style.display="block";return this;};M.prototype.getBBox=function(){if(this.type=="path"){return a(this.attr("path"));}return{x:this.X+(this.bbx||0),y:this.Y,width:this.W,height:this.H};};M.prototype.remove=function(){this[0].parentNode.removeChild(this[0]);this.Group.parentNode.removeChild(this.Group);this.shape&&this.shape.parentNode.removeChild(this.shape);};M.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}return this.attrs[arguments[0]];}if(this.attrs&&arguments.length==1&&E.isArray(arguments[0])){var R={};for(var e=0,w=arguments[0].length;e<w;e++){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}var x;if(arguments.length==2){x={};x[arguments[0]]=arguments[1];}if(arguments.length==1&&typeof arguments[0]=="object"){x=arguments[0];}if(x){if(x.gradient){n(this,x.gradient);}if(x.text&&this.type=="text"){this.node.string=x.text;}f(this,x);this.setBox(this.attrs);}return this;};M.prototype.toFront=function(){this.Group.parentNode.appendChild(this.Group);return this;};M.prototype.toBack=function(){if(this.Group.parentNode.firstChild!=this.Group){this.Group.parentNode.insertBefore(this.Group,this.Group.parentNode.firstChild);}return this;};M.prototype.insertAfter=function(R){if(R.Group.nextSibling){R.Group.parentNode.insertBefore(this.Group,R.Group.nextSibling);}else{R.Group.parentNode.appendChild(this.Group);}return this;};M.prototype.insertBefore=function(R){R.Group.parentNode.insertBefore(this.Group,R.Group);return this;};var b=function(e,AD,AC,R){var z=t("group"),w=z.style,i=t("oval"),AB=i.style;w.position="absolute";w.left=0;w.top=0;w.width=e.width+"px";w.height=e.height+"px";z.coordsize=e.coordsize;z.coordorigin=e.coordorigin;z.appendChild(i);var AA=new M(i,z,e);AA.type="circle";f(AA,{stroke:"#000",fill:"none"});AA.attrs.cx=AD;AA.attrs.cy=AC;AA.attrs.r=R;AA.setBox({x:AD-R,y:AC-R,width:R*2,height:R*2});e.canvas.appendChild(z);return AA;};var j=function(e,AE,AD,AF,AA,R){var AB=t("group"),z=AB.style,i=t(R?"roundrect":"rect"),AG=(+R||0)/(Math.min(AF,AA));i.arcsize=AG;z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;AB.appendChild(i);var AC=new M(i,AB,e);AC.type="rect";f(AC,{stroke:"#000"});AC.arcsize=AG;AC.setBox({x:AE,y:AD,width:AF,height:AA,r:+R});e.canvas.appendChild(AB);return AC;};var G=function(R,AE,AD,i,e){var AA=t("group"),z=AA.style,w=t("oval"),AC=w.style;z.position="absolute";z.left=0;z.top=0;z.width=R.width+"px";z.height=R.height+"px";AA.coordsize=R.coordsize;AA.coordorigin=R.coordorigin;AA.appendChild(w);var AB=new M(w,AA,R);AB.type="ellipse";f(AB,{stroke:"#000"});AB.attrs.cx=AE;AB.attrs.cy=AD;AB.attrs.rx=i;AB.attrs.ry=e;AB.setBox({x:AE-i,y:AD-e,width:i*2,height:e*2});R.canvas.appendChild(AA);return AB;};var Q=function(e,R,AF,AE,AG,AA){var AB=t("group"),z=AB.style,i=t("image"),AD=i.style;z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;i.src=R;AB.appendChild(i);var AC=new M(i,AB,e);AC.type="image";AC.attrs.x=AF;AC.attrs.y=AE;AC.attrs.w=AG;AC.attrs.h=AA;AC.setBox({x:AF,y:AE,width:AG,height:AA});e.canvas.appendChild(AB);return AC;};var h=function(e,AE,AD,AF){var AA=t("group"),z=AA.style,w=t("shape"),AC=w.style,AG=t("path"),R=AG.style,i=t("textpath");z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AA.coordsize=e.coordsize;AA.coordorigin=e.coordorigin;AG.v=["m",Math.round(AE),", ",Math.round(AD),"l",Math.round(AE)+1,", ",Math.round(AD)].join("");AG.textpathok=true;AC.width=e.width;AC.height=e.height;z.position="absolute";z.left=0;z.top=0;z.width=e.width;z.height=e.height;i.string=AF;i.on=true;w.appendChild(i);w.appendChild(AG);AA.appendChild(w);var AB=new M(i,AA,e);AB.shape=w;AB.textpath=AG;AB.type="text";AB.attrs.x=AE;AB.attrs.y=AD;AB.attrs.w=1;AB.attrs.h=1;f(AB,{font:T.font,stroke:"none",fill:"#000"});AB.setBox();e.canvas.appendChild(AA);return AB;};var c=function(i,R){var e=this.canvas.style;this.width=i||this.width;this.height=R||this.height;e.width=this.width+"px";e.height=this.height+"px";e.clip="rect(0 "+this.width+"px "+this.height+"px 0)";this.canvas.coordsize=this.width+" "+this.height;return this;};F.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{if(!F.namespaces.rvml){F.namespaces.add("rvml","urn:schemas-microsoft-com:vml");}var t=function(R){return F.createElement("<rvml:"+R+' class="rvml">');};}catch(s){var t=function(R){return F.createElement("<"+R+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">');};}var K=function(){var w=g.apply(null,arguments),e=w.container,AC=w.x,AB=w.y,i=w.width,AE,AD=w.height;if(!e){throw new Error("VML container not found.");}var AA=B.canvas=F.createElement("div"),z=AA.style;i=parseFloat(i)||"512px";AD=parseFloat(AD)||"342px";B.width=i;B.height=AD;B.coordsize=i+" "+AD;B.coordorigin="0 0";B.span=F.createElement("span");AE=B.span.style;AA.appendChild(B.span);AE.position="absolute";AE.left="-99999px";AE.top="-99999px";AE.padding=0;AE.margin=0;AE.lineHeight=1;AE.display="inline";z.width=i+"px";z.height=AD+"px";z.position="absolute";z.clip="rect(0 "+i+"px "+AD+"px 0)";if(e==1){F.body.appendChild(AA);z.left=AC+"px";z.top=AB+"px";e={style:{width:i,height:AD}};}else{e.style.width=i;e.style.height=AD;if(e.firstChild){e.insertBefore(AA,e.firstChild);}else{e.appendChild(AA);}}for(var R in B){e[R]=B[R];}A.call(e,e,E.fn);e.clear=function(){while(AA.firstChild){AA.removeChild(AA.firstChild);}};e.raphael=E;return e;};B.remove=function(){this.canvas.parentNode.removeChild(this.canvas);};B.safari=function(){};}var I=(function(){if(F.addEventListener){return function(x,i,e,R){var w=function(y){return e.call(R,y);};x.addEventListener(i,w,false);return function(){x.removeEventListener(i,w,false);return true;};};}else{if(F.attachEvent){return function(y,w,i,e){var x=function(z){return i.call(e,z||l.event);};y.attachEvent("on"+w,x);var R=function(){y.detachEvent("on"+w,x);return true;};if(w=="mouseover"){y.attachEvent("onmouseenter",x);return function(){y.detachEvent("onmouseenter",x);return R();};}else{if(w=="mouseout"){y.attachEvent("onmouseleave",x);return function(){y.detachEvent("onmouseleave",x);return R();};}}return R;};}}})();for(var p=W.length;p--;){(function(R){M.prototype[R]=function(e){if(typeof e=="function"){this.events=this.events||{};this.events[R]=this.events[R]||{};this.events[R][e]=this.events[R][e]||[];this.events[R][e].push(I(this.shape||this.node,R,e,this));}return this;};M.prototype["un"+R]=function(e){this.events&&this.events[R]&&this.events[R][e]&&this.events[R][e].length&&this.events[R][e].shift()()&&!this.events[R][e].length&&delete this.events[R][e];};})(W[p]);}B.circle=function(R,i,e){return b(this,R,i,e);};B.rect=function(R,AA,e,i,z){return j(this,R,AA,e,i,z);};B.ellipse=function(R,w,i,e){return G(this,R,w,i,e);};B.path=function(e,R){return u(e,R,this);};B.image=function(z,R,AA,e,i){return Q(this,z,R,AA,e,i);};B.text=function(R,i,e){return h(this,R,i,e);};B.drawGrid=function(AF,AE,AG,AC,AB,AD,z){z=z||"#000";var AH=["M",AF,AE,"L",AF+AG,AE,AF+AG,AE+AC,AF,AE+AC,AF,AE],R=AC/AD,e=AG/AB;for(var AA=1;AA<AD;AA++){AH=AH.concat(["M",AF,AE+AA*R,"L",AF+AG,AE+AA*R]);}for(var AA=1;AA<AB;AA++){AH=AH.concat(["M",AF+AA*e,AE,"L",AF+AA*e,AE+AC]);}return this.path({stroke:z,"stroke-width":1},AH.join(","));};B.pathfinder=function(z,y){var e={M:function(i,AA){this.moveTo(i,AA);},C:function(AC,AE,AA,AD,i,AB){this.curveTo(AC,AE,AA,AD,i,AB);},Q:function(AA,AC,i,AB){this.qcurveTo(AA,AC,i,AB);},T:function(i,AA){this.qcurveTo(i,AA);},S:function(AA,AC,i,AB){z.curveTo(AA,AC,i,AB);},L:function(i,AA){z.lineTo(i,AA);},H:function(i){this.lineTo(i,this.last.y);},V:function(i){this.lineTo(this.last.x,i);},A:function(AD,AC,AA,AB,AE,i,AF){this.arcTo(AD,AC,AB,AE,i,AF);},Z:function(){this.andClose();}};y=X(y);for(var w=0,x=y.length;w<x;w++){var R=y[w].shift();e[R].apply(z,y[w]);y[w].unshift(R);}};B.set=function(R){return new J(R);};B.setSize=c;M.prototype.stop=function(){clearTimeout(this.animation_in_progress);};M.prototype.scale=function(AI,AH,w,e){if(AI==null&&AH==null){return{x:this._.sx,y:this._.sy,toString:function(){return this.x.toFixed(3)+" "+this.y.toFixed(3);}};}AH=AH||AI;!+AH&&(AH=AI);var AM,AK,AL,AJ,AW=this.attrs;if(AI!=0){var AG=this.type=="path"?a(AW.path):this.getBBox(),AD=AG.x+AG.width/2,AA=AG.y+AG.height/2;w=(+w||w==0)?w:AD;e=(+e||e==0)?e:AA;var AF=Math.round(AI/Math.abs(AI)),AC=Math.round(AH/Math.abs(AH)),AP=this.node.style,AY=w+(AD-w)*AI*AF/this._.sx,AX=e+(AA-e)*AH*AC/this._.sy;switch(this.type){case"rect":case"image":var AE=AW.width*AI*AF/this._.sx,AO=AW.height*AH*AC/this._.sy,AB=AY-AE/2,z=AX-AO/2;this.attr({width:AE,height:AO,x:AB,y:z});break;case"circle":case"ellipse":this.attr({rx:AW.rx*AI/this._.sx,ry:AW.ry*AH/this._.sy,r:AW.r*AI/this._.sx,cx:AY,cy:AX});break;case"path":var AR=C(AW.path),AS=true;for(var AU=0,AN=AR.length;AU<AN;AU++){var AQ=AR[AU];if(AQ[0].toUpperCase()=="M"&&AS){continue;}else{AS=false;}if(E.svg&&AQ[0].toUpperCase()=="A"){AQ[AR[AU].length-2]*=AI/this._.sx;AQ[AR[AU].length-1]*=AH/this._.sy;AQ[1]*=AI/this._.sx;AQ[2]*=AH/this._.sy;AQ[5]=+(AF+AC?!!+AQ[5]:!+AQ[5]);}else{for(var AT=1,AV=AQ.length;AT<AV;AT++){AQ[AT]*=(AT%2)?AI/this._.sx:AH/this._.sy;}}}var R=a(AR),AM=AY-R.x-R.width/2,AK=AX-R.y-R.height/2;AR=C(AR);AR[0][1]+=AM;AR[0][2]+=AK;this.attr({path:AR.join(" ")});break;}if(this.type in {text:1,image:1}&&(AF!=1||AC!=1)){if(this.transformations){this.transformations[2]="scale(".concat(AF,",",AC,")");this.node.setAttribute("transform",this.transformations.join(" "));AM=(AF==-1)?-AW.x-(AE||0):AW.x;AK=(AC==-1)?-AW.y-(AO||0):AW.y;this.attr({x:AM,y:AK});AW.fx=AF-1;AW.fy=AC-1;}else{this.node.filterMatrix=" progid:DXImageTransform.Microsoft.Matrix(M11=".concat(AF,", M12=0, M21=0, M22=",AC,", Dx=0, Dy=0, sizingmethod='auto expand', filtertype='bilinear')");AP.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}else{if(this.transformations){this.transformations[2]="";this.node.setAttribute("transform",this.transformations.join(" "));AW.fx=0;AW.fy=0;}else{this.node.filterMatrix="";AP.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}AW.scale=[AI,AH,w,e].join(" ");this._.sx=AI;this._.sy=AH;}return this;};E.easing_formulas={linear:function(R){return R;},"<":function(R){return Math.pow(R,3);},">":function(R){return Math.pow(R-1,3)+1;},"<>":function(R){R=R*2;if(R<1){return Math.pow(R,3)/2;}R-=2;return(Math.pow(R,3)+2)/2;},backIn:function(e){var R=1.70158;return Math.pow(e,2)*((R+1)*e-R);},backOut:function(e){e=e-1;var R=1.70158;return Math.pow(e,2)*((R+1)*e+R)+1;},elastic:function(i){if(i==0||i==1){return i;}var e=0.3,R=e/4;return Math.pow(2,-10*i)*Math.sin((i-R)*(2*Math.PI)/e)+1;},bounce:function(w){var e=7.5625,i=2.75,R;if(w<(1/i)){R=e*Math.pow(w,2);}else{if(w<(2/i)){w-=(1.5/i);R=e*Math.pow(w,2)+0.75;}else{if(w<(2.5/i)){w-=(2.25/i);R=e*Math.pow(w,2)+0.9375;}else{w-=(2.625/i);R=e*Math.pow(w,2)+0.984375;}}}return R;}};E.easing=function(e,R){return E.easing_formulas[e]?E.easing_formulas[e](R):R;};M.prototype.animate=function(AO,AG,AF,x){clearTimeout(this.animation_in_progress);if(typeof AF=="function"||!AF){x=AF||null;AF="linear";}var AJ={},e={},AD={},AC={x:0,y:0};for(var AH in AO){if(AH in V){AJ[AH]=this.attr(AH);(typeof AJ[AH]=="undefined")&&(AJ[AH]=T[AH]);e[AH]=AO[AH];switch(V[AH]){case"number":AD[AH]=(e[AH]-AJ[AH])/AG;break;case"colour":AJ[AH]=E.getRGB(AJ[AH]);var AI=E.getRGB(e[AH]);AD[AH]={r:(AI.r-AJ[AH].r)/AG,g:(AI.g-AJ[AH].g)/AG,b:(AI.b-AJ[AH].b)/AG};break;case"path":var y=d(AJ[AH],e[AH]);AJ[AH]=y[0];e[AH]=y[1];AD[AH]=[];for(var AL=0,AB=AJ[AH].length;AL<AB;AL++){AD[AH][AL]=[0];for(var AK=1,AN=AJ[AH][AL].length;AK<AN;AK++){AD[AH][AL][AK]=(e[AH][AL][AK]-AJ[AH][AL][AK])/AG;}}break;case"csv":var R=(AO[AH]+"").split(v),AA=(AJ[AH]+"").split(v);switch(AH){case"translation":AJ[AH]=[0,0];AD[AH]=[R[0]/AG,R[1]/AG];break;case"rotation":AJ[AH]=(AA[1]==R[1]&&AA[2]==R[2])?AA:[0,R[1],R[2]];AD[AH]=[(R[0]-AJ[AH][0])/AG,0,0];break;case"scale":AO[AH]=R;AJ[AH]=(AJ[AH]+"").split(v);AD[AH]=[(R[0]-AJ[AH][0])/AG,(R[1]-AJ[AH][1])/AG,0,0];}e[AH]=R;}}}var w=+new Date,AE=0,z=this;(function AM(){var AQ=new Date-w,AX={},AP;if(AQ<AG){pos=E.easing(AF,AQ/AG);for(var AU in AJ){switch(V[AU]){case"number":AP=+AJ[AU]+pos*AG*AD[AU];break;case"colour":AP="rgb("+[Math.round(AJ[AU].r+pos*AG*AD[AU].r),Math.round(AJ[AU].g+pos*AG*AD[AU].g),Math.round(AJ[AU].b+pos*AG*AD[AU].b)].join(",")+")";break;case"path":AP=[];for(var AS=0,AY=AJ[AU].length;AS<AY;AS++){AP[AS]=[AJ[AU][AS][0]];for(var AR=1,AT=AJ[AU][AS].length;AR<AT;AR++){AP[AS][AR]=AJ[AU][AS][AR]+pos*AG*AD[AU][AS][AR];}AP[AS]=AP[AS].join(" ");}AP=AP.join(" ");break;case"csv":switch(AU){case"translation":var AW=AD[AU][0]*(AQ-AE),AV=AD[AU][1]*(AQ-AE);AC.x+=AW;AC.y+=AV;AP=[AW,AV].join(" ");break;case"rotation":AP=+AJ[AU][0]+pos*AG*AD[AU][0];AJ[AU][1]&&(AP+=","+AJ[AU][1]+","+AJ[AU][2]);break;case"scale":AP=[+AJ[AU][0]+pos*AG*AD[AU][0],+AJ[AU][1]+pos*AG*AD[AU][1],(2 in AO[AU]?AO[AU][2]:""),(3 in AO[AU]?AO[AU][3]:"")].join(" ");}break;}if(AU=="font-size"){AX[AU]=AP+"px";}else{AX[AU]=AP;}}z.attr(AX);z.animation_in_progress=setTimeout(AM);B.safari();}else{(AC.x||AC.y)&&z.translate(-AC.x,-AC.y);z.attr(AO);clearTimeout(z.animation_in_progress);B.safari();(typeof x=="function")&&x.call(z);}AE=AQ;})();return this;};M.prototype.translate=function(R,i){if(R==null){return{x:this._.tx,y:this._.ty};}this._.tx+=+R;this._.ty+=+i;switch(this.type){case"circle":case"ellipse":this.attr({cx:this.attrs.cx+R,cy:this.attrs.cy+i});break;case"rect":case"image":case"text":this.attr({x:this.attrs.x+(+R),y:this.attrs.y+(+i)});break;case"path":var e=C(this.attrs.path);e[0][1]+=+R;e[0][2]+=+i;this.attr({path:e.join(" ")});break;}return this;};var J=function(R){this.items=[];this.length=0;if(R){for(var e=0,w=R.length;e<w;e++){if(R[e]&&(R[e].constructor==M||R[e].constructor==J)){this[this.items.length]=this.items[this.items.length]=R[e];this.length++;}}}};J.prototype.push=function(){var x,R;for(var e=0,w=arguments.length;e<w;e++){x=arguments[e];if(x&&(x.constructor==M||x.constructor==J)){R=this.items.length;this[R]=this.items[R]=x;this.length++;}}return this;};J.prototype.pop=function(w){var e=this.items.splice(w,1)[0];for(var R=w,i=this.items.length;R<i;R++){this[R]=this[R+1];}delete this[i+1];this.length--;return e;};for(var q in M.prototype){J.prototype[q]=(function(R){return function(){for(var e=0,w=this.items.length;e<w;e++){this.items[e][R].apply(this.items[e],arguments);}return this;};})(q);}J.prototype.attr=function(e,z){if(e&&E.isArray(e)&&typeof e[0]=="object"){for(var R=0,y=e.length;R<y;R++){this.items[R].attr(e[R]);}}else{for(var w=0,x=this.items.length;w<x;w++){this.items[w].attr.apply(this.items[w],arguments);}}return this;};J.prototype.getBBox=function(){var R=[],AC=[],e=[],AA=[];for(var z=this.items.length;z--;){var AB=this.items[z].getBBox();R.push(AB.x);AC.push(AB.y);e.push(AB.x+AB.width);AA.push(AB.y+AB.height);}R=Math.min.apply(Math,R);AC=Math.min.apply(Math,AC);return{x:R,y:AC,width:Math.max.apply(Math,e)-R,height:Math.max.apply(Math,AA)-AC};};E.registerFont=function(e){if(!e.face){return e;}this.fonts=this.fonts||{};var w={w:e.w,face:{},glyphs:{}},i=e.face["font-family"];for(var z in e.face){w.face[z]=e.face[z];}if(this.fonts[i]){this.fonts[i].push(w);}else{this.fonts[i]=[w];}if(!e.svg){w.face["units-per-em"]=parseInt(e.face["units-per-em"],10);for(var x in e.glyphs){var y=e.glyphs[x];w.glyphs[x]={w:y.w,k:{},d:y.d&&"M"+y.d.replace(/[mlcxtrv]/g,function(AA){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[AA]||"M";})+"z"};if(y.k){for(var R in y.k){w.glyphs[x].k[R]=y.k[R];}}}}return e;};B.getFont=function(AB,AC,e,x){x=x||"normal";e=e||"normal";AC=+AC||{normal:400,bold:700,lighter:300,bolder:800}[AC]||400;var y=E.fonts[AB];if(!y){var w=new RegExp("(^|\\s)"+AB.replace(/[^\w\d\s+!~.:_-]/g,"")+"(\\s|$)","i");for(var R in E.fonts){if(w.test(R)){y=E.fonts[R];break;}}}var z;if(y){for(var AA=0,AD=y.length;AA<AD;AA++){z=y[AA];if(z.face["font-weight"]==AC&&(z.face["font-style"]==e||!z.face["font-style"])&&z.face["font-stretch"]==x){break;}}}return z;};B.print=function(AF,AE,AC,e,AJ){var AA=this.set(),AD=(AC+"").split(""),R=0,AI="",z;if(e){z=(AJ||16)/e.face["units-per-em"];for(var AB=0,AG=AD.length;AB<AG;AB++){var w=AB&&e.glyphs[AD[AB-1]]||{},AH=e.glyphs[AD[AB]];R+=AB?(w.w||e.w)+(w.k&&w.k[AD[AB]]||0):0;AH&&AH.d&&AA.push(this.path({fill:"#000",stroke:"none"},AH.d).translate(R,0));}AA.scale(z,z,0,AE).translate(AF,(AJ||16)/2);}return AA;};E.ninja=function(){var R=window.Raphael;if(o.was){window.Raphael=o.is;}else{try{delete window.Raphael;}catch(i){window.Raphael=void (0);}}return R;};E.el=M.prototype;return E;})();