/*
 * Decompiled with CFR 0.152.
 */
package play.modules.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import play.cache.CacheImpl;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheImpl
implements CacheImpl {
    private static RedisCacheImpl uniqueInstance = new RedisCacheImpl();
    static JedisPool connectionPool;
    static ThreadLocal<Jedis> cacheConnection;

    private RedisCacheImpl() {
    }

    static RedisCacheImpl getInstance() {
        return uniqueInstance;
    }

    public static Jedis getCacheConnection() {
        if (cacheConnection.get() != null) {
            return cacheConnection.get();
        }
        Jedis connection = (Jedis)connectionPool.getResource();
        cacheConnection.set(connection);
        return connection;
    }

    public static void closeCacheConnection() {
        if (cacheConnection.get() != null) {
            connectionPool.returnResource((Object)cacheConnection.get());
            cacheConnection.remove();
        }
    }

    public void add(String key, Object value, int expiration) {
        if (!RedisCacheImpl.getCacheConnection().exists(key).booleanValue()) {
            this.set(key, value, expiration);
        }
    }

    public boolean safeAdd(String key, Object value, int expiration) {
        try {
            this.add(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void set(String key, Object value, int expiration) {
        Jedis jedis = RedisCacheImpl.getCacheConnection();
        byte[] bytes = RedisCacheImpl.toByteArray(value);
        jedis.set(key.getBytes(), bytes);
        jedis.expire(key, expiration);
    }

    private static byte[] toByteArray(Object o) {
        ObjectOutputStream out = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public boolean safeSet(String key, Object value, int expiration) {
        try {
            this.set(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void replace(String key, Object value, int expiration) {
        if (RedisCacheImpl.getCacheConnection().exists(key).booleanValue()) {
            this.set(key, value, expiration);
        }
    }

    public boolean safeReplace(String key, Object value, int expiration) {
        try {
            this.replace(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object get(String key) {
        byte[] bytes = RedisCacheImpl.getCacheConnection().get(key.getBytes());
        if (bytes == null) {
            return null;
        }
        return RedisCacheImpl.fromByteArray(bytes);
    }

    private static Object fromByteArray(byte[] bytes) {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public Map<String, Object> get(String[] keys) {
        HashMap<String, Object> result = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    public long incr(String key, int by) {
        long sum;
        Object cacheValue = this.get(key);
        if (cacheValue == null) {
            Long newCacheValueLong = 0L + (long)by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueLong));
            sum = newCacheValueLong;
        } else if (cacheValue instanceof Integer) {
            Integer newCacheValueInteger = (Integer)cacheValue + by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueInteger));
            sum = newCacheValueInteger.longValue();
        } else if (cacheValue instanceof Long) {
            Long newCacheValueLong = (Long)cacheValue + (long)by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueLong));
            sum = newCacheValueLong;
        } else {
            throw new JedisDataException("Cannot incr on non-integer value (key: " + key + ")");
        }
        return sum;
    }

    public long decr(String key, int by) {
        long difference;
        Object cacheValue = this.get(key);
        if (cacheValue == null) {
            Long newCacheValueLong = 0L - (long)by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueLong));
            difference = newCacheValueLong;
        } else if (cacheValue instanceof Integer) {
            Integer newCacheValueInteger = (Integer)cacheValue - by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueInteger));
            difference = newCacheValueInteger.longValue();
        } else if (cacheValue instanceof Long) {
            Long newCacheValueLong = (Long)cacheValue - (long)by;
            RedisCacheImpl.getCacheConnection().set(key.getBytes(), RedisCacheImpl.toByteArray(newCacheValueLong));
            difference = newCacheValueLong;
        } else {
            throw new JedisDataException("Cannot decr on non-integer value (key: " + key + ")");
        }
        return difference;
    }

    public void clear() {
        RedisCacheImpl.getCacheConnection().flushDB();
    }

    public void delete(String key) {
        RedisCacheImpl.getCacheConnection().del(new String[]{key});
    }

    public boolean safeDelete(String key) {
        try {
            this.delete(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        RedisCacheImpl.getCacheConnection().flushAll();
        connectionPool.destroy();
    }

    static {
        cacheConnection = new ThreadLocal();
    }
}

