/*
 * Decompiled with CFR 0.152.
 */
package play.modules.redis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisConnectionManager {
    static JedisPool connectionPool;
    static ShardedJedisPool shardedConnectionPool;
    static ThreadLocal<Jedis> redisConnection;
    static ThreadLocal<ShardedJedis> shardedConnection;

    public static boolean isSharded() {
        return shardedConnectionPool != null;
    }

    public static Jedis getRawConnection() {
        if (!RedisConnectionManager.isSharded()) {
            return RedisConnectionManager.getRawConnectionInternal();
        }
        throw new JedisConnectionException("Cannot retrieve raw connection from sharded instance. Try getRawConnectionFromShard(key).");
    }

    static Jedis getRawConnectionInternal() {
        if (redisConnection.get() != null) {
            return redisConnection.get();
        }
        Jedis jedis = (Jedis)connectionPool.getResource();
        redisConnection.set(jedis);
        return jedis;
    }

    public static Jedis getRawConnectionFromShard(String key) {
        if (!RedisConnectionManager.isSharded()) {
            return RedisConnectionManager.getRawConnectionInternal();
        }
        ShardedJedis sjedis = RedisConnectionManager.getRawShardedConnectionInternal();
        Jedis jedis = (Jedis)sjedis.getShard(key);
        return jedis;
    }

    public static Jedis getRawConnectionFromShard(byte[] key) {
        if (!RedisConnectionManager.isSharded()) {
            return RedisConnectionManager.getRawConnectionInternal();
        }
        ShardedJedis sjedis = RedisConnectionManager.getRawShardedConnectionInternal();
        Jedis jedis = (Jedis)sjedis.getShard(key);
        return jedis;
    }

    static ShardedJedis getRawShardedConnectionInternal() {
        if (shardedConnection.get() != null) {
            return shardedConnection.get();
        }
        ShardedJedis sjedis = (ShardedJedis)shardedConnectionPool.getResource();
        shardedConnection.set(sjedis);
        return sjedis;
    }

    public static void closeConnection() {
        if (redisConnection.get() != null) {
            connectionPool.returnResource((Object)redisConnection.get());
            redisConnection.remove();
        } else if (shardedConnection.get() != null) {
            shardedConnectionPool.returnResource((Object)shardedConnection.get());
            shardedConnection.remove();
        }
    }

    public static void destroy() {
        if (!RedisConnectionManager.isSharded()) {
            connectionPool.destroy();
        } else {
            shardedConnectionPool.destroy();
        }
    }

    static {
        redisConnection = new ThreadLocal();
        shardedConnection = new ThreadLocal();
    }
}

