/*
 * Decompiled with CFR 0.152.
 */
package play.modules.redis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.pool.impl.GenericObjectPool;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.ConfigurationException;
import play.modules.redis.RedisCacheImpl;
import play.modules.redis.RedisConnectionManager;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisPlugin
extends PlayPlugin {
    private boolean createdRedisCache;
    private boolean createdRedis;

    public static boolean isRedisCacheEnabled() {
        return Play.configuration.getProperty("redis.cache", "disabled").equals("enabled");
    }

    public void onConfigurationRead() {
        if (RedisPlugin.isRedisCacheEnabled()) {
            if (Play.configuration.containsKey("redis.cache.url")) {
                String redisCacheUrl = Play.configuration.getProperty("redis.cache.url");
                Logger.info((String)"Connecting to redis cache with %s", (Object[])new Object[]{redisCacheUrl});
                RedisConnectionInfo redisConnInfo = new RedisConnectionInfo(redisCacheUrl, Play.configuration.getProperty("redis.cache.timeout"));
                RedisCacheImpl.connectionPool = redisConnInfo.getConnectionPool();
                Cache.forcedCacheImpl = RedisCacheImpl.getInstance();
                this.createdRedisCache = true;
            } else {
                throw new ConfigurationException("Bad configuration for redis cache: missing redis.cache.url");
            }
        }
    }

    public void onApplicationStart() {
        if (Play.configuration.containsKey("redis.url")) {
            String redisUrl = Play.configuration.getProperty("redis.url");
            Logger.info((String)"Connecting to redis with %s", (Object[])new Object[]{redisUrl});
            RedisConnectionInfo redisConnInfo = new RedisConnectionInfo(redisUrl, Play.configuration.getProperty("redis.timeout"));
            RedisConnectionManager.connectionPool = redisConnInfo.getConnectionPool();
            this.createdRedis = true;
        } else if (Play.configuration.containsKey("redis.1.url")) {
            int nb = 1;
            ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
            while (Play.configuration.containsKey("redis." + nb + ".url")) {
                RedisConnectionInfo redisConnInfo = new RedisConnectionInfo(Play.configuration.getProperty("redis." + nb + ".url"), Play.configuration.getProperty("redis.timeout"));
                shards.add(redisConnInfo.getShardInfo());
                ++nb;
            }
            RedisConnectionManager.shardedConnectionPool = new ShardedJedisPool((GenericObjectPool.Config)new JedisPoolConfig(), shards, ShardedJedis.DEFAULT_KEY_TAG_PATTERN);
            this.createdRedis = true;
        } else if (!this.createdRedisCache) {
            Logger.warn((String)"No redis.url found in configuration. Redis will not be available.", (Object[])new Object[0]);
        }
    }

    public void onApplicationStop() {
        if (this.createdRedis) {
            RedisConnectionManager.destroy();
        }
    }

    public void invocationFinally() {
        if (this.createdRedisCache) {
            RedisCacheImpl.closeCacheConnection();
        }
        if (this.createdRedis) {
            RedisConnectionManager.closeConnection();
        }
    }

    private static class RedisConnectionInfo {
        private final String host;
        private final int port;
        private final String password;
        private final int timeout;

        RedisConnectionInfo(String redisUrl, String timeoutStr) {
            URI redisUri;
            try {
                redisUri = new URI(redisUrl);
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Bad configuration for redis: unable to parse redis url (" + redisUrl + ")");
            }
            this.host = redisUri.getHost();
            this.port = redisUri.getPort() > 0 ? redisUri.getPort() : 6379;
            String userInfo = redisUri.getUserInfo();
            if (userInfo != null) {
                String[] parsedUserInfo = userInfo.split(":");
                this.password = parsedUserInfo[parsedUserInfo.length - 1];
            } else {
                this.password = null;
            }
            this.timeout = timeoutStr == null ? 2000 : Integer.parseInt(timeoutStr);
        }

        JedisPool getConnectionPool() {
            if (this.password == null) {
                return new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), this.host, this.port, this.timeout);
            }
            return new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password);
        }

        JedisShardInfo getShardInfo() {
            JedisShardInfo si = new JedisShardInfo(this.host, this.port, this.timeout);
            si.setPassword(this.password);
            return si;
        }
    }
}

