/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.Encode;
import play.data.parsing.DataParser;
import play.data.parsing.UrlEncodedParser;
import play.modules.resteasy.ServletUtil;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTEasyRequestWrapper
implements HttpRequest {
    private Http.Request request;
    private HttpHeaders headers;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    private UriInfoImpl uriInfo;
    private String preProcessedPath;
    private InputStream overridenStream;

    public RESTEasyRequestWrapper(Http.Request request, String prefix) {
        this.request = request;
        this.headers = ServletUtil.extractHttpHeaders(request);
        this.uriInfo = ServletUtil.extractUriInfo(request, prefix);
        this.preProcessedPath = this.uriInfo.getPath(false);
    }

    public Object getAttribute(String key) {
        return this.request.args.get(key);
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.request.method.equals("PUT")) {
            return this.getPutDecodedFormParameters();
        }
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = new MultivaluedMapImpl();
        String query = this.request.querystring;
        Map params = this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded")) ? ((DataParser)DataParser.parsers.get("application/x-www-form-urlencoded")).parse(this.request.body) : new HashMap();
        HashMap queryParams = query == null || query.length() == 0 ? UrlEncodedParser.parse((String)query) : new HashMap();
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            String[] queryValues = (String[])queryParams.get(name);
            if (queryValues == null) {
                for (String val : values) {
                    this.decodedFormParameters.add((Object)name, (Object)val);
                }
                continue;
            }
            List<String> queryValuesList = Arrays.asList(queryValues);
            for (String val : values) {
                if (queryValuesList.contains(val)) continue;
                this.decodedFormParameters.add((Object)name, (Object)val);
            }
        }
        return this.decodedFormParameters;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.request.method.equals("PUT")) {
            return this.getPutFormParameters();
        }
        if (this.formParameters != null) {
            return this.formParameters;
        }
        this.formParameters = Encode.encode(this.getDecodedFormParameters());
        return this.formParameters;
    }

    public HttpHeaders getHttpHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.request.method;
    }

    public InputStream getInputStream() {
        if (this.overridenStream != null) {
            return this.overridenStream;
        }
        return this.request.body;
    }

    public String getPreprocessedPath() {
        return this.preProcessedPath;
    }

    public UriInfo getUri() {
        return this.uriInfo;
    }

    public void removeAttribute(String key) {
        this.request.args.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.request.args.put(key, value);
    }

    public void setInputStream(InputStream is) {
        this.overridenStream = is;
    }

    public void setPreprocessedPath(String path) {
        this.preProcessedPath = path;
    }

    public MultivaluedMap<String, String> getPutFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm((InputStream)this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getPutDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public AsynchronousResponse createAsynchronousResponse(long arg0) {
        return null;
    }

    public AsynchronousResponse getAsynchronousResponse() {
        return null;
    }

    public void initialRequestThreadFinished() {
    }

    public boolean isInitial() {
        return this.request.isNew;
    }

    public boolean isSuspended() {
        return false;
    }
}

