/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy.crud;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.annotations.providers.jaxb.json.Mapped;
import org.jboss.resteasy.annotations.providers.jaxb.json.XmlNsMap;
import org.jboss.resteasy.links.AddLinks;
import org.jboss.resteasy.links.LinkELProvider;
import org.jboss.resteasy.links.LinkResource;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.db.Model;
import play.modules.resteasy.crud.CRUD;
import play.modules.resteasy.crud.CRUDField;
import play.modules.resteasy.crud.DataTable;
import play.modules.resteasy.crud.DataTableQuery;
import play.modules.resteasy.crud.PlayELProvider;
import play.modules.resteasy.crud.RESTResource;
import play.modules.resteasy.crud.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRUDEnhancer
extends Enhancer {
    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        if (!ctClass.subtypeOf(this.classPool.get(RESTResource.class.getName()))) {
            Logger.debug((String)"Not a RESTResource subclass", (Object[])new Object[0]);
            return;
        }
        CRUD restCRUD = this.getAnnotation(ctClass, CRUD.class);
        if (restCRUD == null) {
            Logger.debug((String)"Missing CRUD annotation", (Object[])new Object[0]);
            return;
        }
        Logger.info((String)"Enhancing CRUD entity %s", (Object[])new Object[]{ctClass.getName()});
        ConstPool cp = ctClass.getClassFile().getConstPool();
        Model.Factory factory = Model.Manager.factoryFor(restCRUD.model());
        Class idType = factory.keyType();
        String idName = this.getLastTemplateName(restCRUD.single());
        AnnotationsAttribute annotations = CRUDEnhancer.getAnnotations((CtClass)ctClass);
        if (!this.hasAnnotation(ctClass, Path.class)) {
            CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, Path.class, this.map(cp, "/"));
        }
        if (!this.hasAnnotation(ctClass, LinkELProvider.class)) {
            CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, LinkELProvider.class, this.map(cp, PlayELProvider.class));
        }
        String[] mediaTypes = new String[]{"application/xml", "application/json"};
        if (!this.hasAnnotation(ctClass, Produces.class)) {
            CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, Produces.class, this.map(cp, mediaTypes));
        }
        Signature listSignature = new Signature(Response.class, "list", this.a(GET.class), this.a(AddLinks.class), this.a(Path.class, restCRUD.collection()), this.linkResourceAnnotation(restCRUD.model(), "list", "select"));
        listSignature.param(DataTableQuery.class, "q", this.a(Form.class));
        if (!this.hasMethod(ctClass, listSignature.name, listSignature.signature())) {
            CtMethod list = listSignature.method(ctClass, restCRUD.model());
            ctClass.addMethod(list);
        }
        Signature getSignature = new Signature(Response.class, "get", this.a(GET.class), this.a(AddLinks.class), this.a(Path.class, restCRUD.single()), this.linkResourceAnnotation(restCRUD.model(), "self", "select"));
        getSignature.param(idType, "id", this.a(PathParam.class, idName));
        if (!this.hasMethod(ctClass, getSignature.name, getSignature.signature())) {
            ctClass.addMethod(getSignature.method(ctClass, restCRUD.model()));
        }
        Signature deleteSignature = new Signature(Response.class, "delete", this.a(DELETE.class), this.a(Path.class, restCRUD.single()), this.linkResourceAnnotation(restCRUD.model(), "remove", "delete"));
        deleteSignature.param(idType, "id", this.a(PathParam.class, idName));
        if (!this.hasMethod(ctClass, deleteSignature.name, deleteSignature.signature())) {
            CtMethod delete = deleteSignature.method(ctClass, restCRUD.model());
            ctClass.addMethod(delete);
        }
        Signature addSignature = new Signature(Response.class, "add", this.a(POST.class), this.a(Path.class, restCRUD.collection()), this.a(Consumes.class, mediaTypes), this.linkResourceAnnotation(restCRUD.model(), "add", "insert"));
        addSignature.param(restCRUD.model(), "elem", this.a(Validate.class));
        addSignature.param(UriInfo.class, "uriInfo", this.a(Context.class));
        if (!this.hasMethod(ctClass, addSignature.name, addSignature.signature())) {
            CtMethod add = addSignature.method(ctClass, restCRUD.model());
            ctClass.addMethod(add);
        }
        Signature editSignature = new Signature(Response.class, "edit", this.a(PUT.class), this.a(Path.class, restCRUD.single()), this.a(Consumes.class, mediaTypes), this.linkResourceAnnotation(restCRUD.model(), "update", "update"));
        editSignature.param(idType, "id", this.a(PathParam.class, idName));
        editSignature.param(restCRUD.model(), "elem", this.a(Validate.class));
        if (!this.hasMethod(ctClass, editSignature.name, editSignature.signature())) {
            CtMethod edit = editSignature.method(ctClass, restCRUD.model());
            ctClass.addMethod(edit);
        }
        for (Model.Property property : factory.listProperties()) {
            Field field = property.field;
            String fieldName = field.getName();
            CRUDField crud = field.getAnnotation(CRUDField.class);
            if (crud == null || !crud.autoComplete()) continue;
            Signature autoCompleteSignature = new Signature(Response.class, fieldName + "AutoComplete", this.a(GET.class), this.a(Path.class, restCRUD.collection() + "/auto-complete/" + fieldName), this.linkResourceAnnotation(restCRUD.model(), "autocomplete/" + fieldName, "select"));
            autoCompleteSignature.param(String.class, "q", this.a(QueryParam.class, "q"));
            if (this.hasMethod(ctClass, autoCompleteSignature.name, autoCompleteSignature.signature())) continue;
            CtMethod edit = CtMethod.make((String)(autoCompleteSignature.decl() + " {" + " return super.autoComplete(" + restCRUD.model().getName() + ".class, \"" + fieldName + "\", q); }"), (CtClass)ctClass);
            autoCompleteSignature.annotate(edit);
            ctClass.addMethod(edit);
        }
        Signature descriptorSignature = new Signature(Response.class, "descriptor", this.a(GET.class), this.a(Path.class, restCRUD.collection() + "/descriptor"), this.linkResourceAnnotation(restCRUD.model(), "descriptor", "select"));
        if (!this.hasMethod(ctClass, descriptorSignature.name, descriptorSignature.signature())) {
            CtMethod descriptor = descriptorSignature.method(ctClass, restCRUD.model());
            ctClass.addMethod(descriptor);
        }
        Signature makeDataTableSignature = new Signature(DataTable.class, "makeDataTable", new AnnotationRef[0]);
        makeDataTableSignature.param(String.class, "echo", new AnnotationRef[0]);
        makeDataTableSignature.param(Long.TYPE, "count", new AnnotationRef[0]);
        makeDataTableSignature.param(List.class, "results", new AnnotationRef[0]);
        makeDataTableSignature.param(Class.class, "type", new AnnotationRef[0]);
        makeDataTableSignature.param(Object.class, "oob", new AnnotationRef[0]);
        makeDataTableSignature.param(UriInfo.class, "uriInfo", new AnnotationRef[0]);
        if (!this.hasMethod(ctClass, makeDataTableSignature.name, makeDataTableSignature.signature())) {
            this.makeDataTable(ctClass, makeDataTableSignature, restCRUD.model());
        }
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    private void makeDataTable(CtClass ctClass, Signature makeDataTableSignature, Class<? extends Model> modelClass) throws Exception {
        CtClass dataTableClass = ctClass.makeNestedClass("__DataTable", true);
        ClassPool cp = ctClass.getClassPool();
        dataTableClass.setSuperclass(cp.get(DataTable.class.getName()));
        CtClass[] parameters = new CtClass[makeDataTableSignature.parameters.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = cp.get(makeDataTableSignature.parameters.get((int)i).type.getName());
        }
        CtConstructor dataTableConstructor = CtNewConstructor.make((CtClass[])parameters, null, (int)2, null, null, (CtClass)dataTableClass);
        ConstPool constPool = dataTableClass.getClassFile().getConstPool();
        AnnotationsAttribute annotations = CRUDEnhancer.getAnnotations((CtClass)dataTableClass);
        CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, XmlType.class, this.map(constPool, "namespace", dataTableClass.getName()));
        CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, XmlRootElement.class, this.map(constPool, "name", "dataTable"));
        CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, XmlSeeAlso.class, this.map(constPool, new Object[]{modelClass}));
        CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, Mapped.class, this.map(constPool, "namespaceMap", new Object[]{CRUDEnhancer.createAnnotation(XmlNsMap.class, this.map(constPool, "namespace", "http://www.w3.org/2001/XMLSchema-instance").add("jsonName", "xsi"), constPool), CRUDEnhancer.createAnnotation(XmlNsMap.class, this.map(constPool, "namespace", "http://www.w3.org/2005/Atom").add("jsonName", "atom"), constPool)}));
        dataTableClass.addConstructor(dataTableConstructor);
        ApplicationClasses.ApplicationClass dataTableApplicationClass = new ApplicationClasses.ApplicationClass(dataTableClass.getName());
        dataTableApplicationClass.compiled(dataTableClass.toBytecode());
        dataTableClass.defrost();
        Play.classes.add(dataTableApplicationClass);
        StringBuilder ret = new StringBuilder(makeDataTableSignature.decl());
        ret.append("{ return new ").append(dataTableClass.getName()).append("(");
        boolean once = false;
        for (Param param : makeDataTableSignature.parameters) {
            if (once) {
                ret.append(", ");
            } else {
                once = true;
            }
            ret.append(param.name);
        }
        ret.append("); }");
        CtMethod method = CtMethod.make((String)ret.toString(), (CtClass)ctClass);
        ctClass.addMethod(method);
    }

    private AnnotationRef<?> linkResourceAnnotation(Class<? extends Model> model, String rel, String permission) {
        return this.a(LinkResource.class, model).p("rel", rel).p("constraint", "${p:hasPermission(this, '" + permission + "')}");
    }

    private <T extends java.lang.annotation.Annotation> AnnotationRef<T> a(Class<T> annotationType) {
        return new AnnotationRef<T>(annotationType);
    }

    private <T extends java.lang.annotation.Annotation> AnnotationRef<T> a(Class<T> annotationType, Object value) {
        return new AnnotationRef<T>(annotationType, value);
    }

    public static String t(Class<?> type) {
        return type.getName();
    }

    private static String typeSignature(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                return "J";
            }
            throw new IllegalArgumentException("Primitive types not implemented: " + type);
        }
        return "L" + type.getName() + ";";
    }

    private String getLastTemplateName(String url) {
        if (url == null) {
            throw new RuntimeException("Missing url template");
        }
        int start = url.lastIndexOf(123);
        int end = url.lastIndexOf(125);
        if (start == -1 || end == -1 || start > end) {
            throw new RuntimeException("Missing template in url: " + url);
        }
        String name = url.substring(start + 1, end);
        if (name.length() == 0) {
            throw new RuntimeException("Empty template in url: " + url);
        }
        return name;
    }

    private boolean hasMethod(CtClass ctClass, String name, String signature) {
        try {
            CtMethod method = ctClass.getMethod(name, signature);
            return method.getDeclaringClass() == ctClass;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private ParamMap<String, MemberValue> map(final ConstPool cp, String key, Object value) {
        HashParamMap<String, MemberValue> map = new HashParamMap<String, MemberValue>(){

            @Override
            public ParamMap<String, MemberValue> add(String key, Object value) {
                this.put(key, CRUDEnhancer.makeMemberValue(value, cp));
                return this;
            }
        };
        map.put(key, CRUDEnhancer.makeMemberValue(value, cp));
        return map;
    }

    private ParamMap<String, MemberValue> map(ConstPool cp, Object value) {
        return this.map(cp, "value", value);
    }

    private static MemberValue makeMemberValue(Object value, ConstPool cp) {
        if (value instanceof String) {
            return new StringMemberValue((String)value, cp);
        }
        if (value instanceof Class) {
            return new ClassMemberValue(((Class)value).getName(), cp);
        }
        if (value instanceof Annotation) {
            return new AnnotationMemberValue((Annotation)value, cp);
        }
        if (value.getClass().isArray()) {
            ArrayMemberValue ret = new ArrayMemberValue(cp);
            Object[] values = (Object[])value;
            MemberValue[] elements = new MemberValue[values.length];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = CRUDEnhancer.makeMemberValue(values[i], cp);
            }
            ret.setValue(elements);
            return ret;
        }
        throw new RuntimeException("Invalid member value: " + value);
    }

    protected boolean hasAnnotation(CtClass ctClass, Class<? extends java.lang.annotation.Annotation> type) throws ClassNotFoundException {
        return this.hasAnnotation(ctClass, type.getName());
    }

    protected <T extends java.lang.annotation.Annotation> T getAnnotation(CtClass ctClass, Class<T> type) throws ClassNotFoundException {
        for (Object object : ctClass.getAvailableAnnotations()) {
            java.lang.annotation.Annotation ann = (java.lang.annotation.Annotation)object;
            if (ann.annotationType() != type) continue;
            return (T)ann;
        }
        return null;
    }

    protected static ParameterAnnotationsAttribute getParameterAnnotations(CtMethod ctMethod) throws NotFoundException {
        ParameterAnnotationsAttribute annotationsAttribute = (ParameterAnnotationsAttribute)ctMethod.getMethodInfo().getAttribute("RuntimeVisibleParameterAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new ParameterAnnotationsAttribute(ctMethod.getMethodInfo().getConstPool(), "RuntimeVisibleParameterAnnotations");
            Annotation[][] newAnnotations = new Annotation[ctMethod.getParameterTypes().length][];
            for (int v = 0; v < newAnnotations.length; ++v) {
                newAnnotations[v] = new Annotation[0];
            }
            annotationsAttribute.setAnnotations((Annotation[][])newAnnotations);
            ctMethod.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    protected static void createAnnotation(int i, ParameterAnnotationsAttribute attribute, Class<? extends java.lang.annotation.Annotation> annotationType) {
        CRUDEnhancer.createAnnotation(i, attribute, annotationType, new HashMap<String, MemberValue>());
    }

    protected static void createAnnotation(int i, ParameterAnnotationsAttribute attribute, Class<? extends java.lang.annotation.Annotation> annotationType, Map<String, MemberValue> members) {
        Annotation annotation = new Annotation(annotationType.getName(), attribute.getConstPool());
        for (Map.Entry<String, MemberValue> member : members.entrySet()) {
            annotation.addMemberValue(member.getKey(), member.getValue());
        }
        Annotation[][] annotations = attribute.getAnnotations();
        Annotation[] paramAnnotations = annotations[i];
        Annotation[] newParamAnnotations = new Annotation[paramAnnotations.length + 1];
        System.arraycopy(paramAnnotations, 0, newParamAnnotations, 0, paramAnnotations.length);
        newParamAnnotations[paramAnnotations.length] = annotation;
        annotations[i] = newParamAnnotations;
        attribute.setAnnotations(annotations);
    }

    protected static Annotation createAnnotation(Class<? extends java.lang.annotation.Annotation> annotationType, Map<String, MemberValue> members, ConstPool cp) {
        Annotation annotation = new Annotation(annotationType.getName(), cp);
        for (Map.Entry<String, MemberValue> member : members.entrySet()) {
            annotation.addMemberValue(member.getKey(), member.getValue());
        }
        return annotation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class HashParamMap<K, V>
    extends HashMap<K, V>
    implements ParamMap<K, V> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParamMap<K, V>
    extends Map<K, V> {
        public ParamMap<K, V> add(K var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationRef<T extends java.lang.annotation.Annotation> {
        public Class<T> type;
        public Map<String, Object> properties = new HashMap<String, Object>();

        public AnnotationRef(Class<T> type) {
            this.type = type;
        }

        public Map<String, MemberValue> getProperties(ConstPool cp) {
            HashMap<String, MemberValue> ret = new HashMap<String, MemberValue>();
            for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
                ret.put(prop.getKey(), CRUDEnhancer.makeMemberValue(prop.getValue(), cp));
            }
            return ret;
        }

        public AnnotationRef(Class<T> type, Object value) {
            this(type);
            this.properties.put("value", value);
        }

        public AnnotationRef<T> p(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Param {
        public Class<?> type;
        public String name;
        public List<AnnotationRef<?>> annotations = new ArrayList();

        public Param(Class<?> type, String name, AnnotationRef<?> ... annotations) {
            this.type = type;
            this.name = name;
            for (AnnotationRef<?> a : annotations) {
                this.annotations.add(a);
            }
        }

        public void createAnnotations(int i, ParameterAnnotationsAttribute paramAnnotations, ConstPool cp) {
            for (AnnotationRef<?> a : this.annotations) {
                CRUDEnhancer.createAnnotation(i, paramAnnotations, a.type, a.getProperties(cp));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Signature {
        public String name;
        public Class<?> returnClass;
        public List<Param> parameters = new ArrayList<Param>();
        public List<AnnotationRef<?>> annotations = new ArrayList();

        public Signature(Class<?> returnClass, String name, AnnotationRef<?> ... annotations) {
            this.name = name;
            this.returnClass = returnClass;
            for (AnnotationRef<?> a : annotations) {
                this.annotations.add(a);
            }
        }

        public Signature param(Class<?> type, String name, AnnotationRef<?> ... annotations) {
            this.parameters.add(new Param(type, name, annotations));
            return this;
        }

        public String signature() {
            StringBuilder ret = new StringBuilder("(");
            ret.append(CRUDEnhancer.typeSignature(this.returnClass));
            ret.append(")");
            boolean first = true;
            for (Param param : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    ret.append(",");
                }
                ret.append(CRUDEnhancer.typeSignature(param.type));
            }
            return ret.toString();
        }

        public String decl() {
            StringBuilder ret = new StringBuilder("public ");
            ret.append(CRUDEnhancer.t(this.returnClass));
            ret.append(" ").append(this.name).append("(");
            boolean first = true;
            for (Param param : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    ret.append(",");
                }
                ret.append(CRUDEnhancer.t(param.type)).append(" ").append(param.name);
            }
            ret.append(")");
            return ret.toString();
        }

        public CtMethod method(CtClass ctClass, Class<?> crudModel) throws CannotCompileException, NotFoundException {
            StringBuilder ret = new StringBuilder(this.decl());
            ret.append("{ return super.").append(this.name).append("(");
            ret.append(CRUDEnhancer.t(crudModel)).append(".class");
            for (Param param : this.parameters) {
                ret.append(", ").append(param.name);
            }
            ret.append("); }");
            CtMethod method = CtMethod.make((String)ret.toString(), (CtClass)ctClass);
            return this.annotate(method);
        }

        private CtMethod annotate(CtMethod method) throws NotFoundException {
            ConstPool cp = method.getDeclaringClass().getClassFile().getConstPool();
            ParameterAnnotationsAttribute paramAnnotations = CRUDEnhancer.getParameterAnnotations(method);
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.parameters.get(i).createAnnotations(i, paramAnnotations, cp);
            }
            AnnotationsAttribute annotations = CRUDEnhancer.getAnnotations((CtMethod)method);
            for (AnnotationRef<?> a : this.annotations) {
                CRUDEnhancer.createAnnotation((AnnotationsAttribute)annotations, (Class)a.type, (Map)a.getProperties(cp));
            }
            return method;
        }
    }
}

