/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.db.jpa.JPA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedQuery<T> {
    private String hql;
    public String order;
    public String group;
    public Map<String, Object> parameters = new HashMap<String, Object>();
    public String search;
    public List<String> searchFields = new ArrayList<String>();
    public Long start;
    public Long limit;
    private Long count;

    public PagedQuery(String hql) {
        this.hql = hql;
    }

    public PagedQuery<T> searchFields(String ... searchFields) {
        this.searchFields.clear();
        Collections.addAll(this.searchFields, searchFields);
        return this;
    }

    public PagedQuery<T> searchFields(Set<String> searchFields) {
        this.searchFields.clear();
        this.searchFields.addAll(searchFields);
        return this;
    }

    private String getHQLQuery(boolean forSelect) {
        String hql = this.hql;
        if (!StringUtils.isEmpty((String)this.search) && !this.searchFields.isEmpty()) {
            hql = hql.toLowerCase().contains(" where ") ? hql + " AND (" : hql + " WHERE (";
            boolean first = true;
            for (String field : this.searchFields) {
                if (!first) {
                    hql = hql + " OR ";
                } else {
                    first = false;
                }
                hql = hql + "LOCATE(lower(:_search), lower(" + field + ")) > 0";
            }
            hql = hql + ")";
            this.parameters.put("_search", this.search);
        }
        if (forSelect && !StringUtils.isEmpty((String)this.group)) {
            hql = hql + " GROUP BY " + this.group;
        }
        if (forSelect && !StringUtils.isEmpty((String)this.order)) {
            hql = hql + " ORDER BY " + this.order;
        }
        return hql;
    }

    private Query getCountQuery() {
        String hql = this.getHQLQuery(false);
        hql = hql.trim();
        int fromClause = hql.toLowerCase().indexOf("from ");
        String count = StringUtils.isEmpty((String)this.group) ? "COUNT(*) " : "COUNT(DISTINCT " + this.group + ") ";
        hql = "SELECT " + count + hql.substring(fromClause);
        return this.getQuery(hql);
    }

    private Query getQuery() {
        return this.getQuery(this.getHQLQuery(true));
    }

    private Query getQuery(String hql) {
        Logger.info((String)"Making HQL query: %s", (Object[])new Object[]{hql});
        Query query = JPA.em().createQuery(hql);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
            Logger.info((String)" Query param %s => %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
        return query;
    }

    public long getCount() {
        if (this.count == null) {
            Query query = this.getCountQuery();
            this.count = (Long)query.getSingleResult();
        }
        return this.count;
    }

    public List<T> getResultList() {
        Query query = this.getQuery();
        if (this.start != null) {
            query.setFirstResult(this.start.intValue());
        }
        if (this.limit != null) {
            query.setMaxResults(this.limit.intValue());
        }
        return query.getResultList();
    }
}

