/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy.crud;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import play.Logger;
import play.db.Model;
import play.modules.resteasy.crud.AutoComplete;
import play.modules.resteasy.crud.CRUDField;
import play.modules.resteasy.crud.CRUDOrder;
import play.modules.resteasy.crud.CRUDSecure;
import play.modules.resteasy.crud.DataTable;
import play.modules.resteasy.crud.DataTableQuery;
import play.modules.resteasy.crud.JAXBList;
import play.modules.resteasy.crud.PagedQuery;
import play.modules.resteasy.crud.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RESTResource {
    protected boolean hasPermission(Object target, String name) {
        return CRUDSecure.hasPermission(target, name);
    }

    protected void checkPermission(Object target, String name) {
        if (!this.hasPermission(target, name)) {
            throw new WebApplicationException(403);
        }
    }

    protected <T> T checkNotFound(T o) {
        if (o == null) {
            throw new WebApplicationException(404);
        }
        return o;
    }

    protected <T> T checkNotFound(T o, String msg, Object ... params) {
        if (o == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)String.format(msg, params)).build());
        }
        return o;
    }

    protected void checkEmpty(Object ... objects) {
        for (Object o : objects) {
            if (o == null || o instanceof Collection && ((Collection)o).isEmpty()) continue;
            throw new WebApplicationException(400);
        }
    }

    protected <T> T checkForUpdate(T o, T oDB) {
        this.checkPermission(o, "insert");
        this.checkNotFound(oDB);
        this.checkPermission(oDB, "update");
        return oDB;
    }

    protected void checkAutoCompleteQuery(String ... values) {
    }

    protected Response notFound() {
        return this.status(404);
    }

    protected Response forbidden() {
        return this.status(403);
    }

    protected Response badRequest() {
        return this.status(400);
    }

    protected Response badRequest(String message, Object ... args) {
        return this.status(400, message, args);
    }

    protected Response noContent() {
        return this.status(204);
    }

    protected Response created() {
        return this.status(201);
    }

    protected Response internalError() {
        return this.status(500);
    }

    protected Response ok() {
        return this.status(200);
    }

    protected Response ok(Object entity) {
        return this.status(200, entity);
    }

    protected Response internalError(String msg, Object ... args) {
        return this.status(500, msg, args);
    }

    protected Response internalError(Throwable t, String msg, Object ... args) {
        Logger.error((Throwable)t, (String)msg, (Object[])args);
        return this.status(500, msg, args);
    }

    protected Response status(int code) {
        Logger.info((String)"Returning code %s", (Object[])new Object[]{code});
        return Response.status((int)code).build();
    }

    protected Response status(int code, String message, Object ... args) {
        String entity = String.format(message, args) + "\n";
        return this.status(code, entity);
    }

    protected Response status(int code, Object entity) {
        Logger.info((String)"Returning code %s: %s", (Object[])new Object[]{code, entity});
        return Response.status((int)code).entity(entity).build();
    }

    protected void respond(Response r) {
        throw this.toThrowable(r);
    }

    protected WebApplicationException toThrowable(Response r) {
        return new WebApplicationException(r);
    }

    protected Response autoComplete(List<String> list) {
        return this.ok(new JAXBList(list));
    }

    protected void throwConstraintValidation(Object entity, String message, String field, Object value) {
        throw new InvalidStateException(new InvalidValue[]{new InvalidValue(message, entity.getClass(), field, value, entity)});
    }

    public <T extends Model> Response list(Class<T> model, DataTableQuery q) {
        this.logQuery(q);
        this.checkPermission(model, "select");
        PagedQuery<T> carriers = this.findPaged(model);
        return this.makeQueryResponse(q, carriers, model, this.getSortableColumns(model), q.uriInfo, new String[0]);
    }

    public <T extends Model> Response get(Class<T> model, Object id) {
        Model.Factory factory = Model.Manager.factoryFor(model);
        Model entity = factory.findById(id);
        this.checkNotFound(entity, "Entity of type %s with id of %s could not be found", model.getName(), id);
        this.checkPermission(entity, "select");
        return this.ok(entity);
    }

    public <T extends Model> Response delete(Class<T> model, Object id) {
        Model.Factory factory = Model.Manager.factoryFor(model);
        Model entity = factory.findById(id);
        this.checkNotFound(entity, "Entity of type %s with id of %s could not be found", model.getName(), id);
        this.checkPermission(entity, "delete");
        entity._delete();
        return this.noContent();
    }

    public <T extends Model> Response add(Class<T> model, final T elem, UriInfo uriInfo) {
        this.checkPermission(elem, "insert");
        RESTResource.walkProperties(model, new PropertyWalker(){

            public void walk(Model.Property property, Field field, CRUDField crud) {
                Object newValue;
                try {
                    newValue = PropertyUtils.getSimpleProperty((Object)elem, (String)property.name);
                }
                catch (Exception e) {
                    throw RESTResource.this.toThrowable(RESTResource.this.internalError(e, "Failed to get property %s", property.name));
                }
                if (crud == null || !crud.editable()) {
                    RESTResource.this.checkEmpty(newValue);
                }
            }
        });
        elem._save();
        return this.created();
    }

    public <T extends Model> Response edit(Class<T> model, Object id, final T elem) {
        Model.Factory factory = Model.Manager.factoryFor(model);
        final Model elemFromDB = factory.findById(id);
        this.checkForUpdate(elem, elemFromDB);
        RESTResource.walkProperties(model, new PropertyWalker(){

            public void walk(Model.Property property, Field field, CRUDField crud) {
                Object newValue;
                try {
                    newValue = PropertyUtils.getSimpleProperty((Object)elem, (String)property.name);
                }
                catch (Exception e) {
                    throw RESTResource.this.toThrowable(RESTResource.this.internalError(e, "Failed to get property %s", property.name));
                }
                if (crud == null || !crud.editable()) {
                    RESTResource.this.checkEmpty(newValue);
                } else {
                    try {
                        PropertyUtils.setSimpleProperty((Object)elemFromDB, (String)property.name, (Object)newValue);
                    }
                    catch (Exception e) {
                        throw RESTResource.this.toThrowable(RESTResource.this.internalError(e, "Failed to set property %s", property.name));
                    }
                }
            }
        });
        elemFromDB._save();
        return this.noContent();
    }

    public <T extends Model> Response autoComplete(Class<T> model, String field, String q) {
        this.checkAutoCompleteQuery(q);
        this.checkPermission(model, "select");
        return this.autoComplete(AutoComplete.getAutoComplete(model, field, q));
    }

    public <T extends Model> Response descriptor(Class<T> model) {
        this.checkPermission(model, "select");
        return Response.ok(new Descriptor<T>(model)).build();
    }

    protected static <T extends Model> void walkProperties(Class<T> model, PropertyWalker walker) {
        Model.Factory factory = Model.Manager.factoryFor(model);
        for (Model.Property prop : factory.listProperties()) {
            Field field = prop.field;
            CRUDField crud = field.getAnnotation(CRUDField.class);
            walker.walk(prop, field, crud);
        }
    }

    protected <T extends Model> Set<String> getSortableColumns(Class<T> model) {
        final HashSet<String> ret = new HashSet<String>();
        RESTResource.walkProperties(model, new PropertyWalker(){

            public void walk(Model.Property property, Field field, CRUDField crud) {
                if (crud != null && crud.sortable()) {
                    ret.add(property.name);
                }
            }
        });
        return ret;
    }

    protected <T extends Model> Set<String> getSearchableColumns(Class<T> model) {
        final HashSet<String> ret = new HashSet<String>();
        RESTResource.walkProperties(model, new PropertyWalker(){

            public void walk(Model.Property property, Field field, CRUDField crud) {
                if (crud != null && crud.searchable()) {
                    ret.add(property.name);
                }
            }
        });
        return ret;
    }

    protected <T extends Model> PagedQuery<T> findPaged(Class<T> model) {
        PagedQuery query = new PagedQuery("FROM " + model.getSimpleName());
        query.searchFields(this.getSearchableColumns(model));
        return query;
    }

    protected <T> Response makeQueryResponse(DataTableQuery q, PagedQuery<T> results, Class<T> klass, Set<String> validColumns, UriInfo uriInfo, String ... permissions) {
        return this.makeQueryResponse(q, results, klass, validColumns, null, uriInfo, permissions);
    }

    protected <T> Response makeQueryResponse(DataTableQuery q, PagedQuery<T> results, Class<T> klass, Set<String> validColumns, Object oob, UriInfo uriInfo, String ... permissions) {
        results.start = q.start;
        results.limit = q.length;
        if (this.isSortValid(q.sort, validColumns)) {
            results.order = q.sort;
        }
        if (!StringUtils.isEmpty((String)q.search)) {
            results.search = q.search;
        }
        DataTable<T> dataTable = this.makeDataTable(q.echo, results.getCount(), results.getResultList(), klass, oob, uriInfo);
        for (String permission : permissions) {
            if (!this.hasPermission(dataTable.facadeFor(), permission)) continue;
            dataTable.addPermission(permission);
        }
        Logger.info((String)"Returning 200 with entity: %s", (Object[])new Object[]{dataTable});
        return Response.ok(dataTable).build();
    }

    protected <T> DataTable<T> makeDataTable(String echo, long count, List<T> results, Class<T> type, Object oob, UriInfo uriInfo) {
        return new DataTable<T>(echo, count, results, type, oob, uriInfo);
    }

    protected boolean isSortValid(String sort, Set<String> validColumns) {
        if (sort == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(sort, ",");
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            String fragment = tokenizer.nextToken().trim();
            String field = fragment.toLowerCase().endsWith(" desc") ? fragment.substring(0, fragment.length() - 5).trim() : (fragment.toLowerCase().endsWith(" asc") ? fragment.substring(0, fragment.length() - 4).trim() : fragment);
            if (field.matches("\\d+") || validColumns.contains(field)) continue;
            return false;
        }
        return true;
    }

    protected void logQuery(DataTableQuery q) {
        Logger.info((String)"GET start: %s, length: %s, echo: %s, sort: %s, search: %s", (Object[])new Object[]{q.start, q.length, q.echo, q.sort, q.search});
    }

    public static interface PropertyWalker {
        public void walk(Model.Property var1, Field var2, CRUDField var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Column {
        @XmlElement
        public String name;
        @XmlElement
        public String field;
        @XmlElement
        public boolean editable;
        @XmlElement
        public boolean sortable;
        @XmlElement
        public boolean autocomplete;
        @XmlElement
        public String type;
        @XmlElement
        public List<String> validators = new ArrayList<String>();

        public Column() {
        }

        public Column(Model.Property p, Field field, CRUDField crud) {
            this.field = this.name = p.name;
            this.editable = false;
            this.autocomplete = false;
            this.sortable = false;
            Class<?> fieldType = field.getType();
            this.setType(fieldType);
            if (crud != null) {
                if (crud.name().length() > 0) {
                    this.name = crud.name();
                }
                this.editable = crud.editable();
                this.autocomplete = crud.autoComplete();
                this.sortable = crud.sortable();
                Type crudType = crud.type();
                if (crudType != Type.DEFAULT) {
                    this.type = crudType.name();
                }
            }
            this.addValidation(field);
        }

        private void addValidation(Field field) {
            if (field.isAnnotationPresent(NotEmpty.class) || field.isAnnotationPresent(NotNull.class)) {
                this.validators.add("notempty");
            }
        }

        private void setType(Class<?> fieldType) {
            if (fieldType == String.class) {
                this.type = Type.STRING.name();
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                this.type = Type.INTEGER.name();
            } else if (fieldType == Boolean.class) {
                this.type = Type.BOOLEAN.name();
            } else {
                throw new RuntimeException("Unknown field type: " + fieldType.getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Descriptor<T extends Model> {
        @XmlElement
        public List<Column> columns = new ArrayList<Column>();

        public Descriptor() {
        }

        public Descriptor(Class<T> model) {
            RESTResource.walkProperties(model, new PropertyWalker(){

                public void walk(Model.Property property, Field field, CRUDField crud) {
                    Descriptor.this.addColumn(property, field, crud);
                }
            });
            CRUDOrder crudOrder = model.getAnnotation(CRUDOrder.class);
            if (crudOrder != null) {
                ArrayList<Column> sortedColumns = new ArrayList<Column>();
                for (String field : crudOrder.value()) {
                    int i = this.findColumn(field);
                    if (i == -1) {
                        throw new RuntimeException("No such field in model: " + field);
                    }
                    sortedColumns.add(this.columns.remove(i));
                }
                sortedColumns.addAll(this.columns);
                this.columns = sortedColumns;
            }
        }

        private int findColumn(String field) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (!this.columns.get((int)i).field.equals(field)) continue;
                return i;
            }
            return -1;
        }

        private void addColumn(Model.Property p, Field field, CRUDField crud) {
            if (crud == null) {
                return;
            }
            this.columns.add(new Column(p, field, crud));
        }
    }
}

