/*
 * Decompiled with CFR 0.152.
 */
package play.modules.resteasy.crud;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jboss.resteasy.annotations.DecorateTypes;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;
import play.Logger;
import play.modules.resteasy.crud.UnmarshallingError;
import play.modules.resteasy.crud.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DecorateTypes(value={"text/*+xml", "application/*+xml", "application/xml", "application/json", "application/*+json"})
public class Validator
implements DecoratorProcessor<Unmarshaller, Validate> {
    public Unmarshaller decorate(Unmarshaller target, Validate annotation, Class type, Annotation[] annotations, MediaType mediaType) {
        try {
            ErrorCollector errorCollector = new ErrorCollector();
            target.setEventHandler((ValidationEventHandler)errorCollector);
            target.setListener((Unmarshaller.Listener)errorCollector);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return target;
    }

    static class ErrorCollector
    extends Unmarshaller.Listener
    implements ValidationEventHandler {
        private List<ValidationEvent> events = new ArrayList<ValidationEvent>();

        ErrorCollector() {
        }

        public boolean handleEvent(ValidationEvent event) {
            Logger.info((String)"Validation event: %s", (Object[])new Object[]{event});
            if (event.getSeverity() == 1 || event.getSeverity() == 2) {
                this.events.add(event);
            }
            return true;
        }

        public void afterUnmarshal(Object target, Object parent) {
            super.afterUnmarshal(target, parent);
            if (!this.events.isEmpty()) {
                throw new UnmarshallingError(this.events);
            }
        }
    }
}

