/*
 * Decompiled with CFR 0.152.
 */
package net.parnassoft.playutilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import play.mvc.ActionInvoker;
import play.mvc.Controller;
import play.mvc.Http;

public class ControllerUtility {
    public static <T extends Annotation> T getActionAnnotation(Class<T> clazz) {
        Method m = (Method)ActionInvoker.getActionMethod((String)Http.Request.current().action)[1];
        if (m.isAnnotationPresent(clazz)) {
            return m.getAnnotation(clazz);
        }
        return null;
    }

    public static boolean hasActionAnnotation(Class<? extends Annotation> clazz) {
        Method m = (Method)ActionInvoker.getActionMethod((String)Http.Request.current().action)[1];
        return m.isAnnotationPresent(clazz);
    }

    public static <T extends Annotation> T getControllerAnnotation(Class<T> clazz) {
        if (ControllerUtility.getControllerClass().isAnnotationPresent(clazz)) {
            return ControllerUtility.getControllerClass().getAnnotation(clazz);
        }
        return null;
    }

    public static boolean hasControllerAnnotation(Class<? extends Annotation> clazz) {
        return ControllerUtility.getControllerClass().isAnnotationPresent(clazz);
    }

    public static <T extends Annotation> T getControllerInheritedAnnotation(Class<T> clazz) {
        Class<? extends Controller> c = ControllerUtility.getControllerClass();
        while (!c.equals(Object.class)) {
            if (c.isAnnotationPresent(clazz)) {
                return c.getAnnotation(clazz);
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static boolean hasControllerInheritedAnnotation(Class<? extends Annotation> clazz) {
        Class<? extends Controller> c = ControllerUtility.getControllerClass();
        while (!c.equals(Object.class)) {
            if (c.isAnnotationPresent(clazz)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static Class<? extends Controller> getControllerClass() {
        return Http.Request.current().controllerClass;
    }
}

