/*
 * Decompiled with CFR 0.152.
 */
package net.parnassoft.playutilities;

import java.lang.annotation.Annotation;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javax.persistence.Entity;
import net.parnassoft.playutilities.annotations.Interceptor;
import play.db.jpa.JPABase;
import play.mvc.Controller;

public class EnhancerUtility {
    public static boolean isAController(ClassPool classPool, CtClass ctClass) throws Exception {
        return ctClass.subtypeOf(classPool.get(Controller.class.getName()));
    }

    public static boolean isAModel(ClassPool classPool, CtClass ctClass) throws Exception {
        return ctClass.subtypeOf(classPool.get(JPABase.class.getName()));
    }

    public static boolean isAnEntity(CtClass ctClass) throws Exception {
        return EnhancerUtility.hasAnnotation(ctClass, Entity.class.getName());
    }

    public static boolean isAnInterceptor(CtClass ctClass) throws Exception {
        return EnhancerUtility.hasAnnotation(ctClass, Interceptor.class.getName());
    }

    public static boolean isPublicStaticVoid(CtMethod ctMethod) throws Exception {
        return Modifier.isPublic((int)ctMethod.getModifiers()) && Modifier.isStatic((int)ctMethod.getModifiers()) && ctMethod.getReturnType().equals(CtClass.voidType);
    }

    public static boolean hasAnnotation(CtClass ctClass, String annotation) throws ClassNotFoundException {
        return EnhancerUtility.hasAnnotation(annotation, ctClass.getAvailableAnnotations());
    }

    public static boolean hasAnnotation(CtMethod ctMethod, String annotation) throws ClassNotFoundException {
        return EnhancerUtility.hasAnnotation(annotation, ctMethod.getAvailableAnnotations());
    }

    public static boolean hasAnnotation(CtField ctField, String annotation) throws ClassNotFoundException {
        return EnhancerUtility.hasAnnotation(annotation, ctField.getAvailableAnnotations());
    }

    private static boolean hasAnnotation(String annotation, Object ... annotations) {
        for (Object object : annotations) {
            Annotation ann = (Annotation)object;
            if (!ann.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }
}

