/*
 * Decompiled with CFR 0.152.
 */
package net.parnassoft.playutilities;

import play.Logger;
import play.data.validation.Error;
import play.data.validation.Validation;
import play.mvc.Http;

public class PlayUtility {
    public static void printParams(Http.Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("-----PARAMS-----%n", new Object[0]));
        for (String name : request.params.all().keySet()) {
            sb.append(String.format("%s: %s%n", name, request.params.get(name)));
        }
        Logger.debug((String)sb.toString(), (Object[])new Object[0]);
    }

    public static void printHeaders(Http.Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("-----HEADERS-----%n", new Object[0]));
        for (String name : request.headers.keySet()) {
            sb.append(String.format("%s: %s%n", name, ((Http.Header)request.headers.get(name)).value()));
        }
        Logger.debug((String)sb.toString(), (Object[])new Object[0]);
    }

    public static void printErrors() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("-----ERRORS-----%n", new Object[0]));
        sb.append(String.format("%n", new Object[0]));
        for (Error error : Validation.errors()) {
            sb.append(error);
        }
        sb.append(String.format("%n", new Object[0]));
        Logger.debug((String)sb.toString(), (Object[])new Object[0]);
    }

    public static void printRequest(Http.Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%n", new Object[0]));
        sb.append(String.format("-----REQUEST-----%n", new Object[0]));
        sb.append(String.format("request.domain: %s%n", request.domain));
        sb.append(String.format("request.port: %s%n", request.port));
        sb.append(String.format("request.action: %s%n", request.action));
        sb.append(String.format("request.actionMethod: %s%n", request.actionMethod));
        sb.append(String.format("request.url: %s%n", request.url));
        sb.append(String.format("request.path: %s%n", request.path));
        sb.append(String.format("request.host: %s%n", request.host));
        sb.append(String.format("request.format: %s%n", request.format));
        sb.append(String.format("request.base: %s%n", request.getBase()));
        sb.append(String.format("%n", new Object[0]));
        Logger.debug((String)sb.toString(), (Object[])new Object[0]);
    }
}

