/*
 * Decompiled with CFR 0.152.
 */
package net.parnassoft.playutilities;

import net.parnassoft.playutilities.RequestUtility;
import play.mvc.Router;
import play.mvc.results.Redirect;

public class UrlUtility {
    public static void redirectToDomain() {
        String url = UrlUtility.buildFullDomainUrl();
        UrlUtility.redirectTo(url);
    }

    public static void redirectToUriPattern(String path) {
        UrlUtility.redirectTo(UrlUtility.buildFullUrl(path));
    }

    public static void redirectByReverseRouting(String javaCall) {
        String url = Router.reverse((String)javaCall).url;
        UrlUtility.redirectToUriPattern(url);
    }

    public static void redirectToUrl(String url) {
        UrlUtility.redirectTo(url);
    }

    private static void redirectTo(String url) {
        boolean permanent = false;
        throw new Redirect(url, permanent);
    }

    private static String buildFullDomainUrl() {
        return String.format("%s://%s", RequestUtility.getScheme(), RequestUtility.getBase());
    }

    private static String buildFullReferredUrl(String url) throws Throwable {
        return String.format("%s://%s%s", RequestUtility.getScheme(), RequestUtility.getBase(), url);
    }

    private static String buildFullUrl(String uriPattern) {
        return String.format("%s://%s%s", RequestUtility.getScheme(), RequestUtility.getBase(), uriPattern);
    }
}

