/*
 * Decompiled with CFR 0.152.
 */
package play.modules.reverseproxy;

import net.parnassoft.playutilities.ControllerUtility;
import net.parnassoft.playutilities.UrlUtility;
import play.Logger;
import play.Play;
import play.modules.reverseproxy.ReverseProxyUtility;
import play.modules.reverseproxy.annotations.GlobalSwitchScheme;
import play.modules.reverseproxy.annotations.SchemeType;
import play.modules.reverseproxy.annotations.SwitchScheme;
import play.mvc.Http;

public class ReverseProxy {
    private static boolean reverseProxyEnabled = ReverseProxyUtility.Config.isReverseProxyEnabled();

    public static void initSwitchScheme() {
        SchemeType schemeType;
        boolean keepUrl = false;
        SwitchScheme switchScheme = (SwitchScheme)ControllerUtility.getActionAnnotation(SwitchScheme.class);
        if (switchScheme != null) {
            schemeType = switchScheme.type();
            keepUrl = switchScheme.keepUrl();
        } else {
            GlobalSwitchScheme globalSwitchScheme = (GlobalSwitchScheme)ControllerUtility.getControllerAnnotation(GlobalSwitchScheme.class);
            schemeType = globalSwitchScheme != null ? globalSwitchScheme.type() : SchemeType.HTTP;
        }
        ReverseProxy.switchOver(schemeType, keepUrl);
    }

    private static void switchOver(SchemeType schemeType, boolean keepActionUrl) {
        if (schemeType == SchemeType.UNSPECIFIED) {
            Logger.warn((String)"The action have a UNSPECIFIED SchemeType, by default will pass with the last SchemeType used on the flow", (Object[])new Object[0]);
            return;
        }
        if (keepActionUrl) {
            ReverseProxyUtility.createReferredUrlCookie();
        }
        ReverseProxy.doSwitchScheme(schemeType);
    }

    private static void doSwitchScheme(SchemeType schemeType) {
        String httpsPort = Play.configuration.getProperty("https.port");
        if (!reverseProxyEnabled && httpsPort == null) {
            Http.Request.current().secure = false;
            return;
        }
        ReverseProxy.switchScheme(schemeType);
    }

    private static void switchScheme(SchemeType schemeType) throws IllegalArgumentException {
        Http.Request request = Http.Request.current();
        switch (schemeType) {
            case HTTP: {
                if (request.secure.booleanValue()) {
                    ReverseProxy.hackRequestForSwitchingInsecureScheme();
                    UrlUtility.redirectToUriPattern((String)request.path);
                } else {
                    ReverseProxy.hackRequestForSwitchingInsecureScheme();
                    return;
                }
            }
            case HTTPS: {
                if (!request.secure.booleanValue()) {
                    ReverseProxy.hackRequestForSwitchingSecureScheme();
                    UrlUtility.redirectToUriPattern((String)request.path);
                    break;
                }
                ReverseProxy.hackRequestForSwitchingSecureScheme();
                return;
            }
        }
    }

    private static void hackRequestForSwitchingSecureScheme() {
        Http.Request.current().secure = true;
        ReverseProxy.hackRequestPort();
    }

    private static void hackRequestForSwitchingInsecureScheme() {
        Http.Request.current().secure = false;
        ReverseProxy.hackRequestPort();
    }

    private static void hackRequestPort() {
        String httpPort = Play.configuration.getProperty("http.port");
        String httpsPort = Play.configuration.getProperty("https.port");
        Http.Request request = Http.Request.current();
        if (reverseProxyEnabled && request.secure.booleanValue()) {
            request.port = ReverseProxyUtility.Config.getReverseProxyHttpsPort();
        } else if (reverseProxyEnabled && !request.secure.booleanValue()) {
            request.port = ReverseProxyUtility.Config.getReverseProxyHttpPort();
        } else if (!reverseProxyEnabled && request.secure.booleanValue()) {
            request.port = Integer.parseInt(httpsPort);
        } else if (!reverseProxyEnabled && !request.secure.booleanValue()) {
            request.port = Integer.parseInt(httpPort);
        }
    }
}

