/*
 * Decompiled with CFR 0.152.
 */
package play.modules.reverseproxy;

import java.lang.reflect.Method;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.ConfigurationException;
import play.modules.reverseproxy.ReverseProxy;
import play.modules.reverseproxy.ReverseProxyUtility;

public class ReverseProxyPlugin
extends PlayPlugin {
    public void onLoad() {
        boolean reverseProxyEnabled = ReverseProxyUtility.Config.isReverseProxyEnabled();
        String httpPort = Play.configuration.getProperty("http.port");
        String httpsPort = Play.configuration.getProperty("https.port");
        if (httpPort == null && httpsPort != null) {
            String error = "===== https.port property is configured, but http.port property is not configured. Check your application.conf =====";
            throw new ConfigurationException(error);
        }
        if (!reverseProxyEnabled) {
            String error = "===== WARNING: ReverseProxy is declared, but is not enabled. =====";
            Logger.warn((String)error, (Object[])new Object[0]);
            if (httpsPort == null) {
                error = "===== ReverseProxy is not enabled and https.port property is not configured, therefore, only built-in sever HTTP port will be used. Check your application.conf =====";
                Logger.warn((String)error, (Object[])new Object[0]);
            }
        } else {
            if (reverseProxyEnabled && httpsPort == null) {
                String error = "===== ReverseProxy is enabled, but https.port property is not configured. Check your application.conf =====";
                throw new ConfigurationException(error);
            }
            if (ReverseProxyUtility.Config.getReverseProxyHttpAddress() == null) {
                String error = "===== ReverseProxy is declared and enabled, but doesn't have an address configured. Check your application.conf =====";
                Logger.fatal((String)error, (Object[])new Object[0]);
                throw new ConfigurationException(error);
            }
            if (ReverseProxyUtility.Config.getReverseProxyHttpPort() == 0 || ReverseProxyUtility.Config.getReverseProxyHttpsPort() == 0) {
                String error = "===== ReverseProxy is declared and enabled, but doesn't have ports configured. Check your application.conf =====";
                Logger.fatal((String)error, (Object[])new Object[0]);
                throw new ConfigurationException(error);
            }
        }
        String reverseProxyAddress = Play.configuration.getProperty("reverse_proxy.http.address");
        Play.configuration.setProperty("XForwardedSupport", reverseProxyAddress);
    }

    public void beforeActionInvocation(Method actionMethod) {
        ReverseProxy.initSwitchScheme();
    }
}

