/*
 * Decompiled with CFR 0.152.
 */
package play.modules.reverseproxy;

import net.parnassoft.playutilities.CookieUtility;
import net.parnassoft.playutilities.RequestUtility;
import net.parnassoft.playutilities.UrlUtility;
import play.Logger;
import play.Play;
import play.libs.Crypto;
import play.mvc.Http;

public class ReverseProxyUtility {
    private static final String COOKIE_NAME = "REFERRED_URL";

    public static String getBase() {
        Http.Request request = Http.Request.current();
        if (Config.isReverseProxyEnabled()) {
            int port = request.secure != false ? Config.getReverseProxyHttpsPort() : Config.getReverseProxyHttpPort();
            return String.format("%s%s", request.domain, port == 80 || port == 443 ? "" : ":" + port);
        }
        return RequestUtility.getBase();
    }

    public static void redirectToReferredUrl() throws Throwable {
        String referredUrl = ReverseProxyUtility.readReferredUrlCookie();
        String fullReferredUrl = String.format("%s://%s%s", RequestUtility.getScheme(), ReverseProxyUtility.getBase(), referredUrl);
        Logger.debug((String)"%s: %s", (Object[])new Object[]{COOKIE_NAME, fullReferredUrl});
        ReverseProxyUtility.deleteReferredUrlCookie();
        UrlUtility.redirectToUrl((String)fullReferredUrl);
    }

    public static void redirectToDomain() {
        String url = String.format("%s://%s", RequestUtility.getScheme(), ReverseProxyUtility.getBase());
        UrlUtility.redirectToUrl((String)url);
    }

    public static void createReferredUrlCookie() {
        Http.Request request = Http.Request.current();
        String url = "GET".equals(request.method) ? request.url : "/";
        String urlEncrypted = Crypto.encryptAES((String)url);
        CookieUtility.createCookie((String)COOKIE_NAME, (String)urlEncrypted);
    }

    public static String readReferredUrlCookie() {
        String urlEncrypted = CookieUtility.readCookie((String)COOKIE_NAME);
        if (urlEncrypted != null) {
            return Crypto.decryptAES((String)urlEncrypted);
        }
        return "/";
    }

    public static void deleteReferredUrlCookie() {
        CookieUtility.deleteCookie((String)COOKIE_NAME);
    }

    public static class Config {
        public static String getReverseProxyHttpAddress() {
            return Play.configuration.getProperty("reverse_proxy.http.address");
        }

        public static boolean isReverseProxyEnabled() {
            return Boolean.parseBoolean(Play.configuration.getProperty("reverse_proxy.enable"));
        }

        public static int getReverseProxyHttpPort() {
            return Integer.parseInt(Play.configuration.getProperty("reverse_proxy.http.port"));
        }

        public static int getReverseProxyHttpsPort() {
            return Integer.parseInt(Play.configuration.getProperty("reverse_proxy.https.port"));
        }
    }
}

