/*
 * Decompiled with CFR 0.152.
 */
package play.modules.riak;

import com.basho.riak.client.RiakLink;
import com.basho.riak.client.RiakObject;
import com.basho.riak.client.mapreduce.JavascriptFunction;
import com.basho.riak.client.mapreduce.MapReduceFunction;
import com.basho.riak.client.response.BucketResponse;
import com.basho.riak.client.response.HttpResponse;
import com.basho.riak.client.response.MapReduceResponse;
import com.basho.riak.client.response.StoreResponse;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.modules.riak.RiakKey;
import play.modules.riak.RiakMP;
import play.modules.riak.RiakPath;
import play.modules.riak.RiakPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakModel {
    private RiakObject obj;

    public RiakObject getObj() {
        return this.obj;
    }

    public void setObj(RiakObject obj) {
        this.obj = obj;
    }

    public Map<String, String> getUserMeta() {
        return this.obj.getUsermeta();
    }

    public void setUserMeta(Map<String, String> usermeta) {
        this.obj.setUsermeta(usermeta);
    }

    public static String generateUID() {
        return String.valueOf(UUID.randomUUID());
    }

    public String toJSON() {
        RiakObject o = null;
        if (this.obj != null) {
            o = this.obj;
        }
        String jsonValue = new Gson().toJson((Object)this);
        this.obj = o;
        return jsonValue;
    }

    public boolean save() {
        Logger.debug((String)"RiakModel save %s", (Object[])new Object[]{this.toString()});
        RiakObject o = null;
        if (this.obj != null) {
            o = this.obj;
        }
        this.obj = null;
        String jsonValue = new Gson().toJson((Object)this);
        RiakPath path = this.getPath();
        if (path != null) {
            if (o == null) {
                Logger.debug((String)"Create new object %s, %s", (Object[])new Object[]{path.getBucket(), path.getValue()});
                o = new RiakObject(path.getBucket(), path.getValue());
            }
            o.setValue(jsonValue);
            Logger.debug((String)"Store %d links", (Object[])new Object[]{o.getLinks().size()});
            StoreResponse storeResponse = RiakPlugin.riak.store(o);
            if (storeResponse.isError() || !storeResponse.isSuccess()) {
                Logger.error((String)"Error during save: %s", (Object[])new Object[]{storeResponse.getBodyAsString()});
                return false;
            }
            this.obj = o;
            return true;
        }
        return false;
    }

    public RiakPath getPath() {
        Class<?> clazz = this.getClass();
        RiakKey key = RiakPlugin.bucketMap.get(clazz.getName());
        try {
            Field f = clazz.getField(key.getKey());
            String value = f.get(this).toString();
            RiakPath path = new RiakPath(value, key);
            return path;
        }
        catch (Exception e) {
            Logger.error((String)"Error %s during reflextion of class: %s with path: %s", (Object[])new Object[]{e.getMessage(), clazz.getName(), key.toString()});
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends RiakModel> List<T> findAll(Class clazz) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static <T extends RiakModel> List<T> findAll(String bucket) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static List findOrderByDate(Class clazz, Type returnType, boolean reverse) {
        try {
            MapReduceResponse r = null;
            r = reverse ? RiakPlugin.riak.mapReduceOverBucket(RiakPlugin.getBucketName(clazz)).map((MapReduceFunction)JavascriptFunction.anon((String)RiakMP.orderByCreationDateMapString), false).reduce((MapReduceFunction)JavascriptFunction.anon((String)"function ( v , args ) {v.sort ( function(a,b) {return b['lastModifiedParsed'] - a['lastModifiedParsed'] } );return v}"), false).reduce((MapReduceFunction)JavascriptFunction.anon((String)"function ( v , args ) {for(var i=0;i<v.length;i++)v[i].lastModifiedParsed = null;return v}"), true).submit() : RiakPlugin.riak.mapReduceOverBucket(RiakPlugin.getBucketName(clazz)).map((MapReduceFunction)JavascriptFunction.anon((String)RiakMP.orderByCreationDateMapString), false).reduce((MapReduceFunction)JavascriptFunction.anon((String)"function ( v , args ) {v.sort ( function(a,b) {return a['lastModifiedParsed'] - b['lastModifiedParsed']} );return v}"), false).reduce((MapReduceFunction)JavascriptFunction.anon((String)"function ( v , args ) {for(var i=0;i<v.length;i++)v[i].lastModifiedParsed = null;return v}"), true).submit();
            if (r.isSuccess()) {
                List jsonResult = (List)new Gson().fromJson(r.getBodyAsString(), returnType);
                return jsonResult;
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List findOrderByDate(Class clazz, Type returnType) {
        return RiakModel.findOrderByDate(clazz, returnType, false);
    }

    public static <T extends RiakModel> List<T> fetch(Class clazz, Type returnType, int start, int end) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static Collection<String> findKeys(Class clazz) {
        return RiakModel.findKeys(RiakPlugin.getBucketName(clazz));
    }

    public static Collection<String> findKeys(String bucket) {
        BucketResponse r = RiakPlugin.riak.listBucket(bucket);
        return r.getBucketInfo().getKeys();
    }

    public static <T extends RiakModel> T find(Class clazz, String key) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static <T extends RiakModel> T find(String bucket, String key) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static boolean delete(Class clazz, String key) {
        return RiakModel.delete(RiakPlugin.getBucketName(clazz), key);
    }

    public static boolean delete(String bucket, String key) {
        HttpResponse response = RiakPlugin.riak.delete(bucket, key);
        if (response.getStatusCode() == 204) {
            return true;
        }
        Logger.error((String)"Error during delete of bucket: %s, key: %s with message: %s", (Object[])new Object[]{bucket, key, response.getBodyAsString()});
        return false;
    }

    public boolean delete() {
        RiakPath path = this.getPath();
        if (path != null) {
            Logger.debug((String)"Delete bucket: %s , keyValue %s", (Object[])new Object[]{path.getBucket(), path.getValue()});
            return RiakModel.delete(path.getBucket(), path.getValue());
        }
        return false;
    }

    public static void deleteAll(Class clazz) {
        RiakModel.deleteAll(RiakPlugin.getBucketName(clazz));
    }

    public static void deleteAll(String bucket) {
        Collection<String> keys = RiakModel.findKeys(bucket);
        for (String key : keys) {
            RiakModel.delete(bucket, key);
        }
    }

    public List<RiakModel> getLinksByTag(String tag) {
        ArrayList<RiakModel> result = new ArrayList<RiakModel>();
        List links = this.obj.getLinks();
        Set<String> keys = RiakPlugin.bucketMap.keySet();
        block2: for (RiakLink link : links) {
            if (!link.getTag().equals(tag)) continue;
            String bucket = link.getBucket();
            for (String key : keys) {
                RiakKey riakKey = RiakPlugin.bucketMap.get(key);
                if (!riakKey.getBucket().equals(bucket)) continue;
                try {
                    ApplicationClasses.ApplicationClass clazz = Play.classes.getApplicationClass(key);
                    Method m = clazz.javaClass.getMethod("find", String.class, String.class);
                    RiakModel r = (RiakModel)m.invoke(new Object(), bucket, link.getKey());
                    result.add(r);
                }
                catch (Exception e) {
                    Logger.error((String)"Errror during reflection", (Object[])new Object[0]);
                    e.printStackTrace();
                }
                continue block2;
            }
        }
        return result;
    }

    public List<RiakModel> getLink() {
        ArrayList<RiakModel> result = new ArrayList<RiakModel>();
        List links = this.obj.getLinks();
        Set<String> keys = RiakPlugin.bucketMap.keySet();
        block2: for (RiakLink link : links) {
            String bucket = link.getBucket();
            for (String key : keys) {
                RiakKey riakKey = RiakPlugin.bucketMap.get(key);
                if (!riakKey.getBucket().equals(bucket)) continue;
                try {
                    ApplicationClasses.ApplicationClass clazz = Play.classes.getApplicationClass(key);
                    Method m = clazz.javaClass.getMethod("find", String.class, String.class);
                    RiakModel r = (RiakModel)m.invoke(new Object(), bucket, link.getKey());
                    result.add(r);
                }
                catch (Exception e) {
                    Logger.error((String)"Errror during reflection", (Object[])new Object[0]);
                    e.printStackTrace();
                }
                continue block2;
            }
        }
        return result;
    }

    public List<RiakLink> getRawLink() {
        if (this.obj != null) {
            return this.obj.getLinks();
        }
        return new ArrayList<RiakLink>();
    }

    public List<RiakLink> getRawLinksByTag(String tag) {
        ArrayList<RiakLink> res = new ArrayList<RiakLink>();
        if (this.obj != null) {
            List links = this.obj.getLinks();
            for (RiakLink link : links) {
                if (!link.getTag().equals(tag)) continue;
                res.add(link);
            }
        }
        return res;
    }

    public void addLink(Class clazz, String key, String tag) {
        this.addLink(RiakPlugin.getBucketName(clazz), key, tag);
    }

    public void addLink(String bucket, String key, String tag) {
        this.obj.addLink(new RiakLink(bucket, key, tag));
    }

    public static <T extends RiakModel> List<T> jsonToList(String json, Type listType) {
        throw new UnsupportedOperationException("Please annotate your model with @RiakEntity annotation.");
    }

    public static List orderBy(Class clazz, String field, Boolean reverse, Type listType) {
        Object[] args = new Object[]{field, reverse};
        try {
            MapReduceResponse r = RiakPlugin.riak.mapReduceOverBucket(RiakPlugin.getBucketName(clazz)).map((MapReduceFunction)JavascriptFunction.named((String)"Riak.mapValuesJson"), false).reduce((MapReduceFunction)JavascriptFunction.anon((String)RiakMP.orderByReduceString), (Object)args, true).submit();
            if (r.isSuccess()) {
                return (List)new Gson().fromJson(r.getBodyAsString(), listType);
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

