/*
 * Decompiled with CFR 0.152.
 */
package play.modules.riak;

import com.basho.riak.client.RiakClient;
import com.basho.riak.client.RiakConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.libs.WS;
import play.modules.riak.RiakEnhancer;
import play.modules.riak.RiakEntity;
import play.modules.riak.RiakKey;

public class RiakPlugin
extends PlayPlugin {
    public static String RIAK_URL = "";
    public static String RIAK_BASE = "";
    public static String RIAK_URL_STATS = "stats";
    public static RiakClient riak = null;
    public static String DEFAULT_MODEL_PREFIX = "models.riak.";
    public static String MODEL_PREFIX;
    public static String RIAK_TIMEOUT;
    public static String RIAK_MAX_CONNECTION;
    private RiakEnhancer enhancer = new RiakEnhancer();
    public static Map<String, RiakKey> bucketMap;

    public static String getBucketName(Class clazz) {
        String className = clazz.getName();
        RiakKey key = bucketMap.get(className);
        if (key == null) {
            Logger.error((String)"No bucket define for className %s", (Object[])new Object[]{className});
            return "";
        }
        return key.getBucket();
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.enhancer.enhanceThisClass(applicationClass);
    }

    public boolean init() {
        RIAK_URL = Play.configuration.getProperty("riak.url");
        RIAK_BASE = RIAK_URL.substring(0, RIAK_URL.lastIndexOf("/") + 1);
        RIAK_URL = Play.configuration.getProperty("riak.url");
        if (RIAK_URL.isEmpty()) {
            Logger.error((String)"riak.url is empty", (Object[])new Object[0]);
        }
        MODEL_PREFIX = Play.configuration.getProperty("riak.model.prefix", DEFAULT_MODEL_PREFIX);
        Logger.info((String)"Init riak client (url: %s )", (Object[])new Object[]{RIAK_URL});
        RiakConfig config = new RiakConfig(RIAK_URL);
        int timeout = Integer.parseInt(Play.configuration.getProperty("riak.timeout", RIAK_TIMEOUT));
        int maxConnection = Integer.parseInt(Play.configuration.getProperty("riak.maxConnection", RIAK_MAX_CONNECTION));
        config.setTimeout(Integer.valueOf(timeout));
        config.setMaxConnections(Integer.valueOf(maxConnection));
        riak = new RiakClient(config);
        Logger.debug((String)"Call stats url for check riak avaibility (url %s%s%s )", (Object[])new Object[]{RIAK_URL, "/", RIAK_URL_STATS});
        WS.HttpResponse response = WS.url((String)(RIAK_URL + "/" + RIAK_URL_STATS)).get();
        return response.getStatus() == 200;
    }

    public void onApplicationStart() {
        boolean res = this.init();
        if (!res) {
            Logger.error((String)"Riak %s cluster not responding !", (Object[])new Object[]{RIAK_URL});
        } else {
            bucketMap = new HashMap<String, RiakKey>();
            List classes = Play.classes.getAnnotatedClasses(RiakEntity.class);
            for (ApplicationClasses.ApplicationClass clazz : classes) {
                RiakEntity annotation = clazz.javaClass.getAnnotation(RiakEntity.class);
                String key = annotation.key();
                String entityName = clazz.javaClass.getName();
                if (key.equals("")) {
                    Logger.error((String)"Key for class %s is not defined", (Object[])new Object[]{((Object)((Object)this)).toString()});
                    continue;
                }
                String bucket = annotation.bucket();
                if (bucket.equals("")) {
                    bucket = entityName;
                    bucket = bucket.substring(bucket.lastIndexOf(".") + 1);
                }
                bucketMap.put(entityName, new RiakKey(bucket, key));
            }
        }
    }

    static {
        RIAK_TIMEOUT = "2000";
        RIAK_MAX_CONNECTION = "50";
        bucketMap = new HashMap<String, RiakKey>();
    }
}

