/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.response;

import com.basho.riak.client.response.HttpResponse;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpResponse
implements HttpResponse {
    private String bucket;
    private String key;
    private int status = -1;
    private Map<String, String> headers = null;
    private byte[] body = null;
    private InputStream stream = null;
    private HttpMethod httpMethod = null;

    public DefaultHttpResponse(String bucket, String key, int status, Map<String, String> headers, byte[] body, InputStream stream, HttpMethod httpMethod) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        this.bucket = bucket;
        this.key = key;
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.stream = stream;
        this.httpMethod = httpMethod;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getStatusCode() {
        return this.status;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.headers;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body);
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    @Override
    public boolean isStreamed() {
        return this.stream != null;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public boolean isSuccess() {
        String method = null;
        if (this.httpMethod != null) {
            method = this.httpMethod.getName();
        }
        return this.status >= 200 && this.status < 300 || (this.status == 300 || this.status == 304) && "HEAD".equals(method) || (this.status == 300 || this.status == 304) && "GET".equals(method) || this.status == 300 && "PUT".equals(method) || this.status == 404 && "DELETE".equals(method);
    }

    @Override
    public boolean isError() {
        String method = null;
        if (this.httpMethod != null) {
            method = this.httpMethod.getName();
        }
        return !(this.status >= 100 && this.status < 400 || this.status == 404 && "DELETE".equals(method));
    }

    @Override
    public void close() {
        if (this.httpMethod != null) {
            this.httpMethod.releaseConnection();
        }
    }
}

