/*
 * Decompiled with CFR 0.152.
 */
package play.modules.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.router.Any;
import play.modules.router.Delete;
import play.modules.router.Get;
import play.modules.router.Gets;
import play.modules.router.Head;
import play.modules.router.Post;
import play.modules.router.Posts;
import play.modules.router.Put;
import play.modules.router.ServeStatic;
import play.modules.router.StaticRoutes;
import play.modules.router.WS;
import play.mvc.Router;
import play.utils.Java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterAnnotationsPlugin
extends PlayPlugin {
    public void detectChange() {
        Router.load((String)Play.ctxPath);
        this.computeRoutes();
    }

    public void onRoutesLoaded() {
        this.computeRoutes();
    }

    private boolean routeExist(String methodName, String action, String path) {
        boolean exists = false;
        for (Router.Route route : Router.routes) {
            boolean match = route.method.equals(methodName) && route.path.equals(path) && route.action.equals(action);
            if (!match) continue;
            exists = true;
            break;
        }
        return exists;
    }

    protected void computeRoutes() {
        Annotation annotation;
        List<Class> controllerClasses = this.getControllerClasses();
        List annotatedMethods = Java.findAllAnnotatedMethods(controllerClasses, Gets.class);
        for (Method annotatedMethod : annotatedMethods) {
            Gets annotation2 = annotatedMethod.getAnnotation(Gets.class);
            if (annotation2 == null) continue;
            for (int i = annotation2.value().length - 1; i >= 0; --i) {
                Get get = annotation2.value()[i];
                if (get.priority() != -1 && !this.routeExist("GET", this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName(), get.value())) {
                    Router.addRoute((int)get.priority(), (String)"GET", (String)get.value(), (String)(this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName()), (String)this.getFormat(get.format()), (String)get.accept());
                    continue;
                }
                Router.prependRoute((String)"GET", (String)get.value(), (String)(this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName()), (String)this.getFormat(get.format()), (String)get.accept());
            }
        }
        List gets = Java.findAllAnnotatedMethods(controllerClasses, Get.class);
        for (Method get : gets) {
            Get annotation3 = get.getAnnotation(Get.class);
            if (annotation3 == null) continue;
            if (annotation3.priority() != -1 && !this.routeExist("GET", this.getControllerName(get) + "." + get.getName(), annotation3.value())) {
                Router.addRoute((int)annotation3.priority(), (String)"GET", (String)annotation3.value(), (String)(this.getControllerName(get) + "." + get.getName()), (String)this.getFormat(annotation3.format()), (String)annotation3.accept());
                continue;
            }
            Router.prependRoute((String)"GET", (String)annotation3.value(), (String)(this.getControllerName(get) + "." + get.getName()), (String)this.getFormat(annotation3.format()), (String)annotation3.accept());
        }
        annotatedMethods = Java.findAllAnnotatedMethods(controllerClasses, Posts.class);
        for (Method annotatedMethod : annotatedMethods) {
            Posts annotation4 = annotatedMethod.getAnnotation(Posts.class);
            if (annotation4 == null) continue;
            for (int i = annotation4.value().length - 1; i >= 0; --i) {
                Post post = annotation4.value()[i];
                if (post.priority() != -1 && !this.routeExist("POST", this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName(), post.value())) {
                    Router.addRoute((int)post.priority(), (String)"POST", (String)post.value(), (String)(this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName()), (String)this.getFormat(post.format()), (String)post.accept());
                    continue;
                }
                Router.prependRoute((String)"POST", (String)post.value(), (String)(this.getControllerName(annotatedMethod) + "." + annotatedMethod.getName()), (String)this.getFormat(post.format()), (String)post.accept());
            }
        }
        List posts = Java.findAllAnnotatedMethods(controllerClasses, Post.class);
        for (Method post : posts) {
            Post annotation5 = post.getAnnotation(Post.class);
            if (annotation5 == null) continue;
            if (annotation5.priority() != -1 && !this.routeExist("POST", this.getControllerName(post) + "." + post.getName(), annotation5.value())) {
                Router.addRoute((int)annotation5.priority(), (String)"POST", (String)annotation5.value(), (String)(this.getControllerName(post) + "." + post.getName()), (String)this.getFormat(annotation5.format()), (String)annotation5.accept());
                continue;
            }
            Router.prependRoute((String)"POST", (String)annotation5.value(), (String)(this.getControllerName(post) + "." + post.getName()), (String)this.getFormat(annotation5.format()), (String)annotation5.accept());
        }
        List puts = Java.findAllAnnotatedMethods(controllerClasses, Put.class);
        for (Method put : puts) {
            Put annotation6 = put.getAnnotation(Put.class);
            if (annotation6 == null) continue;
            if (annotation6.priority() != -1 && !this.routeExist("PUT", this.getControllerName(put) + "." + put.getName(), annotation6.value())) {
                Router.addRoute((int)annotation6.priority(), (String)"PUT", (String)annotation6.value(), (String)(this.getControllerName(put) + "." + put.getName()), (String)this.getFormat(annotation6.format()), (String)annotation6.accept());
                continue;
            }
            Router.prependRoute((String)"PUT", (String)annotation6.value(), (String)(this.getControllerName(put) + "." + put.getName()), (String)this.getFormat(annotation6.format()), (String)annotation6.accept());
        }
        List deletes = Java.findAllAnnotatedMethods(controllerClasses, Delete.class);
        for (Method delete : deletes) {
            Delete annotation7 = delete.getAnnotation(Delete.class);
            if (annotation7 == null) continue;
            if (annotation7.priority() != -1 && !this.routeExist("DELETE", this.getControllerName(delete) + "." + delete.getName(), annotation7.value())) {
                Router.addRoute((int)annotation7.priority(), (String)"DELETE", (String)annotation7.value(), (String)(this.getControllerName(delete) + "." + delete.getName()), (String)this.getFormat(annotation7.format()), (String)annotation7.accept());
                continue;
            }
            Router.prependRoute((String)"DELETE", (String)annotation7.value(), (String)(this.getControllerName(delete) + "." + delete.getName()), (String)this.getFormat(annotation7.format()), (String)annotation7.accept());
        }
        List heads = Java.findAllAnnotatedMethods(controllerClasses, Head.class);
        for (Method head : heads) {
            Head annotation8 = head.getAnnotation(Head.class);
            if (annotation8 == null) continue;
            if (annotation8.priority() != -1 && !this.routeExist("HEAD", this.getControllerName(head) + "." + head.getName(), annotation8.value())) {
                Router.addRoute((int)annotation8.priority(), (String)"HEAD", (String)annotation8.value(), (String)(this.getControllerName(head) + "." + head.getName()), (String)this.getFormat(annotation8.format()), (String)annotation8.accept());
                continue;
            }
            Router.prependRoute((String)"HEAD", (String)annotation8.value(), (String)(this.getControllerName(head) + "." + head.getName()), (String)this.getFormat(annotation8.format()), (String)annotation8.accept());
        }
        List webSockets = Java.findAllAnnotatedMethods(controllerClasses, WS.class);
        for (Method ws : webSockets) {
            WS annotation9 = ws.getAnnotation(WS.class);
            if (annotation9 == null) continue;
            if (annotation9.priority() != -1 && !this.routeExist("WS", this.getControllerName(ws) + "." + ws.getName(), annotation9.value())) {
                Router.addRoute((int)annotation9.priority(), (String)"WS", (String)annotation9.value(), (String)(this.getControllerName(ws) + "." + ws.getName()), (String)this.getFormat(annotation9.format()), (String)annotation9.accept());
                continue;
            }
            Router.prependRoute((String)"WS", (String)annotation9.value(), (String)(this.getControllerName(ws) + "." + ws.getName()), (String)this.getFormat(annotation9.format()), (String)annotation9.accept());
        }
        List list = Java.findAllAnnotatedMethods(controllerClasses, Any.class);
        for (Method any : list) {
            annotation = any.getAnnotation(Any.class);
            if (annotation == null) continue;
            if (annotation.priority() != -1 && !this.routeExist("*", this.getControllerName(any) + "." + any.getName(), annotation.value())) {
                Router.addRoute((int)annotation.priority(), (String)"*", (String)annotation.value(), (String)(this.getControllerName(any) + "." + any.getName()), (String)this.getFormat(annotation.format()), (String)annotation.accept());
                continue;
            }
            Router.prependRoute((String)"*", (String)annotation.value(), (String)(this.getControllerName(any) + "." + any.getName()), (String)this.getFormat(annotation.format()), (String)annotation.accept());
        }
        for (Class clazz : controllerClasses) {
            ServeStatic[] serveStatics;
            annotation = clazz.getAnnotation(StaticRoutes.class);
            if (annotation == null || (serveStatics = annotation.value()) == null) continue;
            for (ServeStatic serveStatic : serveStatics) {
                if (serveStatic.priority() != -1) {
                    Router.addRoute((int)serveStatic.priority(), (String)"GET", (String)serveStatic.value(), (String)("staticDir:" + serveStatic.directory()), (String)serveStatic.accept());
                    continue;
                }
                Router.prependRoute((String)"GET", (String)serveStatic.value(), (String)("staticDir:" + serveStatic.directory()), (String)serveStatic.accept());
            }
        }
        for (Class clazz : controllerClasses) {
            annotation = clazz.getAnnotation(ServeStatic.class);
            if (annotation == null) continue;
            if (annotation.priority() != -1) {
                Router.addRoute((int)annotation.priority(), (String)"GET", (String)annotation.value(), (String)("staticDir:" + annotation.directory()), (String)annotation.accept());
                continue;
            }
            Router.prependRoute((String)"GET", (String)annotation.value(), (String)("staticDir:" + annotation.directory()), (String)annotation.accept());
        }
    }

    public List<Class> getControllerClasses() {
        ArrayList<Class> returnValues = new ArrayList<Class>();
        List classes = Play.classes.all();
        for (ApplicationClasses.ApplicationClass clazz : classes) {
            if (!clazz.name.startsWith("controllers.") || clazz.javaClass == null || clazz.javaClass.isInterface() || clazz.javaClass.isAnnotation()) continue;
            returnValues.add(clazz.javaClass);
        }
        return returnValues;
    }

    private String getFormat(String format) {
        if (format == null || format.length() < 1) {
            return null;
        }
        return "(format:'" + format + "')";
    }

    private String getControllerName(Method method) {
        return method.getDeclaringClass().getName().substring(12, method.getDeclaringClass().getName().length());
    }
}

