/*
 * Decompiled with CFR 0.152.
 */
package play.modules.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.router.Any;
import play.modules.router.Delete;
import play.modules.router.Get;
import play.modules.router.Head;
import play.modules.router.Post;
import play.modules.router.Put;
import play.modules.router.ServeStatic;
import play.modules.router.StaticRoutes;
import play.modules.router.WS;
import play.mvc.Router;
import play.utils.Java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterAnnotationsPlugin
extends PlayPlugin {
    public void detectChange() {
        this.computeRoutes();
    }

    public void onConfigurationRead() {
        this.computeRoutes();
    }

    public void onRoutesLoaded() {
        this.computeRoutes();
    }

    public void onApplicationStart() {
        this.computeRoutes();
    }

    protected void computeRoutes() {
        Annotation annotation;
        List<Class> controllerClasses = this.getControllerClasses();
        List gets = Java.findAllAnnotatedMethods(controllerClasses, Get.class);
        for (Method get : gets) {
            Get annotation2 = get.getAnnotation(Get.class);
            if (annotation2 == null) continue;
            if (annotation2.priority() != -1) {
                Router.addRoute((int)annotation2.priority(), (String)"GET", (String)annotation2.value(), (String)(get.getDeclaringClass().getSimpleName() + "." + get.getName()), (String)this.getFormat(annotation2.format()), (String)annotation2.accept());
                continue;
            }
            Router.prependRoute((String)"GET", (String)annotation2.value(), (String)(get.getDeclaringClass().getSimpleName() + "." + get.getName()), (String)this.getFormat(annotation2.format()), (String)annotation2.accept());
        }
        List posts = Java.findAllAnnotatedMethods(controllerClasses, Post.class);
        for (Method post : posts) {
            Post annotation3 = post.getAnnotation(Post.class);
            if (annotation3 == null) continue;
            if (annotation3.priority() != -1) {
                Router.addRoute((int)annotation3.priority(), (String)"POST", (String)annotation3.value(), (String)(post.getDeclaringClass().getSimpleName() + "." + post.getName()), (String)this.getFormat(annotation3.format()), (String)annotation3.accept());
                continue;
            }
            Router.prependRoute((String)"POST", (String)annotation3.value(), (String)(post.getDeclaringClass().getSimpleName() + "." + post.getName()), (String)this.getFormat(annotation3.format()), (String)annotation3.accept());
        }
        List puts = Java.findAllAnnotatedMethods(controllerClasses, Put.class);
        for (Method put : puts) {
            Put annotation4 = put.getAnnotation(Put.class);
            if (annotation4 == null) continue;
            if (annotation4.priority() != -1) {
                Router.addRoute((int)annotation4.priority(), (String)"PUT", (String)annotation4.value(), (String)(put.getDeclaringClass().getSimpleName() + "." + put.getName()), (String)this.getFormat(annotation4.format()), (String)annotation4.accept());
                continue;
            }
            Router.prependRoute((String)"PUT", (String)annotation4.value(), (String)(put.getDeclaringClass().getSimpleName() + "." + put.getName()), (String)this.getFormat(annotation4.format()), (String)annotation4.accept());
        }
        List deletes = Java.findAllAnnotatedMethods(controllerClasses, Delete.class);
        for (Method delete : deletes) {
            Delete annotation5 = delete.getAnnotation(Delete.class);
            if (annotation5 == null) continue;
            if (annotation5.priority() != -1) {
                Router.addRoute((int)annotation5.priority(), (String)"DELETE", (String)annotation5.value(), (String)(delete.getDeclaringClass().getSimpleName() + "." + delete.getName()), (String)this.getFormat(annotation5.format()), (String)annotation5.accept());
                continue;
            }
            Router.prependRoute((String)"DELETE", (String)annotation5.value(), (String)(delete.getDeclaringClass().getSimpleName() + "." + delete.getName()), (String)this.getFormat(annotation5.format()), (String)annotation5.accept());
        }
        List heads = Java.findAllAnnotatedMethods(controllerClasses, Head.class);
        for (Method head : heads) {
            Head annotation6 = head.getAnnotation(Head.class);
            if (annotation6 == null) continue;
            if (annotation6.priority() != -1) {
                Router.addRoute((int)annotation6.priority(), (String)"HEAD", (String)annotation6.value(), (String)(head.getDeclaringClass().getSimpleName() + "." + head.getName()), (String)this.getFormat(annotation6.format()), (String)annotation6.accept());
                continue;
            }
            Router.prependRoute((String)"HEAD", (String)annotation6.value(), (String)(head.getDeclaringClass().getSimpleName() + "." + head.getName()), (String)this.getFormat(annotation6.format()), (String)annotation6.accept());
        }
        List webSockets = Java.findAllAnnotatedMethods(controllerClasses, WS.class);
        for (Method ws : webSockets) {
            WS annotation7 = ws.getAnnotation(WS.class);
            if (annotation7 == null) continue;
            if (annotation7.priority() != -1) {
                Router.addRoute((int)annotation7.priority(), (String)"WS", (String)annotation7.value(), (String)(ws.getDeclaringClass().getSimpleName() + "." + ws.getName()), (String)this.getFormat(annotation7.format()), (String)annotation7.accept());
                continue;
            }
            Router.prependRoute((String)"WS", (String)annotation7.value(), (String)(ws.getDeclaringClass().getSimpleName() + "." + ws.getName()), (String)this.getFormat(annotation7.format()), (String)annotation7.accept());
        }
        List list = Java.findAllAnnotatedMethods(controllerClasses, Any.class);
        for (Method any : list) {
            annotation = any.getAnnotation(Any.class);
            if (annotation == null) continue;
            if (annotation.priority() != -1) {
                Router.addRoute((int)annotation.priority(), (String)"*", (String)annotation.value(), (String)(any.getDeclaringClass().getSimpleName() + "." + any.getName()), (String)this.getFormat(annotation.format()), (String)annotation.accept());
                continue;
            }
            Router.prependRoute((String)"*", (String)annotation.value(), (String)(any.getDeclaringClass().getSimpleName() + "." + any.getName()), (String)this.getFormat(annotation.format()), (String)annotation.accept());
        }
        for (Class clazz : controllerClasses) {
            ServeStatic[] serveStatics;
            annotation = clazz.getAnnotation(StaticRoutes.class);
            if (annotation == null || (serveStatics = annotation.value()) == null) continue;
            for (ServeStatic serveStatic : serveStatics) {
                if (serveStatic.priority() != -1) {
                    Router.addRoute((int)serveStatic.priority(), (String)"GET", (String)serveStatic.value(), (String)("staticDir:" + serveStatic.directory()), (String)serveStatic.accept());
                    continue;
                }
                Router.prependRoute((String)"GET", (String)serveStatic.value(), (String)("staticDir:" + serveStatic.directory()), (String)serveStatic.accept());
            }
        }
        for (Class clazz : controllerClasses) {
            annotation = clazz.getAnnotation(ServeStatic.class);
            if (annotation == null) continue;
            if (annotation.priority() != -1) {
                Router.addRoute((int)annotation.priority(), (String)"GET", (String)annotation.value(), (String)("staticDir:" + annotation.directory()), (String)annotation.accept());
                continue;
            }
            Router.prependRoute((String)"GET", (String)annotation.value(), (String)("staticDir:" + annotation.directory()), (String)annotation.accept());
        }
    }

    public List<Class> getControllerClasses() {
        ArrayList<Class> returnValues = new ArrayList<Class>();
        List classes = Play.classes.all();
        for (ApplicationClasses.ApplicationClass clazz : classes) {
            if (!clazz.name.startsWith("controllers.") || clazz.javaClass == null || clazz.javaClass.isInterface() || clazz.javaClass.isAnnotation()) continue;
            returnValues.add(clazz.javaClass);
        }
        return returnValues;
    }

    private String getFormat(String format) {
        if (format == null || format.length() < 1) {
            return null;
        }
        return "(format:'" + format + "')";
    }
}

