/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.resource.ITemplateResource;
import java.util.UUID;

public abstract class TemplateResourceBase
implements ITemplateResource {
    private RythmEngine engine;
    protected String cache;
    private long timestamp;
    protected long nextCheckPoint;

    public TemplateResourceBase() {
    }

    public TemplateResourceBase(RythmEngine engine) {
        if (null == engine) {
            return;
        }
        this.engine = engine.isSingleton() ? null : engine;
    }

    protected RythmEngine engine() {
        return null == this.engine ? Rythm.engine : this.engine;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            return ((TemplateResourceBase)obj).getKey().equals(this.getKey());
        }
        return false;
    }

    private long checkInterval() {
        if (this.engine().isProdMode()) {
            return -1L;
        }
        Long intv = this.userCheckInterval();
        return null == intv ? this.defCheckInterval() : intv.longValue();
    }

    protected abstract long defCheckInterval();

    protected Long userCheckInterval() {
        return this.engine().configuration.getAsLong(String.format("rythm.%s.interval", this.getClass().getSimpleName()), null);
    }

    protected abstract long lastModified();

    protected abstract String reload();

    public String asTemplateContent() {
        if (null == this.cache) {
            this.cache = this.reload();
            this.timestamp = this.lastModified();
        }
        return this.cache;
    }

    public final boolean refresh() {
        long checkInterval = this.checkInterval();
        if (checkInterval < 0L) {
            return false;
        }
        if (0L == checkInterval) {
            this.checkModified();
            return this.isModified();
        }
        long now = System.currentTimeMillis();
        if (this.nextCheckPoint < now) {
            this.checkModified();
        }
        this.nextCheckPoint = now + checkInterval;
        return this.isModified();
    }

    private void checkModified() {
        long modified = this.lastModified();
        if (this.timestamp < modified) {
            this.cache = null;
        }
    }

    private boolean isModified() {
        return null == this.cache;
    }

    public String getSuggestedClassName() {
        return "C" + UUID.randomUUID().toString().replace('-', '_');
    }

    public String tagName() {
        return null;
    }

    protected static final String path2CN(String path) {
        int colon = path.indexOf(":");
        if (++colon > 0) {
            path = path.substring(colon);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.startsWith("\\")) {
            path = path.substring(1);
        }
        return path.replace('/', '_').replace('\\', '_').replace('.', '_').replace('-', '_');
    }

    public static void main(String[] args) {
        System.out.println(TemplateResourceBase.path2CN("http://abc.1.a/Black/jack/k.html"));
        System.out.println(TemplateResourceBase.path2CN("W:\\tmp\\a.b.a.html"));
    }
}

