/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.TemplateTokenizer;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.spi.IBlockHandler;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class TemplateParser
implements IContext {
    private final CodeBuilder cb;
    private String template;
    private int totalLines;
    int cursor = 0;
    private Stack<IBlockHandler> blocks = new Stack();

    public TemplateParser(CodeBuilder cb) {
        this.template = cb.template();
        this.totalLines = StringUtils.countMatches((CharSequence)this.template, (CharSequence)"\n") + 1;
        this.cb = cb;
    }

    void parse() {
        TemplateTokenizer tt = new TemplateTokenizer(this.template, this);
        for (TextBuilder builder : tt) {
            this.cb.addBuilder(builder);
        }
    }

    public TemplateClass getTemplateClass() {
        return this.cb.getTemplateClass();
    }

    public CodeBuilder getCodeBuilder() {
        return this.cb;
    }

    public IDialect getDialect() {
        return this.cb.engine.getDialectManager().get();
    }

    public void setDialect(String dialect) {
        throw new UnsupportedOperationException();
    }

    public String getRemain() {
        return this.cursor < this.template.length() ? this.template.substring(this.cursor) : "";
    }

    public int cursor() {
        return this.cursor;
    }

    public boolean hasRemain() {
        return this.cursor < this.template.length();
    }

    public char peek() {
        if (!this.hasRemain()) {
            return '\u0000';
        }
        return this.template.charAt(this.cursor);
    }

    public char pop() {
        if (!this.hasRemain()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.template.charAt(this.cursor);
        this.step(1);
        return c;
    }

    public void step(int i) {
        this.cursor += i;
    }

    public void openBlock(IBlockHandler bh) {
        this.blocks.push(bh);
    }

    public IBlockHandler currentBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.peek();
    }

    public String closeBlock() throws ParseException {
        if (this.blocks.isEmpty()) {
            throw new ParseException(this.cb.getTemplateClass(), this.currentLine(), "No open block found", new Object[0]);
        }
        IBlockHandler bh = this.blocks.pop();
        return null == bh ? "" : bh.closeBlock();
    }

    public int currentLine() {
        if (null == this.template) {
            return -1;
        }
        if (this.cursor >= this.template.length()) {
            return this.totalLines;
        }
        return StringUtils.countMatches((CharSequence)this.template.substring(0, this.cursor), (CharSequence)"\n") + 1;
    }

    public RythmEngine getEngine() {
        return this.cb.engine;
    }

    private TemplateParser(String s) {
        this.template = s;
        this.totalLines = this.template.split("(\\r\\n|\\n|\\r)").length + 1;
        this.cb = null;
    }

    public static void main(String[] args) {
        TemplateParser tp = new TemplateParser("\nHello \n\r\nworld!");
        System.out.println(tp.totalLines);
        System.out.println(tp.currentLine());
        tp.step(5);
        System.out.println("5 steps ahead");
        System.out.println(tp.currentLine());
        System.out.println(tp.getRemain());
        tp.step(4);
        System.out.println("4 steps ahead");
        System.out.println(tp.currentLine());
        System.out.println(tp.getRemain());
    }
}

