/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.TemplateParser;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.CaretParserFactoryBase;
import com.greenlaw110.rythm.spi.IBlockHandler;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InvokeTagParser
extends CaretParserFactoryBase {
    private static final Pattern P_HEREDOC_SIMBOL = Pattern.compile("(\\s*<<).*", 32);

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            boolean isTag(String name) {
                return this.ctx().getCodeBuilder().engine.isTag(name, this.ctx().getTemplateClass());
            }

            public TextBuilder go() {
                Regex r = new Regex(String.format(InvokeTagParser.patternStr(), this.dialect().a()));
                if (!r.search(this.remain())) {
                    return null;
                }
                String tagName = r.stringMatched(2);
                if (!this.isTag(tagName)) {
                    return null;
                }
                String s = r.stringMatched();
                this.ctx().step(s.length());
                s = this.remain();
                Matcher m = P_HEREDOC_SIMBOL.matcher(s);
                if (m.matches()) {
                    this.ctx().step(m.group(1).length());
                    return new InvokeTagWithBodyToken(tagName, r.stringMatched(3), this.ctx());
                }
                return new InvokeTagToken(tagName, r.stringMatched(3), this.ctx());
            }
        };
    }

    private static String patternStr() {
        return "^(%s([a-zA-Z][a-zA-Z$_\\.0-9]+)\\s*((?@())))";
    }

    public static void main(String[] args) {
        TemplateParser ctx = new TemplateParser(new CodeBuilder(null, "", null, null, null));
        new InvokeTagParser();
        String ps = String.format(InvokeTagParser.patternStr(), "@");
        Regex r = new Regex(ps);
        String s = "@xyz()";
        if (r.search(s)) {
            System.out.println(r.stringMatched());
            InvokeTagToken t = new InvokeTagToken(r.stringMatched(2), r.stringMatched(3), ctx);
            System.out.println(t.params);
        } else {
            System.out.println("not found");
        }
    }

    private static class InvokeTagWithBodyToken
    extends InvokeTagToken
    implements IBlockHandler {
        InvokeTagWithBodyToken(String tagName, String paramLine, IContext context) {
            super(tagName, paramLine, context);
            context.openBlock(this);
        }

        public void openBlock() {
        }

        protected void outputInvokeStatement() {
            String curClassName = this.ctx.getCodeBuilder().className();
            this.p("\n\t_invokeTag(\"").p(this.tagName).p("\", _pl, new com.greenlaw110.rythm.runtime.ITag.Body(").p(curClassName).p(".this) { //line:").p(this.line);
            this.p("\n\t\t@Override public void setProperty(String name, Object val) {\n\t\t\tsetRenderArg(name, val); //line: ").p(this.line).p("\n\t}");
            this.p("\n\t\t@Override public Object getProperty(String name) {\n\t\t\treturn getRenderArg(name); //line: ").p(this.line).p("\n\t}");
            this.p("\n\t\t@Override public void call() { //line: ").pn(this.line);
        }

        public String closeBlock() {
            return "\n\t\t}\n\t});\n}";
        }
    }

    private static class InvokeTagToken
    extends CodeToken {
        String tagName;
        ParameterDeclarationList params = new ParameterDeclarationList();
        int line;

        InvokeTagToken(String tagName, String paramLine, IContext context) {
            super(null, context);
            this.tagName = tagName;
            this.parse(paramLine);
            this.line = context.currentLine();
        }

        private void parse(String line) {
            if (null == line || "".equals(line.trim())) {
                return;
            }
            line = line.substring(1).substring(0, line.length() - 2);
            Regex r = new Regex("\\G(,\\s*)?((([a-zA-Z_][\\w$_]*)\\s*[=:]\\s*)?('.'|(?@\"\")|[0-9\\.]+[l]?|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))");
            while (r.search(line)) {
                this.params.addParameterDeclaration(r.stringMatched(4), r.stringMatched(5));
            }
        }

        public void output() {
            this.p("\n{\n\tcom.greenlaw110.rythm.runtime.ITag.ParameterList _pl = null; //line: ").pn(this.line);
            if (this.params.pl.size() > 0) {
                this.p("\n\t_pl = new com.greenlaw110.rythm.runtime.ITag.ParameterList(); //line: ").pn(this.line);
                for (int i = 0; i < this.params.pl.size(); ++i) {
                    ParameterDeclaration pd = this.params.pl.get(i);
                    this.p("\n\t_pl.add(\"").p(pd.nameDef == null ? "" : pd.nameDef).p("\",").p(pd.valDef).p("); //").pn(this.line);
                }
            }
            this.outputInvokeStatement();
        }

        protected void outputInvokeStatement() {
            this.p("\n\t_invokeTag(\"").p(this.tagName).p("\", _pl); //line:").p(this.line).p("\n}");
        }
    }

    public static class ParameterDeclarationList {
        public List<ParameterDeclaration> pl = new ArrayList<ParameterDeclaration>();

        void addParameterDeclaration(String nameDef, String valDef) {
            this.pl.add(new ParameterDeclaration(nameDef, valDef));
        }

        public String toString() {
            return this.pl.toString();
        }
    }

    public static class ParameterDeclaration {
        public String nameDef;
        public String valDef;

        ParameterDeclaration(String name, String val) {
            if (null != name) {
                if (name.startsWith("\"") || name.startsWith("'")) {
                    name = name.substring(1);
                }
                if (name.endsWith("\"") || name.endsWith("'")) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            this.nameDef = name;
            this.valDef = val;
        }

        public String toString() {
            return String.format("%s:%s", this.nameDef, this.valDef);
        }
    }
}

