/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.logger;

import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.ILoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKLogger
implements ILogger {
    private static final long serialVersionUID = 1L;
    protected final Logger logger;
    protected final String className;

    public JDKLogger(Class c) {
        this.className = c.getName();
        this.logger = Logger.getLogger(this.className);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void trace(String msg, Object ... arg) {
        this.log(Level.FINEST, msg, arg);
    }

    public void trace(Throwable t, String msg, Object ... arg) {
        this.log(Level.FINEST, t, msg, arg);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg, Object ... arg) {
        this.log(Level.FINE, msg, arg);
    }

    public void debug(Throwable t, String msg, Object ... arg) {
        this.log(Level.FINE, t, msg, arg);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg, Object ... arg) {
        this.log(Level.INFO, msg, arg);
    }

    public void info(Throwable t, String msg, Object ... arg) {
        this.log(Level.INFO, t, msg, arg);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg, Object ... arg) {
        this.log(Level.WARNING, msg, arg);
    }

    public void warn(Throwable t, String format, Object ... arg) {
        this.log(Level.WARNING, t, format, arg);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String format, Object ... arg) {
        this.log(Level.SEVERE, format, arg);
    }

    public void error(Throwable t, String msg, Object ... arg) {
        this.log(Level.SEVERE, t, msg, arg);
    }

    protected void log(Level l, Throwable t, String m, Object ... a) {
        if (this.logger.isLoggable(l)) {
            try {
                m = String.format(m, a);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logger.logp(l, this.className, null, m, t);
        }
    }

    protected void log(Level l, String m, Object ... a) {
        if (this.logger.isLoggable(l)) {
            try {
                m = String.format(m, a);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logger.logp(l, this.className, null, m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ILoggerFactory {
        @Override
        public ILogger getLogger(Class<?> clazz) {
            return new JDKLogger(clazz);
        }
    }
}

