/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.spi;

import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.utils.IJavaExtension;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Token
extends TextBuilder {
    protected String s;
    protected IContext ctx;
    protected int line;
    protected boolean disableCompactMode = false;
    private boolean ok = true;
    static final List<IJavaExtension> extensions;
    private static final Regex R_;
    private static final Pattern P_ELVIS;

    protected boolean compactMode() {
        boolean mode = null == this.ctx ? true : this.ctx.getEngine().compactMode();
        return !this.disableCompactMode && mode;
    }

    protected final void fail() {
        this.ok = false;
    }

    public Token(String s, IContext context) {
        super(null == context ? null : context.getCodeBuilder());
        this.s = s;
        this.ctx = context;
        this.line = null == context ? -1 : context.currentLine() - 1;
    }

    public Token(String s, IContext context, boolean disableCompactMode) {
        this(s, context);
        this.disableCompactMode = disableCompactMode;
    }

    public boolean test(String line) {
        return true;
    }

    public boolean isOk() {
        return this.ok;
    }

    public final TextBuilder build() {
        if (this.ok) {
            this.output();
        } else {
            this.pp(this.s);
        }
        return this;
    }

    protected void output() {
        this.pp(this.s);
    }

    public static final void addExtension(IJavaExtension extension) {
        extensions.add(extension);
    }

    private static String stripOuterBrackets(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        if (R_.search(s)) {
            s = R_.stringMatched();
            s = s.substring(1);
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String[] stripElvis(String s) {
        if (S.isEmpty(s)) {
            return new String[]{"", ""};
        }
        Matcher m = P_ELVIS.matcher(s = Token.stripOuterBrackets(s));
        if (m.matches()) {
            String s0 = m.group(1);
            String s1 = m.group(2);
            return new String[]{s0, s1};
        }
        return new String[]{s, ""};
    }

    private static String processElvis(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        String[] sa = Token.stripElvis(s);
        s = sa[0];
        String elvis = sa[1];
        if (S.isEmpty(elvis)) {
            return s;
        }
        elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
        return String.format("((null == %1$s) ? %2$s : %1$s)", s, elvis);
    }

    protected final void outputExpression() {
        boolean hasJavaExtension;
        boolean matched;
        if (S.isEmpty(this.s)) {
            return;
        }
        if (null != this.ctx && !this.ctx.getCodeBuilder().engine.enableJavaExtensions()) {
            this.p("\np(").p(this.s).p(");");
            return;
        }
        String s0 = this.s;
        boolean outerBracketsStripped = false;
        this.s = Token.stripOuterBrackets(this.s);
        outerBracketsStripped = this.s != s0;
        class Pair {
            IJavaExtension extension;
            String signature;

            Pair(IJavaExtension e, String s) {
                this.extension = e;
                this.signature = s;
            }
        }
        Stack<Pair> allMatched = new Stack<Pair>();
        do {
            matched = false;
            for (IJavaExtension e : extensions) {
                Pattern p = e.pattern1();
                Matcher m = p.matcher(this.s);
                if (!m.matches()) continue;
                matched = true;
                String signature = e instanceof IJavaExtension.VoidParameterExtension ? null : m.group(1);
                m = e.pattern2().matcher(this.s);
                this.s = m.replaceAll("");
                allMatched.push(new Pair(e, signature));
            }
        } while (matched);
        boolean bl = hasJavaExtension = !allMatched.empty();
        if (hasJavaExtension) {
            this.s = Token.processElvis(this.s);
            while (!allMatched.empty()) {
                Pair p = (Pair)allMatched.pop();
                this.s = p.extension.extend(this.s, p.signature);
            }
        } else {
            boolean matched2;
            String[] sa = Token.stripElvis(this.s);
            this.s = sa[0];
            String elvis = sa[1];
            do {
                matched2 = false;
                for (IJavaExtension e : extensions) {
                    Pattern p = e.pattern1();
                    Matcher m = p.matcher(this.s);
                    if (!m.matches()) continue;
                    matched2 = true;
                    String signature = e instanceof IJavaExtension.VoidParameterExtension ? null : m.group(1);
                    m = e.pattern2().matcher(this.s);
                    this.s = m.replaceAll("");
                    allMatched.push(new Pair(e, signature));
                }
            } while (matched2);
            while (!allMatched.empty()) {
                this.s = Token.processElvis(this.s);
                Pair p = (Pair)allMatched.pop();
                this.s = p.extension.extend(this.s, p.signature);
            }
            if (!S.isEmpty(elvis)) {
                elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
                this.s = String.format("((null == %1$s) ? %2$s : %1$s)", this.s, elvis);
            }
        }
        if (outerBracketsStripped) {
            this.s = String.format("(%s)", this.s);
        }
        if (this.compactMode()) {
            this.s = this.s.replaceAll("[\\s\\r\\n\\t]+", " ");
        }
        this.p("\np(").p(this.s).p(");");
    }

    private void pp(String s) {
        if (this.compactMode()) {
            s = s.replaceAll("[\\s\\r\\n\\t]+", " ");
        }
        s = s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"");
        this.p("p(\"").p(s).p("\"); //line: ").p(this.line).p("\n");
    }

    public static void main(String[] args) {
        String waiveName = "S";
        String methodName = "format";
        String s = "abc?.format()";
        Pattern pattern1 = Pattern.compile(String.format(".*(?<!%s)(\\?\\.%s|\\.%s)\\s*\\(\\s*\\)\\s*$", waiveName, methodName, methodName));
        Matcher m = pattern1.matcher(s);
        if (m.matches()) {
            System.out.println(m.group());
            System.out.println(m.group(1));
        }
    }

    static {
        String[] sa;
        extensions = new ArrayList<IJavaExtension>();
        for (String s : sa = new String[]{"escape", "escapeHtml", "escapeJavaScript", "escapeCsv", "escapeXml", "shrinkSpace"}) {
            Token.addExtension(new IJavaExtension.VoidParameterExtension("S", s));
        }
        R_ = new Regex("^\\s*(?@())\\s*$");
        P_ELVIS = Pattern.compile("(.*)(\\s*\\?\\s*:\\s*.*)");
    }
}

