/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.exception;

import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RythmException
extends RuntimeException {
    public int javaLineNumber = 0;
    public int templatelineNumber = -1;
    public String errorMessage = "";
    public String originalMessage = "";
    private TemplateClass templateClass = null;
    private static final Pattern P = Pattern.compile(".*\\/\\/line:\\s*([0-9]+).*");

    public RythmException(Throwable t, TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        super(message, t);
        this.javaLineNumber = javaLineNumber;
        this.templateClass = tc;
        this.templatelineNumber = templateLineNumber;
        this.originalMessage = message;
        this.resolveTemplateLineNumber();
    }

    public RythmException(TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        this(null, tc, javaLineNumber, templateLineNumber, message);
    }

    public RythmException(TemplateClass tc, int javaLineNumber, String message) {
        this(tc, javaLineNumber, -1, message);
    }

    private void resolveTemplateLineNumber() {
        String errorLine;
        Matcher m;
        String[] lines;
        if (this.javaLineNumber != -1 && this.templatelineNumber == -1 && this.javaLineNumber < (lines = this.getJavaSource().split("\\n")).length && (m = P.matcher(errorLine = lines[this.javaLineNumber - 1])).matches()) {
            this.templatelineNumber = Integer.parseInt(m.group(1));
        }
    }

    public String getJavaSource() {
        return null == this.templateClass.javaSource ? "" : this.templateClass.javaSource;
    }

    public String getTemplateSource() {
        return this.templateClass.templateResource.asTemplateContent();
    }

    public String getTemplateName() {
        return this.templateClass.getKey();
    }

    public String getMessage() {
        return this.errorMessage;
    }
}

