/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.Directive;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgsParser
extends KeywordParserFactory {
    public Keyword keyword() {
        return Keyword.ARGS;
    }

    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                String key;
                String remain = this.remain();
                if (!remain.startsWith(key = String.format("%s%s ", this.a(), ArgsParser.this.keyword()))) {
                    return null;
                }
                this.step(key.length());
                remain = this.remain();
                Regex r = ArgsParser.this.reg(this.dialect());
                int step = 0;
                final ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
                while (r.search(remain)) {
                    step += r.stringMatched().length();
                    String name = r.stringMatched(3);
                    String type = r.stringMatched(2);
                    String defVal = r.stringMatched(5);
                    ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
                }
                this.step(step);
                char c = this.peek();
                while ((' ' == c || ';' == c) && ctx.hasRemain()) {
                    c = this.pop();
                }
                return new Directive("", this.ctx()){

                    public void call() {
                        for (CodeBuilder.RenderArgDeclaration rd : ral) {
                            this.builder().addRenderArgs(rd);
                        }
                    }
                };
            }

            public TextBuilder go1() {
                Matcher m = ArgsParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String s = m.group(1);
                this.step(s.length());
                String declares = s.replaceFirst(String.format("%s%s[\\s]+", this.a(), ArgsParser.this.keyword()), "");
                return new Directive(declares, this.ctx()){
                    Pattern p;
                    {
                        this.p = Pattern.compile("[\\s,]*([a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*([\\s]*=([^\\n\\$]+))?)");
                    }

                    public void call() {
                        Matcher m = this.p.matcher(this.s);
                        while (m.find()) {
                            String declare = m.group();
                            declare = declare.replaceFirst("[\\s,]*", "");
                            String[] sa = declare.split("[\\s]+");
                            this.builder().addRenderArgs(sa[0], sa[1]);
                        }
                    }
                };
            }
        };
    }

    protected String patternStr() {
        return "\\G\\s*,?\\s*(([\\sa-zA-Z_][\\w$_\\.]*(?@\\<\\>)?)\\s+([a-zA-Z_][\\w$_]*))(\\s*=\\s*([0-9]|'[.]'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))?";
    }

    protected String patternStr0() {
        return "(%s%s([\\s,]+[a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*)+(;|\\r?\\n)+).*";
    }

    public static void main(String[] args) {
        String s = "  java.util.List<String> bar, int foo = 2, Map<String,Object> myBag=null;\n\t@bar";
        ArgsParser ap = new ArgsParser();
        Regex r = ap.reg(new Rythm());
        System.out.println(r);
        while (r.search(s)) {
            System.out.println("m: " + r.stringMatched());
            System.out.println("1: " + r.stringMatched(1));
            System.out.println("2: " + r.stringMatched(2));
            System.out.println("3: " + r.stringMatched(3));
            System.out.println("4: " + r.stringMatched(4));
            System.out.println("5: " + r.stringMatched(5));
        }
    }
}

