/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.compiler;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.ITemplateClassEnhancer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;

public class TemplateClassCache {
    private static final ILogger logger = Logger.get(TemplateClassCache.class);
    private RythmEngine engine = null;

    public TemplateClassCache(RythmEngine engine) {
        this.engine = engine;
    }

    public void deleteCache(TemplateClass tc) {
        try {
            File f = this.getCacheFile(tc);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadTemplateClass(TemplateClass tc) {
        if (!this.engine.cacheEnabled()) {
            return;
        }
        try {
            File f = this.getCacheFile(tc);
            if (!f.exists() || !f.canRead()) {
                return;
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            int offset = 0;
            int read = -1;
            StringBuilder hash = new StringBuilder();
            while ((read = ((InputStream)is).read()) != 0) {
                if (read == -1) {
                    logger.error("Failed to read cache file for template class: %s", tc);
                    return;
                }
                hash.append((char)read);
                ++offset;
            }
            String curHash = this.hash(tc);
            if (!curHash.equals(hash.toString())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Bytecode too old (%s != %s)", hash, curHash);
                }
                return;
            }
            read = -1;
            StringBuilder source = new StringBuilder();
            while ((read = ((InputStream)is).read()) != 0) {
                source.append((char)read);
                ++offset;
            }
            if (source.length() != 0) {
                tc.javaSource = source.toString();
            }
            byte[] byteCode = new byte[(int)f.length() - (offset + 2)];
            ((InputStream)is).read(byteCode);
            tc.compiled(byteCode, true);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheTemplateClassSource(TemplateClass tc) {
        if (!this.engine.cacheEnabled()) {
            return;
        }
        try {
            File f = this.getCacheSourceFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(tc.javaSource.getBytes("utf-8"));
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheTemplateClass(TemplateClass tc) {
        if (!this.engine.cacheEnabled()) {
            return;
        }
        String hash = this.hash(tc);
        try {
            File f = this.getCacheFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(hash.getBytes("utf-8"));
            ((OutputStream)os).write(0);
            if (null != tc.javaSource) {
                ((OutputStream)os).write(tc.javaSource.getBytes("utf-8"));
            }
            ((OutputStream)os).write(0);
            ((OutputStream)os).write(tc.enhancedByteCode);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String hash(TemplateClass tc) {
        try {
            StringBuffer enhancers = new StringBuffer();
            for (ITemplateClassEnhancer plugin : this.engine.templateClassEnhancers) {
                enhancers.append(plugin.getClass().getName());
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update((RythmEngine.versionSignature() + enhancers.toString() + tc.getTemplateSource(true)).getBytes("utf-8"));
            byte[] digest = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int value = digest[i];
                if (value < 0) {
                    value += 256;
                }
                builder.append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String cacheFileName(TemplateClass tc, String suffix) {
        return tc.name0() + suffix;
    }

    File getCacheFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".rythm");
        return new File(this.engine.tmpDir, id);
    }

    File getCacheSourceFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".java");
        return new File(this.engine.tmpDir, id);
    }
}

