/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import com.greenlaw110.rythm.utils.IO;
import java.net.URL;

public class ClasspathTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private URL url;
    private String key;

    public ClasspathTemplateResource(String path) {
        this(path, null);
    }

    public ClasspathTemplateResource(String path, RythmEngine engine) {
        super(engine);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = Rythm.class.getClassLoader();
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.url = cl.getResource(path);
        this.key = path;
    }

    public String getKey() {
        return this.key;
    }

    public String reload() {
        return IO.readContentAsString(this.url);
    }

    protected long lastModified() {
        return 0L;
    }

    public boolean isValid() {
        return null != this.url;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClasspathTemplateResource) {
            ClasspathTemplateResource that = (ClasspathTemplateResource)obj;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    protected long defCheckInterval() {
        return -1L;
    }

    protected Long userCheckInterval() {
        return this.engine().configuration.getAsLong("rythm.resource.classpath.interval", null);
    }

    public String getSuggestedClassName() {
        return ClasspathTemplateResource.path2CN(this.url.getPath());
    }
}

