/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SectionParser
extends KeywordParserFactory {
    public Keyword keyword() {
        return Keyword.SECTION;
    }

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                Matcher m = SectionParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String s = m.group(1);
                this.step(s.length());
                String section = m.group(2);
                return new SectionToken(section, this.ctx());
            }
        };
    }

    protected String patternStr() {
        return "(%s%s[\\s]+([a-zA-Z][a-zA-Z0-9_]+)[\\s\\r\\n\\{]*).*";
    }

    public static void main(String[] args) {
        String s = String.format(new SectionParser().patternStr(), "@", Keyword.SECTION);
        Pattern p = Pattern.compile(s);
        Matcher m = p.matcher("@section abc_xyz {Hello world}@");
        if (m.find()) {
            System.out.println(m.group(1));
            System.out.println(m.group(2));
        }
    }

    public class SectionToken
    extends BlockCodeToken {
        private String section;

        public SectionToken(String section, IContext context) {
            super(null, context);
            this.section = section;
        }

        public void output() {
            this.p("\n_startSection(\"").p(this.section).p("\");\n");
        }

        public String closeBlock() {
            return "\n_endSection();";
        }
    }
}

