/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.exception.CompileException;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.play.RythmTemplate;
import com.greenlaw110.rythm.play.TemplateParseException;
import com.greenlaw110.rythm.play.UseRythmTemplateEngine;
import com.greenlaw110.rythm.play.UseSystemTemplateEngine;
import com.greenlaw110.rythm.play.VirtualFileTemplateResourceLoader;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.runtime.ITag;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.exceptions.TemplateCompilationException;
import play.exceptions.UnexpectedException;
import play.mvc.Controller;
import play.templates.Template;
import play.vfs.VirtualFile;

public class RythmTemplateLoader {
    private static VirtualFileTemplateResourceLoader resourceLoader = VirtualFileTemplateResourceLoader.instance;
    static ConcurrentMap<String, RythmTemplate> cache = new ConcurrentHashMap<String, RythmTemplate>();
    private static Set<String> whiteList = new HashSet<String>();
    private static Set<String> blackList = new HashSet<String>();
    private static Object lock_ = new Object();

    static Method getActionMethod(String path) {
        Method[] methods;
        String templateRoot = RythmPlugin.templateRoot;
        int pos = path.indexOf(templateRoot);
        if (-1 != pos) {
            path = path.substring(pos + templateRoot.length());
        }
        while (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        pos = path.lastIndexOf(46);
        if (-1 != pos) {
            path = path.substring(0, pos);
        }
        if (-1 == (pos = (path = path.replace('/', '.')).lastIndexOf(46))) {
            return null;
        }
        String cName = "controllers." + path.substring(0, pos);
        String mName = path.substring(pos + 1);
        ApplicationClasses.ApplicationClass ac = Play.classes.getApplicationClass(cName);
        if (null == ac) {
            return null;
        }
        Class c = ac.javaClass;
        for (Method m : methods = c.getMethods()) {
            int flag = m.getModifiers();
            if (Modifier.isAbstract(flag) || !Modifier.isStatic(flag) || !Void.TYPE.equals(m.getReturnType()) || !mName.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        return null;
    }

    static boolean whiteListed(String path) {
        if (RythmPlugin.defaultEngine == RythmPlugin.EngineType.rythm || path.contains("rythm")) {
            return true;
        }
        if (Play.mode == Play.Mode.DEV) {
            Method m = RythmTemplateLoader.getActionMethod(path);
            if (null != m) {
                if (m.getAnnotation(UseSystemTemplateEngine.class) != null) {
                    return false;
                }
                if (m.getAnnotation(UseRythmTemplateEngine.class) != null) {
                    return true;
                }
                Class<?> c = m.getDeclaringClass();
                if (c.getAnnotation(UseSystemTemplateEngine.class) != null) {
                    return false;
                }
                if (c.getAnnotation(UseRythmTemplateEngine.class) != null) {
                    return true;
                }
            }
            return false;
        }
        String templateRoot = RythmPlugin.templateRoot;
        int pos = path.indexOf(templateRoot);
        if (-1 != pos) {
            path = path.substring(pos + templateRoot.length());
        }
        while (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        pos = path.lastIndexOf(46);
        if (-1 != pos) {
            path = path.substring(0, pos);
        }
        return whiteList.contains(path);
    }

    static boolean blackListed(String path) {
        if (Play.mode == Play.Mode.DEV) {
            Method m = RythmTemplateLoader.getActionMethod(path);
            if (null != m) {
                if (m.getAnnotation(UseSystemTemplateEngine.class) != null) {
                    return true;
                }
                if (m.getAnnotation(UseRythmTemplateEngine.class) != null) {
                    return false;
                }
                Class<?> c = m.getDeclaringClass();
                if (c.getAnnotation(UseSystemTemplateEngine.class) != null) {
                    return true;
                }
                if (c.getAnnotation(UseRythmTemplateEngine.class) != null) {
                    return false;
                }
            }
            return false;
        }
        return blackList.contains(path);
    }

    private static void scanTagFolder(VirtualFile root) {
        class FileTraversal {
            FileTraversal() {
            }

            public final void traverse(VirtualFile f) {
                if (f.isDirectory()) {
                    if (".svn".equals(f.getName())) {
                        return;
                    }
                    List children = f.list();
                    for (VirtualFile child : children) {
                        this.traverse(child);
                    }
                    return;
                }
                this.onFile(f);
            }

            public void onFile(VirtualFile f) {
                try {
                    ITag tag;
                    VirtualFileTemplateResourceLoader.VirtualFileTemplateResource resource = new VirtualFileTemplateResourceLoader.VirtualFileTemplateResource(f);
                    TemplateClass templateClass = RythmPlugin.engine.classes.getByTemplate(resource.getKey());
                    if (null == templateClass) {
                        templateClass = new TemplateClass((ITemplateResource)resource, RythmPlugin.engine);
                    }
                    if (null != (tag = (ITag)templateClass.asTemplate())) {
                        RythmPlugin.engine.registerTag(tag);
                    }
                }
                catch (RythmException e) {
                    RythmTemplate.TemplateInfo t = RythmTemplate.handleRythmException(e);
                    if (e instanceof ParseException) {
                        throw new TemplateParseException(t, (ParseException)((Object)e));
                    }
                    if (e instanceof CompileException) {
                        throw new TemplateCompilationException((Template)t, Integer.valueOf(t.lineNo), e.getMessage());
                    }
                    throw new UnexpectedException("Don't know why I am here");
                }
                catch (Exception e) {
                    Logger.warn((Throwable)e, (String)"error loading tag: %s", (Object[])new Object[]{f.relativePath()});
                }
            }
        }
        new FileTraversal().traverse(root);
    }

    static void scanTagFolder() {
        RythmPlugin.trace("start to scan tags", new Object[0]);
        long ts = System.currentTimeMillis();
        String s = RythmPlugin.tagRoot;
        for (VirtualFile root : Play.roots) {
            VirtualFile tagRoot = root.child(s);
            if (!tagRoot.isDirectory()) continue;
            RythmTemplateLoader.scanTagFolder(tagRoot);
        }
        ts = System.currentTimeMillis() - ts;
        RythmPlugin.trace("%sms to scan tags", ts);
    }

    static void buildBlackWhiteList() {
        if (Play.mode == Play.Mode.DEV) {
            return;
        }
        RythmPlugin.trace("start to build black and white list", new Object[0]);
        long ts = System.currentTimeMillis();
        List controllers = Play.classes.getAssignableClasses(Controller.class);
        boolean alerted = false;
        for (ApplicationClasses.ApplicationClass ac : controllers) {
            Method[] ma;
            Class c = ac.javaClass;
            String sCls = c.getName().replace("controllers.", "").replace('.', '/');
            for (Method m : ma = c.getMethods()) {
                boolean useSystem;
                int flag = m.getModifiers();
                if (!Modifier.isStatic(flag) || Modifier.isAbstract(flag) || !m.getReturnType().equals(Void.TYPE)) continue;
                UseRythmTemplateEngine ar = m.getAnnotation(UseRythmTemplateEngine.class);
                boolean useRythm = ar != null;
                UseSystemTemplateEngine as = m.getAnnotation(UseSystemTemplateEngine.class);
                boolean bl = useSystem = as != null;
                if ((useSystem || useRythm) && !alerted) {
                    RythmPlugin.warn("@UseRythmTemplateEngine annotation is deprecated. To use rythm engine, just create a rythm template file in app/rythm directory. Drop the file from app/rythm directory the render process will pickup the groovy template from app/views directory automatically", new Object[0]);
                    alerted = true;
                }
                if (!useRythm && !useSystem) {
                    useRythm = c.getAnnotation(UseRythmTemplateEngine.class) != null;
                    boolean bl2 = useSystem = c.getAnnotation(UseSystemTemplateEngine.class) != null;
                    if (!useRythm && !useSystem) continue;
                    if (useRythm && useSystem) {
                        Logger.warn((String)"Both UseRythmTemplateEngine and UseSystemTemplateEngine found on class [%s]. You should choose only one. System template engine will be used", (Object[])new Object[]{c.getName()});
                        useRythm = false;
                    }
                }
                if (useRythm && useSystem) {
                    Logger.warn((String)"Both UseRythmTemplateEngine and UseSystemTemplateEngine found on method [%s]. You should choose only one. System template engine will be used", (Object[])new Object[]{m.toString()});
                    useRythm = false;
                }
                String path = sCls + "/" + m.getName();
                if (useRythm) {
                    RythmPlugin.trace("adding %s to white list", path);
                    whiteList.add(path);
                    continue;
                }
                RythmPlugin.trace("adding %s to black list", path);
                blackList.add(path);
            }
        }
        ts = System.currentTimeMillis() - ts;
        RythmPlugin.trace("%sms to build black and white list", ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template loadTemplate(VirtualFile file) {
        String path = file.relativePath();
        if (path.indexOf("conf/routes") != -1) {
            return null;
        }
        if (path.endsWith(".xls") || path.endsWith(".xlsx") || path.endsWith(".pdf")) {
            return null;
        }
        RythmTemplate rt = (RythmTemplate)((Object)cache.get(path));
        if (null != rt) {
            rt.refresh();
            return rt.isValid() ? rt : null;
        }
        Object object = lock_;
        synchronized (object) {
            rt = (RythmTemplate)((Object)cache.get(path));
            if (null != rt) {
                rt.refresh();
                return rt.isValid() ? rt : null;
            }
            ITemplateResource resource = resourceLoader.load(file);
            if (null == resource || !resource.isValid()) {
                return null;
            }
            RythmTemplate tc = new RythmTemplate(resource);
            tc.refresh(true);
            if (tc.isValid()) {
                cache.put(file.relativePath(), tc);
            } else {
                tc = null;
            }
            return tc;
        }
    }

    static void clear() {
        cache.clear();
        blackList.clear();
        whiteList.clear();
    }

    public static void main(String[] args) {
        String path = "route";
        int dot = path.lastIndexOf(46);
        path = -1 == dot ? path + ".rythm" : path.substring(0, dot) + ".rythm" + path.substring(dot);
        System.out.println(path);
    }
}

