/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.parsers;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.dialect.DialectBase;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.play.parsers.PlayRythmKeyword;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IKeyword;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import play.Play;
import play.exceptions.NoRouteFoundException;
import play.mvc.Router;
import play.vfs.VirtualFile;

public class UrlReverseLookupParser
extends KeywordParserFactory {
    protected boolean isAbsolute = false;
    private static final ConcurrentMap<String, String> staticRouteMap = new ConcurrentHashMap<String, String>();

    public IKeyword keyword() {
        return PlayRythmKeyword._U;
    }

    protected String patternStr() {
        return "^%s%s\\s*((?@()))";
    }

    protected String innerPattern() {
        return "[a-zA-Z_][\\w$_\\.]*(?@())?";
    }

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                String staticUrl;
                Regex r = UrlReverseLookupParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @_u statement, correct usage: @_u(Controller.action), or @_u(/public/<your public assets>)", new Object[0]);
                }
                String s = r.stringMatched();
                this.step(s.length());
                s = r.stringMatched(1);
                s = s.substring(1);
                s = s.substring(0, s.length() - 1);
                if (s.startsWith("\"") || s.startsWith("'")) {
                    s = s.substring(1);
                }
                if (s.endsWith("\"") || s.endsWith("'")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (null == (staticUrl = (String)staticRouteMap.get(s))) {
                    try {
                        staticUrl = Router.reverseWithCheck((String)s, (VirtualFile)Play.getVirtualFile((String)s), (boolean)UrlReverseLookupParser.this.isAbsolute);
                    }
                    catch (NoRouteFoundException e) {
                        // empty catch block
                    }
                }
                if (null != staticUrl) {
                    staticRouteMap.put(s, staticUrl);
                    return new CodeToken(staticUrl, this.ctx()){

                        public void output() {
                            this.p("p(\"").p((Object)this.s).p((Object)"\"); // line: ").p(this.ctx().currentLine()).p((Object)"\n");
                        }
                    };
                }
                r = new Regex("([a-zA-Z_][\\w$_\\.]*)((?@())?)");
                if (r.search(s)) {
                    final String action = r.stringMatched(1);
                    s = r.substring(2);
                    if (null == s) {
                        s = "";
                    }
                    if (s.startsWith("(")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith(")")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    final String param = s;
                    return new CodeToken("", this.ctx()){

                        public void output() {
                            this.p("p(new com.greenlaw110.rythm.play.utils.ActionBridge(").p(UrlReverseLookupParser.this.isAbsolute).p((Object)").invokeMethod(\"").p((Object)action).p((Object)"\", new Object[] {").p((Object)param).p((Object)"})); // line: ").p(this.ctx().currentLine()).p((Object)"\n");
                        }
                    };
                }
                throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing url reverse lookup", new Object[0]);
            }
        };
    }

    public static void main(String[] args) {
        String s;
        UrlReverseLookupParser p = new UrlReverseLookupParser();
        Regex r = p.reg((DialectBase)new Rythm());
        if (r.search(s = "@_u(Application.index()) abc")) {
            System.out.println(r.stringMatched());
            s = r.stringMatched(1);
            System.out.println(">>" + s);
            s = s.substring(1).substring(0, s.length() - 2);
            System.out.println("<<" + s);
            if (s.startsWith("\"") || s.startsWith("'")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"") || s.endsWith("'")) {
                s = s.substring(0, s.length() - 1);
            }
            System.out.println(s);
        }
    }
}

