/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.IDirective;
import com.greenlaw110.rythm.internal.TemplateParser;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.parser.NotRythmTemplateException;
import com.greenlaw110.rythm.internal.parser.build_in.InvokeTagParser;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.template.TagBase;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.IImplicitRenderArgProvider;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CodeBuilder
extends TextBuilder {
    public RythmEngine engine;
    private boolean isNotRythmTemplate = false;
    private String tmpl;
    private String cName;
    private String pName;
    private String tagName;
    private String initCode = null;
    private String extended;
    private TemplateClass extendedTemplateClass;
    private InvokeTagParser.ParameterDeclarationList extendArgs = null;
    Set<String> imports = new HashSet<String>();
    private int extendDeclareLineNo = -1;
    Map<String, RenderArgDeclaration> renderArgs = new LinkedHashMap<String, RenderArgDeclaration>();
    private List<TextBuilder> builders = new ArrayList<TextBuilder>();
    private TemplateParser parser;
    private TemplateClass templateClass;
    private static Set<String> globalImports = new HashSet<String>();
    private Map<String, InlineTag> inlineTags = new HashMap<String, InlineTag>();
    private Stack<List<TextBuilder>> inlineTagBodies = new Stack();

    public boolean isRythmTemplate() {
        return !this.isNotRythmTemplate;
    }

    private boolean isTag() {
        return null != this.tagName;
    }

    public void setInitCode(String code) {
        if (null != this.initCode) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "@init section already declared.", new Object[0]);
        }
        this.initCode = code;
    }

    private String extended() {
        String defClass = this.isTag() ? TagBase.class.getName() : TemplateBase.class.getName();
        return null == this.extended ? defClass : this.extended;
    }

    private String extendedResourceMark() {
        TemplateClass tc = this.extendedTemplateClass;
        return null == tc ? "" : String.format("//<extended_resource_key>%s</extended_resource_key>", tc.templateResource.getKey());
    }

    public TemplateClass getExtendedTemplateClass() {
        return this.extendedTemplateClass;
    }

    public TemplateClass getTemplateClass() {
        return this.templateClass;
    }

    public CodeBuilder(String template, String className, String tagName, TemplateClass templateClass, RythmEngine engine) {
        this.tmpl = template;
        this.tagName = null == tagName ? className : tagName;
        this.cName = className = className.replace('/', '.');
        int i = className.lastIndexOf(46);
        if (-1 < i) {
            this.cName = className.substring(i + 1);
            this.pName = className.substring(0, i);
        }
        this.engine = null == engine ? Rythm.engine : engine;
        this.parser = new TemplateParser(this);
        this.templateClass = templateClass;
    }

    public String className() {
        return this.cName;
    }

    public static void registerImports(String imports) {
        globalImports.addAll(Arrays.asList(imports.split(",")));
    }

    public void addImport(String imprt) {
        if (!globalImports.contains(imprt)) {
            this.imports.add(imprt);
        }
    }

    public void defTag(String tagName, String signature) {
        if (this.inlineTags.containsKey(tagName)) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "inline tag already defined: %s", tagName);
        }
        InlineTag tag = new InlineTag(tagName, signature);
        this.inlineTags.put(tagName, tag);
        this.inlineTagBodies.push(this.builders);
        this.builders = tag.builders;
    }

    public void endTag() {
        if (this.inlineTagBodies.empty()) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "Unexpected tag definition close", new Object[0]);
        }
        this.builders = this.inlineTagBodies.pop();
    }

    public void setExtended(String extended, InvokeTagParser.ParameterDeclarationList args, int lineNo) {
        ITemplateResource resource;
        ITemplateResource resource2;
        int pos;
        String me;
        if (null != this.extended) {
            throw new IllegalStateException("extended already set for this page");
        }
        TemplateClass tc = null;
        String origin = extended;
        if (!extended.startsWith("/") && null == (tc = this.engine.classes.getByTemplate(extended = (me = this.templateClass.getKey()).substring(0, pos = me.lastIndexOf("/")) + "/" + extended)) && (resource2 = this.engine.resourceManager.getFileResource(extended)).isValid()) {
            tc = new TemplateClass(resource2, this.engine);
        }
        if (null == tc && !extended.startsWith("/")) {
            if (!extended.endsWith("__R_T_C__")) {
                extended = extended + "__R_T_C__";
            }
            tc = this.engine.classes.getByClassName(extended);
        }
        if (null == tc && null == (tc = this.engine.classes.getByTemplate(origin)) && (resource = this.engine.resourceManager.getFileResource(origin)).isValid()) {
            tc = new TemplateClass(resource, this.engine);
        }
        if (null == tc) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "Cannot find extend template: %s", origin);
        }
        this.extended = tc.name();
        this.extendedTemplateClass = tc;
        this.extendArgs = args;
    }

    public void addRenderArgs(RenderArgDeclaration declaration) {
        this.renderArgs.put(declaration.name, declaration);
    }

    public void addRenderArgs(String type, String name) {
        this.renderArgs.put(name, new RenderArgDeclaration(name, type));
    }

    public void addBuilder(TextBuilder builder) {
        this.builders.add(builder);
    }

    String template() {
        return this.tmpl;
    }

    public TextBuilder build() {
        try {
            this.parser.parse();
            this.invokeDirectives();
            this.addDefaultRenderArgs();
            this.pPackage();
            this.pImports();
            this.pClassOpen();
            this.pTagImpl();
            this.pInitCode();
            this.pExtendInitArgCode();
            this.pRenderArgs();
            this.pInlineTags();
            this.pBuild();
            this.pClassClose();
            return this;
        }
        catch (NotRythmTemplateException e) {
            this.isNotRythmTemplate = true;
            return this;
        }
    }

    private void invokeDirectives() {
        for (TextBuilder b : this.builders) {
            if (!(b instanceof IDirective)) continue;
            ((IDirective)((Object)b)).call();
        }
    }

    private void addDefaultRenderArgs() {
        IImplicitRenderArgProvider p = this.engine.implicitRenderArgProvider;
        if (null == p) {
            return;
        }
        Map<String, ?> defArgs = p.getRenderArgDescriptions();
        for (String name : defArgs.keySet()) {
            Object o = defArgs.get(name);
            String type = o instanceof Class ? ((Class)o).getName() : o.toString();
            this.addRenderArgs(type, name);
        }
    }

    private void pPackage() {
        if (!S.isEmpty(this.pName)) {
            this.p("\npackage ").p(this.pName).p(";");
        }
    }

    private void pImports() {
        for (String s : this.imports) {
            this.p("\nimport ").p(s).p(';');
        }
        for (String s : globalImports) {
            this.p("\nimport ").p(s).p(';');
        }
        IImplicitRenderArgProvider p = this.engine.implicitRenderArgProvider;
        if (null != p) {
            for (String s : p.getImplicitImportStatements()) {
                this.p("\nimport ").p(s).p(';');
            }
        }
        this.p("\nimport java.util.*;");
        this.p("\nimport java.io.*;");
    }

    private void pClassOpen() {
        this.p("\npublic class ").p(this.cName).p(" extends ").p(this.extended()).p(" {").p(this.extendedResourceMark());
    }

    private void pClassClose() {
        this.p("\n}");
    }

    private void pRenderArgs() {
        RenderArgDeclaration arg;
        RenderArgDeclaration arg2;
        for (String argName : this.renderArgs.keySet()) {
            arg2 = this.renderArgs.get(argName);
            this.p("\n\t\tprotected ").p(arg2.type).p(" ").p(argName);
            if (null != arg2.defVal) {
                this.p("=").p(arg2.defVal).p(";");
                continue;
            }
            this.p(";");
        }
        this.p("\n\t@SuppressWarnings(\"unchecked\") public void setRenderArgs(java.util.Map<String, Object> args) {");
        for (String argName : this.renderArgs.keySet()) {
            arg2 = this.renderArgs.get(argName);
            this.p("\n\tif (null != args && args.containsKey(\"").p(argName).p("\")) this.").p(argName).p("=(").p(arg2.type).p(")args.get(\"").p(argName).p("\");");
        }
        this.p("\n\tsuper.setRenderArgs(args);\n}");
        IImplicitRenderArgProvider p = this.engine.implicitRenderArgProvider;
        int userDefinedArgNumber = this.renderArgs.size() - (null == p ? 0 : p.getRenderArgDescriptions().size());
        if (0 < userDefinedArgNumber) {
            this.p("\n@SuppressWarnings(\"unchecked\") public void setRenderArgs(Object... args) {");
            this.p("\n\tint p = 0, l = args.length;");
            int i = userDefinedArgNumber;
            for (String argName : this.renderArgs.keySet()) {
                RenderArgDeclaration arg3 = this.renderArgs.get(argName);
                this.p("\n\tif (p < l) { Object v = args[p++]; boolean isString = (\"java.lang.String\".equals(\"").p(arg3.type).p("\") || \"String\".equals(\"").p(arg3.type).p("\")); ").p(argName).p(" = (").p(arg3.type).p(")(isString ? (null == v ? \"\" : v.toString()) : v); }");
                if (--i != 0) continue;
                break;
            }
            this.p("\n}");
        }
        this.p("\n@SuppressWarnings(\"unchecked\") @Override public void setRenderArg(String name, Object arg) {");
        for (String argName : this.renderArgs.keySet()) {
            arg = this.renderArgs.get(argName);
            this.p("\n\tif (\"").p(argName).p("\".equals(name)) this.").p(argName).p("=(").p(arg.type).p(")arg;");
        }
        this.p("\n\tsuper.setRenderArg(name, arg);\n}");
        this.p("\n@SuppressWarnings(\"unchecked\") public void setRenderArg(int pos, Object arg) {");
        this.p("\nint p = 0;");
        for (String argName : this.renderArgs.keySet()) {
            arg = this.renderArgs.get(argName);
            this.p("\nif (p++ == pos) { Object v = arg; boolean isString = (\"java.lang.String\".equals(\"").p(arg.type).p("\") || \"String\".equals(\"").p(arg.type).p("\")); ").p(argName).p(" = (").p(arg.type).p(")(isString ? (null == v ? \"\" : v.toString()) : v); }");
        }
        this.p("\n\tif(0 == pos) setRenderArg(\"arg\", arg);");
        this.p("\n}");
    }

    private void pExtendInitArgCode() {
        if (null == this.extendArgs || this.extendArgs.pl.size() < 1) {
            return;
        }
        this.p("\n@Override protected void loadExtendingArgs() {");
        for (int i = 0; i < this.extendArgs.pl.size(); ++i) {
            InvokeTagParser.ParameterDeclaration pd = this.extendArgs.pl.get(i);
            if (S.isEmpty(pd.nameDef)) {
                this.p("\n\t__parent.setRenderArg(").p(i).p(", ").p(pd.valDef).p(");");
            } else {
                this.p("\n\t__parent.setRenderArg(\"").p(pd.nameDef).p("\", ").p(pd.valDef).p(");");
            }
            if (this.extendDeclareLineNo == -1) continue;
            this.p(" //line: ").p(this.extendDeclareLineNo);
        }
        this.p("\n}\n");
    }

    private void pInitCode() {
        if (null == this.initCode) {
            return;
        }
        this.p("\n@Override public void init() {").p(this.initCode).p(";").p("}\n");
    }

    private void pTagImpl() {
        if (!this.isTag()) {
            return;
        }
        this.p("\n@Override public java.lang.String getName() {\n\treturn \"").p(this.tagName).p("\";\n}\n");
    }

    private void pInlineTags() {
        for (InlineTag tag : this.inlineTags.values()) {
            this.p("\nprotected String ").p(tag.tagName).p(tag.signature).p("{\n");
            for (TextBuilder b : tag.builders) {
                b.build();
            }
            this.p("\nreturn \"\";\n}\n");
        }
    }

    private void pBuild() {
        this.p("\n@Override public com.greenlaw110.rythm.utils.TextBuilder build(){");
        this.p("\n\tout().ensureCapacity(").p(this.tmpl.length()).p(");");
        for (TextBuilder b : this.builders) {
            b.build();
        }
        this.p("\nreturn this;\n}");
    }

    private static class InlineTag {
        String tagName;
        String signature;
        List<TextBuilder> builders = new ArrayList<TextBuilder>();

        InlineTag(String name, String sig) {
            this.tagName = name;
            this.signature = sig;
        }
    }

    public static class RenderArgDeclaration {
        String name;
        String type;
        String defVal;

        public RenderArgDeclaration(String name, String type) {
            this(name, type, null);
        }

        public RenderArgDeclaration(String name, String type, String defVal) {
            this.name = name;
            this.type = RenderArgDeclaration.typeTransform(type);
            this.defVal = null == defVal ? RenderArgDeclaration.defVal(type) : defVal;
        }

        private static String typeTransform(String type) {
            if ("boolean".equals(type)) {
                return "Boolean";
            }
            if ("int".equals(type)) {
                return "Integer";
            }
            if ("float".equals(type)) {
                return "Float";
            }
            if ("double".equals(type)) {
                return "Double";
            }
            if ("char".equals(type)) {
                return "Character";
            }
            return type;
        }

        private static String defVal(String type) {
            if (type.equals("boolean")) {
                return "false";
            }
            if (type.equals("int")) {
                return "0";
            }
            if (type.equals("long")) {
                return "0L";
            }
            if (type.equals("char")) {
                return "(char)0";
            }
            if (type.equals("byte")) {
                return "(byte)0";
            }
            if (type.equals("short")) {
                return "(short)0";
            }
            if (type.equals("float")) {
                return "0f";
            }
            if (type.equals("double")) {
                return "0d";
            }
            return "null";
        }
    }
}

