/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.compiler;

import com.greenlaw110.rythm.IHotswapAgent;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.IO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateClassLoader
extends ClassLoader {
    private static final ILogger logger = Logger.get(TemplateClass.class);
    private final ClassStateHashCreator classStateHashCreator = new ClassStateHashCreator();
    public TemplateClassloaderState currentState = new TemplateClassloaderState();
    public ProtectionDomain protectionDomain;
    public RythmEngine engine;
    int pathHash = 0;

    private static ClassLoader getDefParent() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return null == cl ? RythmEngine.class.getClassLoader() : cl;
    }

    public TemplateClassLoader(RythmEngine engine) {
        this(TemplateClassLoader.getDefParent(), engine);
    }

    public TemplateClassLoader(ClassLoader parent, RythmEngine engine) {
        super(parent);
        this.engine = engine;
        for (TemplateClass tc : engine.classes.all()) {
            tc.uncompile();
        }
        this.pathHash = this.computePathHash();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        TemplateClass tc = this.engine.classes.clsNameIdx.get(name);
        if (null == tc && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        Class<?> TemplateClass2 = this.loadTemplateClass(name);
        if (TemplateClass2 != null) {
            if (resolve) {
                this.resolveClass(TemplateClass2);
            }
            return TemplateClass2;
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadTemplateClass(String name) {
        Class<?> maybeAlreadyLoaded = this.findLoadedClass(name);
        if (maybeAlreadyLoaded != null) {
            return maybeAlreadyLoaded;
        }
        long start = System.currentTimeMillis();
        TemplateClass templateClass = this.engine.classes.getByClassName(name);
        if (templateClass != null) {
            if (templateClass.isDefinable()) {
                return templateClass.javaClass;
            }
            Object bc = null;
            if (!templateClass.isClass()) {
                this.definePackage(templateClass.getPackage(), null, null, null, null, null, null, null);
            } else {
                this.loadPackage(name);
            }
            if (bc != null) {
                templateClass.enhancedByteCode = bc;
                templateClass.javaClass = this.defineClass(templateClass.name(), templateClass.enhancedByteCode, 0, templateClass.enhancedByteCode.length, this.protectionDomain);
                this.resolveClass(templateClass.javaClass);
                if (!templateClass.isClass()) {
                    templateClass.javaPackage = templateClass.javaClass.getPackage();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to load class %s from clsNameIdx", System.currentTimeMillis() - start, name);
                }
                return templateClass.javaClass;
            }
            if (templateClass.javaByteCode != null || templateClass.compile() != null) {
                templateClass.enhance();
                templateClass.javaClass = this.defineClass(templateClass.name(), templateClass.enhancedByteCode, 0, templateClass.enhancedByteCode.length, this.protectionDomain);
                this.resolveClass(templateClass.javaClass);
                if (!templateClass.isClass()) {
                    templateClass.javaPackage = templateClass.javaClass.getPackage();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to load class %s", System.currentTimeMillis() - start, name);
                }
                return templateClass.javaClass;
            }
            this.engine.classes.remove(name);
        } else {
            if (name.lastIndexOf("__R_T_C__") == -1) {
                return null;
            }
            int pos = name.lastIndexOf("$");
            if (-1 != pos) {
                String parentCN = name.substring(0, pos);
                TemplateClass parent = this.engine.classes.getByClassName(parentCN);
                if (null == parent) {
                    throw new RuntimeException("Cannot find inner class def: " + name);
                }
                TemplateClass tc = TemplateClass.createInnerClass(name, null, parent);
                this.engine.cache.loadTemplateClass(tc);
                byte[] bc = tc.enhancedByteCode;
                if (null == bc) {
                    while (null != parent && parent.isInner()) {
                        parent = parent.root();
                    }
                    if (null == parent) {
                        throw new RuntimeException("Unexpected: cannot find the root class of inner class: " + name);
                    }
                    parent.reset();
                    parent.refresh(true);
                    parent.compile();
                    tc = this.engine.classes.getByClassName(name);
                    Class<ITemplate> c = tc.javaClass;
                    if (null != c) {
                        return c;
                    }
                    bc = tc.enhancedByteCode;
                    if (null == bc) {
                        throw new RuntimeException("Cannot find bytecode cache for inner class: " + name);
                    }
                }
                tc.javaClass = this.defineClass(tc.name(), bc, 0, bc.length, this.protectionDomain);
                return tc.javaClass;
            }
        }
        return null;
    }

    private String getPackageName(String name) {
        int dot = name.lastIndexOf(46);
        return dot > -1 ? name.substring(0, dot) : "";
    }

    private void loadPackage(String className) {
        int symbol = className.indexOf("$");
        if (symbol > -1) {
            className = className.substring(0, symbol);
        }
        if (this.findLoadedClass(className = (symbol = className.lastIndexOf(".")) > -1 ? className.substring(0, symbol) + ".package-info" : "package-info") == null) {
            this.loadTemplateClass(className);
        }
    }

    protected byte[] getClassDefinition(String name) {
        InputStream is = this.getResourceAsStream(name = name.replace(".", "/") + ".class");
        if (is == null) {
            return null;
        }
        try {
            int count;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                os.write(buffer, 0, count);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void detectChange(TemplateClass tc) {
        if (!this.engine.refreshOnRender() && null != tc.name()) {
            return;
        }
        if (!tc.refresh()) {
            return;
        }
        if (tc.compile() == null) {
            this.engine.classes.remove(tc);
            this.currentState = new TemplateClassloaderState();
        } else if (this.engine.reloadByRestart()) {
            throw new ClassReloadException("Need reload");
        }
    }

    public void detectChanges() {
        if (this.engine.refreshOnRender()) {
            return;
        }
        ArrayList<TemplateClass> modifieds = new ArrayList<TemplateClass>();
        for (TemplateClass tc : this.engine.classes.all()) {
            if (!tc.refresh()) continue;
            modifieds.add(tc);
        }
        HashSet<TemplateClass> modifiedWithDependencies = new HashSet<TemplateClass>();
        modifiedWithDependencies.addAll(modifieds);
        ArrayList<ClassDefinition> newDefinitions = new ArrayList<ClassDefinition>();
        boolean dirtySig = false;
        for (TemplateClass tc : modifiedWithDependencies) {
            if (tc.compile() == null) {
                this.engine.classes.remove(tc);
                this.currentState = new TemplateClassloaderState();
                continue;
            }
            int sigChecksum = tc.sigChecksum;
            tc.enhance();
            if (sigChecksum != tc.sigChecksum) {
                dirtySig = true;
            }
            newDefinitions.add(new ClassDefinition(tc.javaClass, tc.enhancedByteCode));
            this.currentState = new TemplateClassloaderState();
        }
        if (newDefinitions.size() > 0) {
            IHotswapAgent agent = this.engine.hotswapAgent;
            if (null != agent) {
                try {
                    agent.reload(newDefinitions.toArray(new ClassDefinition[newDefinitions.size()]));
                }
                catch (Throwable e) {
                    throw new ClassReloadException("Need Reload");
                }
            } else {
                throw new ClassReloadException("Need Reload");
            }
        }
        if (dirtySig) {
            throw new ClassReloadException("Signature change !");
        }
        int hash = this.computePathHash();
        if (hash != this.pathHash) {
            for (TemplateClass tc : this.engine.classes.all()) {
                if (tc.templateResource.isValid()) continue;
                this.engine.classes.remove(tc);
                this.currentState = new TemplateClassloaderState();
            }
            throw new ClassReloadException("Path has changed");
        }
    }

    int computePathHash() {
        return this.classStateHashCreator.computePathHash(this.engine.tmpDir);
    }

    public static class TemplateClassloaderState {
        private static AtomicLong nextStateValue = new AtomicLong();
        private final long currentStateValue = nextStateValue.getAndIncrement();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateClassloaderState that = (TemplateClassloaderState)o;
            return this.currentStateValue == that.currentStateValue;
        }

        public int hashCode() {
            return (int)(this.currentStateValue ^ this.currentStateValue >>> 32);
        }
    }

    public static class ClassStateHashCreator {
        private final Pattern classDefFinderPattern = Pattern.compile("\\s+class\\s([a-zA-Z0-9_]+)\\s+");
        private final Map<File, FileWithClassDefs> classDefsInFileCache = new HashMap<File, FileWithClassDefs>();

        public synchronized int computePathHash(File ... paths) {
            StringBuffer buf = new StringBuffer();
            for (File file : paths) {
                this.scan(buf, file);
            }
            return buf.toString().hashCode();
        }

        private void scan(StringBuffer buf, File current) {
            File[] fa;
            if (!current.isDirectory()) {
                if (current.getName().endsWith(".java")) {
                    buf.append(this.getClassDefsForFile(current));
                }
            } else if (!current.getName().startsWith(".") && null != (fa = current.listFiles())) {
                for (File file : current.listFiles()) {
                    this.scan(buf, file);
                }
            }
        }

        private String getClassDefsForFile(File file) {
            FileWithClassDefs fileWithClassDefs = this.classDefsInFileCache.get(file);
            if (fileWithClassDefs != null && fileWithClassDefs.fileNotChanges()) {
                return fileWithClassDefs.getClassDefs();
            }
            StringBuilder buf = new StringBuilder();
            Matcher matcher = this.classDefFinderPattern.matcher(IO.readContentAsString(file));
            buf.append(file.getName());
            buf.append("(");
            while (matcher.find()) {
                buf.append(matcher.group(1));
                buf.append(",");
            }
            buf.append(")");
            String classDefs = buf.toString();
            this.classDefsInFileCache.put(file, new FileWithClassDefs(file, classDefs));
            return classDefs;
        }

        private static class FileWithClassDefs {
            private final File file;
            private final long size;
            private final long lastModified;
            private final String classDefs;

            private FileWithClassDefs(File file, String classDefs) {
                this.file = file;
                this.classDefs = classDefs;
                this.size = file.length();
                this.lastModified = file.lastModified();
            }

            public boolean fileNotChanges() {
                return this.size == this.file.length() && this.lastModified == this.file.lastModified();
            }

            public String getClassDefs() {
                return this.classDefs;
            }
        }
    }
}

