/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.BlockToken;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class DefTagParser
extends KeywordParserFactory {
    public Keyword keyword() {
        return Keyword.TAG;
    }

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                Regex r = DefTagParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @tag, correct usage: @tag([arguments...])", new Object[0]);
                }
                this.step(r.stringMatched().length());
                String tagName = r.stringMatched(1);
                String signature = r.stringMatched(2);
                return new DefTagToken(tagName, signature, this.ctx());
            }
        };
    }

    protected String patternStr() {
        return "^%s%s\\s+([_a-zA-Z][\\w_$]*)\\s*((?@()))\\s*{\\s*\\r*\\n*";
    }

    public static void main(String[] args) {
        String s;
        DefTagParser tp = new DefTagParser();
        Regex r = tp.reg(new Rythm());
        if (r.search(s = "@tag myTag(String x, User y) {\\n y.name: x\\n}")) {
            System.out.println("m " + r.stringMatched());
            System.out.println(1 + r.stringMatched(1));
            System.out.println(2 + r.stringMatched(2));
            System.out.println(3 + r.stringMatched(3));
            System.out.println(4 + r.stringMatched(4));
        }
    }

    private static class DefTagToken
    extends BlockToken {
        String tagName;
        String signature;

        public DefTagToken(String tagName, String signature, IContext context) {
            super("", context);
            this.tagName = tagName;
            this.signature = signature;
            this.ctx.getCodeBuilder().defTag(tagName, signature);
        }

        public void openBlock() {
        }

        public String closeBlock() {
            this.ctx.getCodeBuilder().endTag();
            return "";
        }
    }
}

