/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.PatternStr;
import com.greenlaw110.rythm.internal.parser.build_in.ForEachCodeToken;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class ForEachParser
extends KeywordParserFactory {
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                Regex r = new Regex(String.format(ForEachParser.this.patternStr(), this.dialect().a(), ForEachParser.this.keyword()));
                if (!r.search(this.remain())) {
                    return null;
                }
                String s = r.stringMatched(1);
                this.step(s.length());
                String type = r.stringMatched(5);
                String varname = r.stringMatched(6);
                String iterable = r.stringMatched(8);
                if (S.isEmpty(iterable)) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @for statement, correct usage: @for(Type var: iterable){...}", new Object[0]);
                }
                return new ForEachCodeToken(type, varname, iterable, this.ctx());
            }
        };
    }

    public Keyword keyword() {
        return Keyword.EACH;
    }

    protected String patternStr() {
        return "(%s%s(\\s+|\\s*\\(\\s*)((" + (Object)((Object)PatternStr.Type) + ")(\\s+(" + (Object)((Object)PatternStr.VarName) + "))?)\\s*\\:\\s*(" + (Object)((Object)PatternStr.Expression2) + ")(\\s*\\)?[\\s\\r\\n]*|[\\s\\r\\n]+)\\{?[\\s\\r\\n]*).*";
    }

    public static void main(String[] args) {
        String s;
        Regex r = new ForEachParser().reg(new Rythm());
        if (r.search(s = "@for(Client client: clients) {\nHello world")) {
            System.out.println(1 + r.stringMatched(1));
            System.out.println(2 + r.stringMatched(2));
            System.out.println(3 + r.stringMatched(3));
            System.out.println(4 + r.stringMatched(4));
            System.out.println(5 + r.stringMatched(5));
            System.out.println(6 + r.stringMatched(6));
            System.out.println(7 + r.stringMatched(7));
            System.out.println(8 + r.stringMatched(8));
        }
    }
}

